/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.DynamicSystemRequest;
import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ServiceResponseWithOutcome;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.api.SystemInfo;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildInteraction;
import java.io.File;

public abstract class BuildInteraction
implements ISonargraphBuildInteraction {
    protected final ISonargraphBuildClient m_client;

    protected BuildInteraction(ISonargraphBuildClient client) {
        assert (client != null) : "Parameter 'client' of method 'BuildInteraction' must not be null";
        this.m_client = client;
    }

    private boolean hasModulesAndRootDirectories(DynamicSystemRequest dynamicSystemRequest) {
        SystemInfo systemInfo = dynamicSystemRequest.getSystemInfo();
        if (systemInfo == null) {
            this.m_client.info("Dynamic reporting is requested but system info could not be determined.\n");
            return false;
        }
        if (systemInfo.getModules().isEmpty()) {
            this.m_client.info("Dynamic reporting is requested but system info does not contain any modules.\n");
            return false;
        }
        if (systemInfo.getModules().stream().mapToInt(m -> m.getNumberOfRootDirectories()).sum() == 0) {
            this.m_client.info("Dynamic reporting is requested but system info does not contain any root directories.\n");
            return false;
        }
        return true;
    }

    protected ServiceResponseWithOutcome<File> generateDynamicSystem(DynamicSystemRequest dynamicSystemRequest, ISonargraphBuild sonargraphBuild, ILogger logger) throws SonargraphBuildException {
        ServiceResponseWithOutcome<File> create;
        if (!this.hasModulesAndRootDirectories(dynamicSystemRequest)) {
            return new ServiceResponseWithOutcome<File>(StatusCode.OK, "Nothing to be done, since workspace info indicates a resource-only project.");
        }
        File qualityModelFile = this.getQualityModelPath(dynamicSystemRequest.getQualityModelFile());
        if (qualityModelFile != null) {
            logger.info("Create system using quality model: " + qualityModelFile.getName());
        }
        if ((create = sonargraphBuild.createDynamicSystem(dynamicSystemRequest.getSystemInfo(), qualityModelFile)).isFailure()) {
            return create;
        }
        if (!create.getOutcome().isPresent()) {
            throw new SonargraphBuildException("Dynamic system creation failed for unknown reasons. Please check the log file");
        }
        logger.info("Dynamic system created in: " + create.getOutcome().get().getAbsolutePath());
        return create;
    }

    protected void validateDynamicSystemRequest(StringBuilder errorMsg, DynamicSystemRequest request) {
        assert (errorMsg != null) : "Parameter 'errorMsg' of method 'validateDynamicSystemReequest' must not be null";
        assert (request != null) : "Parameter 'request' of method 'validateDynamicSystemReequest' must not be null";
    }

    protected File getQualityModelPath(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return new File(path.trim());
    }
}

