/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import java.nio.file.Paths;

public final class RootPathInfo {
    private final String m_absolutePath;
    private final Category m_category;

    public RootPathInfo(String path, Category category) {
        this.m_absolutePath = Paths.get(path, new String[0]).toAbsolutePath().normalize().toString().replace("\\", "/");
        this.m_category = category;
    }

    public String getAbsolutePath() {
        return this.m_absolutePath;
    }

    public Category getCategory() {
        return this.m_category;
    }

    public String toString() {
        return this.m_absolutePath + "(" + String.valueOf((Object)this.m_category) + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_absolutePath == null ? 0 : this.m_absolutePath.hashCode());
        result = 31 * result + (this.m_category == null ? 0 : this.m_category.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootPathInfo other = (RootPathInfo)obj;
        if (this.m_absolutePath == null ? other.m_absolutePath != null : !this.m_absolutePath.equals(other.m_absolutePath)) {
            return false;
        }
        return this.m_category == other.m_category;
    }

    public static enum Category {
        SOURCE,
        GENERATED_SOURCE,
        OUT;

    }
}

