/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.scm.Commit;
import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BranchCommits
implements Commit.IBranchCommits {
    private static final String SCM = "scm";
    private static final String BRANCH = "branch";
    private String m_scmName;
    private String m_branchName;
    private final List<Commit> m_commits = new ArrayList<Commit>(500);
    private final Map<String, Commit> m_commitMap = new THashMap(500);

    public BranchCommits() {
    }

    public BranchCommits(String scmName, String branchName) {
        assert (scmName != null && scmName.length() > 0) : "Parameter 'scmName' of method 'BranchCommits' must not be empty";
        assert (branchName != null && branchName.length() > 0) : "Parameter 'branchName' of method 'BranchCommits' must not be empty";
        this.m_branchName = branchName;
        this.m_scmName = scmName;
    }

    @Override
    public void addCommit(Commit commit) {
        assert (commit != null) : "Parameter 'commit' of method 'addCommit' must not be null";
        this.m_commits.add(commit);
        this.m_commitMap.put(commit.getId(), commit);
    }

    public void sort() {
        this.m_commits.sort((c1, c2) -> -Long.signum(c1.getTimeStamp() - c2.getTimeStamp()));
    }

    public Commit getCommit(String id) {
        return this.m_commitMap.get(id);
    }

    public String getScmName() {
        return this.m_scmName;
    }

    public String getBranchName() {
        return this.m_branchName;
    }

    public List<Commit> getCommits() {
        return this.m_commits;
    }

    public void writeAttributes(IObjectWriter writer) throws IOException {
        writer.writeString(SCM, this.m_scmName);
        writer.writeString(BRANCH, this.m_branchName);
    }

    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        this.m_scmName = reader.readString(SCM);
        this.m_branchName = reader.readString(BRANCH);
    }

    public List<? extends IPersistable> getPersistableChildren() {
        return this.m_commits;
    }

    public boolean isEqualTo(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BranchCommits other = (BranchCommits)obj;
        if (this.m_branchName == null ? other.m_branchName != null : !this.m_branchName.equals(other.m_branchName)) {
            return false;
        }
        if (this.m_commits == null) {
            if (other.m_commits != null) {
                return false;
            }
        } else {
            if (this.m_commits.size() != other.m_commits.size()) {
                return false;
            }
            int i = 0;
            while (i < this.m_commits.size()) {
                if (!this.m_commits.get(i).isEqualTo(other.m_commits.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        if (this.m_scmName == null && other.m_scmName != null) {
            return false;
        }
        return this.m_scmName.equals(other.m_scmName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_branchName).append(":\n");
        this.m_commits.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append("  ").append(c).append('\n');
        });
        return sb.toString();
    }
}

