/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusUnboundExternalFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.settings.CPlusPlusUserDefinedUnboundExternalFilter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings.ObjectFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings.XsdSoftwareSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings.XsdUnboundExternalFilter;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class CPlusPlusSoftwareSystemSettingsPersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.settings";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/languageprovider/cplusplus/persistence/system/settings/cplusplusSoftwareSystemSettings";
    private final Version m_version;
    private final XmlPersistenceContext m_persistenceContext;

    public CPlusPlusSoftwareSystemSettingsPersistence(Version version) {
        assert (version != null) : "Parameter 'version' of method 'CPlusPlusSoftwareSystemSettingsPersistence' must not be null";
        this.m_version = version;
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CPlusPlusResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
    }

    private JaxbAdapter<JAXBElement<XsdSoftwareSystemSettings>> createJaxbAdapter() {
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter((ClassLoader)classLoader, (XmlPersistenceContext)this.m_persistenceContext);
    }

    private OperationResultWithOutcome<XsdSoftwareSystemSettings> loadFromStream(InputStream inputStream) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading C,C++ system settings from stream");
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result);
        JAXBElement element = (JAXBElement)this.createJaxbAdapter().load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "C,C++ system settings loaded from stream is corrupt", new Object[0]);
            return result;
        }
        result.setOutcome((Object)((XsdSoftwareSystemSettings)element.getValue()));
        return result;
    }

    private final boolean isPatternValid(String kind, String pattern, Set<String> patternsProvided, OperationResult result) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'isPatternValid' must not be empty";
        assert (patternsProvided != null) : "Parameter 'patternsProvided' of method 'isPatternValid' must not be null";
        assert (result != null) : "Parameter 'result' of method 'isPatternValid' must not be null";
        if (pattern == null || pattern.isEmpty()) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.INVALID_PATTERN, "Ignored empty " + kind + " pattern.", new Object[0]);
            return false;
        }
        if (!patternsProvided.add(pattern)) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.DUPLICATE_PATTERN, "Ignored duplicate " + kind + " pattern '" + pattern + "'.", new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isCustomPatternValid(String kind, String pattern, OperationResult result) {
        assert (kind != null && kind.length() > 0) : "Parameter 'kind' of method 'isCustomPatternValid' must not be empty";
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'isCustomPatternValid' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'isCustomPatternValid' must not be null";
        try {
            CustomPattern.compileWildcardPattern((String)pattern, (boolean)false);
            return true;
        }
        catch (IllegalArgumentException e) {
            result.addWarning((OperationResult.IMessageCause)MessageCause.INVALID_PATTERN, "Ignore " + kind + " pattern '" + pattern + "'.", new Object[0]);
            return false;
        }
    }

    private OperationResult load(InputStream in, NamedElement parent) {
        assert (in != null) : "Parameter 'in' of method 'load' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'load' must not be null";
        OperationResultWithOutcome<XsdSoftwareSystemSettings> result = this.loadFromStream(in);
        if (result.isSuccess()) {
            XsdSoftwareSystemSettings xsdSoftwareSystemSettings = (XsdSoftwareSystemSettings)result.getOutcome();
            assert (xsdSoftwareSystemSettings != null) : "'xsdSoftwareSystemSettings' of method 'load' must not be null";
            XsdUnboundExternalFilter xsdUnboundExternalFilter = xsdSoftwareSystemSettings.getUnboundExternalFilter();
            if (xsdUnboundExternalFilter != null) {
                CPlusPlusUserDefinedUnboundExternalFilter unboundExternalFilter = new CPlusPlusUserDefinedUnboundExternalFilter(parent);
                parent.addChild((NamedElement)unboundExternalFilter);
                THashSet patterns = new THashSet();
                for (String nextInclude : xsdUnboundExternalFilter.getInclude()) {
                    if (!this.isPatternValid("include", nextInclude, (Set<String>)patterns, (OperationResult)result) || CustomPattern.containsWildcardPatternCharacter((String)nextInclude) && !this.isCustomPatternValid("include", nextInclude, (OperationResult)result)) continue;
                    unboundExternalFilter.addChild((NamedElement)new WildcardPatternInclude((NamedElement)unboundExternalFilter, nextInclude));
                }
                for (String nextExclude : xsdUnboundExternalFilter.getExclude()) {
                    if (!this.isPatternValid("exclude", nextExclude, (Set<String>)patterns, (OperationResult)result) || CustomPattern.containsWildcardPatternCharacter((String)nextExclude) && !this.isCustomPatternValid("exclude", nextExclude, (OperationResult)result)) continue;
                    unboundExternalFilter.addChild((NamedElement)new WildcardPatternExclude((NamedElement)unboundExternalFilter, nextExclude));
                }
            }
        }
        return result;
    }

    public OperationResult load(TFile file, NamedElement parent) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'load' must not be null";
        OperationResult result = new OperationResult("Load C,C++ system settings file '" + file.getName() + "'");
        if (!file.exists() || !file.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Cannot read C,C++ system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[0]);
            return result;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream in = new TFileInputStream((File)file);){
                OperationResult loadResult = this.load((InputStream)in, parent);
                result.addMessagesFrom(loadResult);
                if (result.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Failed to process C,C++ system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, String.format("Cannot read C,C++ system settings file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e});
        }
        return result;
    }

    private JAXBElement<XsdSoftwareSystemSettings> convertPojoToXml(NamedElement parent) {
        assert (parent != null) : "Parameter 'parent' of method 'convertPojoToXml' must not be null";
        ObjectFactory xsdObjectFactory = new ObjectFactory();
        XsdSoftwareSystemSettings xsdSoftwareSystemSettings = xsdObjectFactory.createXsdSoftwareSystemSettings();
        xsdSoftwareSystemSettings.setVersion(this.m_version.toString());
        XsdUnboundExternalFilter xsdUnboundExternalFilter = xsdObjectFactory.createXsdUnboundExternalFilter();
        xsdSoftwareSystemSettings.setUnboundExternalFilter(xsdUnboundExternalFilter);
        CPlusPlusUnboundExternalFilter unboundExternalFilter = (CPlusPlusUnboundExternalFilter)((Object)parent.getUniqueChild(CPlusPlusUnboundExternalFilter.class));
        if (unboundExternalFilter != null) {
            for (WildcardPatternInclude next : unboundExternalFilter.getChildren(WildcardPatternInclude.class)) {
                xsdUnboundExternalFilter.getInclude().add(next.getName());
            }
            for (WildcardPatternInclude next : unboundExternalFilter.getChildren(WildcardPatternExclude.class)) {
                xsdUnboundExternalFilter.getExclude().add(next.getName());
            }
        }
        return xsdObjectFactory.createSystemSettings(xsdSoftwareSystemSettings);
    }

    private final OperationResult save(NamedElement parent, OutputStream out) {
        assert (parent != null) : "Parameter 'parent' of method 'save' must not be null";
        assert (out != null) : "Parameter 'out' of method 'save' must not be null";
        OperationResult result = new OperationResult("Saving C,C++ system settings to stream");
        JAXBElement<XsdSoftwareSystemSettings> element = this.convertPojoToXml(parent);
        if (element == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to convert C,C++ system settings to XML.", new Object[0]);
            return result;
        }
        try {
            this.createJaxbAdapter().save(element, out);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
        return result;
    }

    public OperationResult save(NamedElement parent, TFile file) {
        assert (parent != null) : "Parameter 'parent' of method 'save' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult result = new OperationResult("Save C,C++ system settings to file '" + file.getNormalizedAbsolutePath() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileOutputStream out = new TFileOutputStream((File)file);){
                OperationResult save = this.save(parent, (OutputStream)out);
                result.addMessagesFrom(save);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, String.format("Failed to save C,C++ system settings to file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e});
            return result;
        }
    }

    private static enum MessageCause implements OperationResult.IMessageCause
    {
        INVALID_PATTERN,
        DUPLICATE_PATTERN;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

