/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.Path;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplatePropertyList;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SysInclude;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InstCompilerDefinitionTemplateIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InstNonExistingIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InvalidSysIncludeIssue;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class InstCompilerDefinition
extends NamedElementContainer {
    public static final String HEADER_SECTION = "Header";
    public static final String C_SECTION = "C Options";
    public static final String CPP_SECTION = "CPlusPlus Options";
    public static final String COMMON_SECTION = "Common Options";
    public static final String TRANSLATION_SECTION = "Option Translations";
    public static final String FIXED_CONFIG_SECTION = "Fixed Configuration Properties";
    public static final String REMOVE_OPTION_KEYWORD = "REMOVE";
    private String m_compiler;
    private String m_description = "";
    private int m_pointerSize = 4;
    private int m_longSize = 4;
    private int m_wideCharSize = 4;
    private Map<String, String> m_fixedConfigProperties;

    public InstCompilerDefinition(NamedElement parent, String compiler) {
        super(parent);
        assert (compiler != null && compiler.length() > 0);
        this.m_compiler = compiler;
    }

    public String getCompiler() {
        return this.m_compiler;
    }

    public void setCompiler(String compiler) {
        assert (compiler != null) : "Parameter 'compiler' of method 'setCompiler' must not be null";
        this.m_compiler = compiler;
    }

    public String addImplicitCommonOptions(String rawText) {
        return rawText;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getPointerSize() {
        return this.m_pointerSize;
    }

    public int getLongSize() {
        return this.m_longSize;
    }

    public int getWideCharSize() {
        return this.m_wideCharSize;
    }

    public Map<String, String> getFixedConfigProperties() {
        if (this.m_fixedConfigProperties == null) {
            return null;
        }
        return new LinkedHashMap<String, String>(this.m_fixedConfigProperties);
    }

    public final String getImageResourceName() {
        return InstCompilerDefinition.class.getSimpleName();
    }

    public boolean isAnyDefinition() {
        return false;
    }

    public Result validate(boolean addIssues) {
        String message;
        Result result = new Result();
        if (this.isAnyDefinition()) {
            return result;
        }
        assert (this.getParent() != null) : "Parent of element '" + this.getName() + "' must not be null!";
        if (addIssues) {
            this.removeIssues();
        }
        boolean isFailure = false;
        if (this.m_pointerSize != 4 && this.m_pointerSize != 8) {
            if (addIssues) {
                message = "Invalid value for pointerSize: " + this.m_pointerSize;
                this.addIssue((Issue)new InstCompilerDefinitionTemplateIssue((NamedElement)this, message));
            }
            isFailure = true;
        }
        if (this.m_longSize != 4 && this.m_longSize != 8) {
            if (addIssues) {
                message = "Invalid value for longSize: " + this.m_longSize;
                this.addIssue((Issue)new InstCompilerDefinitionTemplateIssue((NamedElement)this, message));
            }
            isFailure = true;
        }
        if (this.validateTemplate((GroovyTemplateElement)((Object)this.getUniqueChild((NamedElement.IFilter)new NameFilter(CPP_SECTION), GroovyTemplateElement.class)), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateTemplate((GroovyTemplateElement)((Object)this.getUniqueChild((NamedElement.IFilter)new NameFilter(C_SECTION), GroovyTemplateElement.class)), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateTemplate((GroovyTemplateElement)((Object)this.getUniqueChild((NamedElement.IFilter)new NameFilter(COMMON_SECTION), GroovyTemplateElement.class)), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateTemplate((GroovyTemplateElement)((Object)this.getUniqueChild((NamedElement.IFilter)new NameFilter(TRANSLATION_SECTION), GroovyTemplateElement.class)), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateOptions(CPP_SECTION, this.getCppOptions(), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateOptions(C_SECTION, this.getCOptions(), addIssues).isFailure()) {
            isFailure = true;
        }
        if (this.validateOptions(COMMON_SECTION, this.getCommonOptions(), addIssues).isFailure()) {
            isFailure = true;
        }
        if (isFailure) {
            result.addErrorMessage("Compiler definition '" + this.getName() + "' has errors.");
        }
        return result;
    }

    private Result validateTemplate(GroovyTemplateElement template, boolean addIssues) {
        Result result = new Result();
        if (template == null) {
            return result;
        }
        if (template.getErrorMessage() != null) {
            if (addIssues) {
                this.addIssue((Issue)new InstCompilerDefinitionTemplateIssue((NamedElement)this, template.getErrorMessage()));
            }
            result.addErrorMessage(template.getErrorMessage());
        }
        return result;
    }

    private Result validateOptions(String name, CompilerOptions options, boolean addIssues) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'validateOptions' must not be empty";
        Result overallResult = new Result();
        if (options == null) {
            overallResult.addErrorMessage("'" + name + "' not found.");
            return overallResult;
        }
        boolean isFailure = false;
        for (ICompilerOption option : options.getChildren(ICompilerOption.class)) {
            Result result = option.validate();
            if (!result.isFailure()) continue;
            if (option instanceof IncludeOption) {
                if (addIssues) {
                    this.addIssue((Issue)new InstNonExistingIncludeIssue((NamedElement)this, options.getName() + " issue: " + result.getErrorMessage()));
                }
            } else if (option instanceof SysInclude && addIssues) {
                this.addIssue((Issue)new InvalidSysIncludeIssue((NamedElement)this, options.getName() + " issue: " + result.getErrorMessage()));
            }
            isFailure = true;
        }
        if (isFailure) {
            overallResult.addErrorMessage("'" + name + "' contain errors.");
        }
        return overallResult;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    public void setPointerSize(int value) {
        this.m_pointerSize = value;
    }

    public void setLongSize(int value) {
        this.m_longSize = value;
    }

    public void setWideCharSize(int wideCharSize) {
        this.m_wideCharSize = wideCharSize;
    }

    public CompilerOptions getCppOptions() {
        return (CompilerOptions)((Object)this.getFirstChild((NamedElement.IFilter)new ShortNameFilter(CPP_SECTION), CompilerOptions.class));
    }

    public CompilerOptions getCOptions() {
        return (CompilerOptions)((Object)this.getFirstChild((NamedElement.IFilter)new ShortNameFilter(C_SECTION), CompilerOptions.class));
    }

    public CompilerOptions getCommonOptions() {
        return (CompilerOptions)((Object)this.getFirstChild((NamedElement.IFilter)new ShortNameFilter(COMMON_SECTION), CompilerOptions.class));
    }

    public Collection<TFile> getSystemInclueDirectories() {
        THashSet result = new THashSet();
        this.getCppOptions().getChildren(SysInclude.class).forEach(arg_0 -> InstCompilerDefinition.lambda$0((Set)result, arg_0));
        this.getCOptions().getChildren(SysInclude.class).forEach(arg_0 -> InstCompilerDefinition.lambda$1((Set)result, arg_0));
        this.getCommonOptions().getChildren(SysInclude.class).forEach(arg_0 -> InstCompilerDefinition.lambda$2((Set)result, arg_0));
        return result;
    }

    public List<String> listCOptions() {
        ArrayList<String> result = new ArrayList<String>();
        CompilerOptions options = this.getCOptions();
        if (options != null) {
            result.addAll(options.getOptions());
        }
        if ((options = this.getCommonOptions()) != null) {
            result.addAll(options.getOptions());
        }
        return result;
    }

    public List<String> listCppOptions() {
        ArrayList<String> result = new ArrayList<String>();
        CompilerOptions options = this.getCppOptions();
        if (options != null) {
            result.addAll(options.getOptions());
        }
        if ((options = this.getCommonOptions()) != null) {
            result.addAll(options.getOptions());
        }
        return result;
    }

    private GroovyTemplatePropertyList getTranslationTable() {
        return (GroovyTemplatePropertyList)((Object)this.getFirstChild((NamedElement.IFilter)new ShortNameFilter(TRANSLATION_SECTION), GroovyTemplatePropertyList.class));
    }

    public String translateOption(String option, String defaultValue) {
        GroovyTemplatePropertyList translationTable = this.getTranslationTable();
        return this.innerTranslateOption(option, defaultValue, translationTable);
    }

    private String innerTranslateOption(String option, String defaultValue, GroovyTemplatePropertyList translationTable) {
        if (translationTable == null) {
            return defaultValue;
        }
        String translation = translationTable.getStringProperty(option, defaultValue);
        if (translation.equals(REMOVE_OPTION_KEYWORD)) {
            return "";
        }
        return translation;
    }

    protected String stripOffFileExtensionFromName(String fileName) {
        int dotPos = fileName.lastIndexOf(".");
        if (dotPos < 0) {
            return fileName;
        }
        return fileName.substring(0, dotPos);
    }

    public void setFixedConfigProperties(Map<String, String> fixedConfigProperties) {
        assert (fixedConfigProperties != null) : "Parameter 'fixedConfigProperties' of method 'setFixedConfigProperties' must not be null";
        this.m_fixedConfigProperties = new LinkedHashMap<String, String>(fixedConfigProperties);
    }

    public List<TFile> getIncludeDirectories() {
        return this.getChildrenRecursively(Path.class, new Class[0]).stream().map(p -> p.getFile()).filter(f -> f.isDirectory()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$0(Set set, SysInclude si) {
        boolean bl = set.add(si.getFile());
    }

    private static /* synthetic */ void lambda$1(Set set, SysInclude si) {
        boolean bl = set.add(si.getFile());
    }

    private static /* synthetic */ void lambda$2(Set set, SysInclude si) {
        boolean bl = set.add(si.getFile());
    }
}

