/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.analysis.complexity.WeightedAverageCalculator;
import com.hello2morrow.sonargraph.core.controller.system.base.IMetricAwareLanguageProvider;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementProxy;
import com.hello2morrow.sonargraph.core.model.programming.IRoutine;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutineDefinition;
import java.util.function.Function;

final class CPlusPlusAverageComplexityCalculator
extends WeightedAverageCalculator {
    CPlusPlusAverageComplexityCalculator() {
    }

    public void calculateWeightedAverageOnTypes(IWorkerContext workerContext, Module module, IMetricDescriptor md, Function<IRoutine, Integer> metricFunction, IMetricAwareLanguageProvider.IWeightedAverageCalculationConsumer consumer) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateWeightedAverageOnTypes' must not be null";
        for (CppClassStructUnionDefinition cls : module.getChildrenRecursively(CppClassStructUnionDefinition.class, new Class[]{CppClassStructUnionDefinition.class})) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            if (cls.ignoreIssues() || cls.isAnonymous()) continue;
            double totalValue = 0.0;
            double totalSize = 0.0;
            for (CppRoutine method : cls.getChildren(CppRoutine.class)) {
                int size;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                if (!method.isDefinition() && (method = method.getDefinition()) == null || (size = method.getNumberOfStatements()) <= 0) continue;
                totalSize += (double)size;
                totalValue += (double)(size * metricFunction.apply(method));
            }
            for (NamedElementProxy proxy : cls.getChildren(NamedElementProxy.class)) {
                CppRoutineDefinition method;
                int size;
                NamedElement e = proxy.getElement();
                if (!(e instanceof CppRoutineDefinition) || (size = (method = (CppRoutineDefinition)e).getNumberOfStatements()) <= 0) continue;
                totalSize += (double)size;
                totalValue += (double)(size * metricFunction.apply(method));
            }
            if (totalSize > 0.0) {
                double avgValue = totalValue / totalSize;
                consumer.consume((NamedElement)cls, (Number)avgValue, consumer.getMetricOnTypesDescriptor());
                consumer.addToSizeMap((NamedElement)cls, (Number)totalSize);
                consumer.addToValueMap((NamedElement)cls, (Number)avgValue);
                continue;
            }
            consumer.consume((NamedElement)cls, (Number)0.0, consumer.getMetricOnTypesDescriptor());
        }
    }
}

