/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.foundation.file.DirectoryScanner;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.ICaptureConstants;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.SourceBeanFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class KeilImportHelper
implements DirectoryScanner.IFileConsumer,
ICaptureConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeilImportHelper.class);
    private final SourceBeanFactory m_factory = new SourceBeanFactory();
    private final String m_rootDir;
    private final StringBuilder m_buffer;

    private KeilImportHelper(TFile keilProjectFile, StringBuilder buffer) {
        TFile projectDir = keilProjectFile.getParentFile();
        assert (projectDir != null) : "Keil project file should have a parent";
        this.m_rootDir = projectDir.getNormalizedAbsolutePath();
        this.m_buffer = buffer;
    }

    private List<DirectoryBean> doImport(TFile keilProjectFile) {
        DirectoryScanner scanner = new DirectoryScanner(LanguageProvider.getIgnoreDirectories(), false);
        scanner.scan(keilProjectFile.getParentFile(), (DirectoryScanner.IFileConsumer)this);
        return this.m_factory.getRootDirectories();
    }

    public static List<DirectoryBean> importKeilProject(TFile keilProjectFile, StringBuilder buffer) {
        assert (keilProjectFile != null) : "Parameter 'keilProjectFile' of method 'importKeilProject' must not be null";
        KeilImportHelper helper = new KeilImportHelper(keilProjectFile, buffer);
        return helper.doImport(keilProjectFile);
    }

    public IFileType accepts(TFile file) {
        return CPlusPlusFileType.KEIL_BATCH_FRAGMENT.hasExtension(FileUtility.getExtension((TFile)file)) ? CPlusPlusFileType.KEIL_BATCH_FRAGMENT : null;
    }

    public void consume(TFile rootPathBeingScanned, TFile file, IFileType fileType) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader((File)file));){
                String line;
                ArrayList<String> words = new ArrayList<String>();
                words.add(String.format("%s'%s'", "capture_cwd=", this.m_rootDir));
                words.add("cc");
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty()) continue;
                    words.addAll(StringUtility.parseQuotedLineIntoWords((String)line));
                    this.m_buffer.append(line).append('\n');
                }
                this.m_factory.processCommand(file.getParentFile(), words);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.error("Problem while reading Keil batch fragment file " + file.getNormalizedPath(), (Throwable)e);
        }
    }
}

