/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractCreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusVisualStudioExtension;
import java.util.List;

public final class CreateNewSolutionFileBasedCPlusPlusSystemCommand
extends AbstractCreateSoftwareSystemCommand {
    private final IInteraction m_interaction;
    private boolean m_canceled;

    public CreateNewSolutionFileBasedCPlusPlusSystemCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'CreateNewVSSolutionFileBasedSystemCommand' must not be null";
        this.m_interaction = interaction;
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.CREATE_VS_SOLUTION_FILE_BASED_SYSTEM;
    }

    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    protected void internalRun(IWorkerContext workerContext) {
        CreateSoftwareSystemCommand createSoftwareSystemCommand = new CreateSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (AbstractCreateSoftwareSystemCommand.IInteraction)this.m_interaction);
        if (!createSoftwareSystemCommand.isEnabled().isSuccess()) {
            return;
        }
        this.runPrerequisiteCommand((Command)createSoftwareSystemCommand, workerContext);
        if (createSoftwareSystemCommand.canceled() || !this.getController().hasSoftwareSystem()) {
            this.m_canceled = true;
            return;
        }
        ImportData importData = new ImportData();
        if (!this.m_interaction.collect(importData)) {
            this.m_canceled = true;
            return;
        }
        ICPlusPlusVisualStudioExtension extension = (ICPlusPlusVisualStudioExtension)this.getController().getSoftwareSystem().getExtension(ICPlusPlusVisualStudioExtension.class);
        OperationResult result = extension.createModulesFromSolutionFileImport(workerContext, importData.getSolutionFileInfo(), importData.getReferencesToImport(), importData.getConfigurationName(), importData.getPlatformName(), ICPlusPlusVisualStudioExtension.ModuleImportMode.SYSTEM_CREATION);
        this.m_interaction.processModuleCreationResult(result);
    }

    public boolean canceled() {
        return this.m_canceled;
    }

    public static interface IInteraction
    extends AbstractCreateSoftwareSystemCommand.IInteraction {
        public boolean collect(ImportData var1);

        public void processModuleCreationResult(OperationResult var1);
    }

    public static final class ImportData
    implements ICommandInteractionData {
        private SolutionFileInfo m_solutionFileInfo;
        private String m_configurationName;
        private String m_platformName;
        private List<IVisualStudioProjectReferenceInfo> m_referencesToImport;

        public void setSolutionFileInfo(SolutionFileInfo solutionFileInfo) {
            this.m_solutionFileInfo = solutionFileInfo;
        }

        public SolutionFileInfo getSolutionFileInfo() {
            return this.m_solutionFileInfo;
        }

        public String getConfigurationName() {
            assert (this.m_configurationName != null) : "'m_configurationName' of method 'getConfigurationName' must not be null";
            return this.m_configurationName;
        }

        public void setConfigurationName(String configurationName) {
            assert (configurationName != null && configurationName.length() > 0) : "Parameter 'configurationName' of method 'setConfigurationName' must not be empty";
            this.m_configurationName = configurationName;
        }

        public String getPlatformName() {
            assert (this.m_platformName != null) : "'m_platformName' of method 'getPlatformName' must not be null";
            return this.m_platformName;
        }

        public void setPlatformName(String platformName) {
            assert (platformName != null && platformName.length() > 0) : "Parameter 'platformName' of method 'setPlatformName' must not be empty";
            this.m_platformName = platformName;
        }

        public void setProjectReferencesToImport(List<IVisualStudioProjectReferenceInfo> referencesToImport) {
            assert (referencesToImport != null && !referencesToImport.isEmpty()) : "Parameter 'referencesToImport' of method 'setProjectReferencesToImport' must not be empty";
            this.m_referencesToImport = referencesToImport;
        }

        public List<IVisualStudioProjectReferenceInfo> getReferencesToImport() {
            return this.m_referencesToImport;
        }
    }
}

