/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spotbugs;

import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.ResultSet;
import com.hello2morrow.sonargraph.plugin.IAnalyzerPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginAnalyzerContributor;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphIntPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.SonargraphStringPluginAttribute;
import com.hello2morrow.sonargraph.plugin.spotbugs.ClassFileRegistry;
import edu.umd.cs.findbugs.BugCategory;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugRankCategory;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.IClassScreener;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpotbugsPlugin
extends SonargraphPlugin
implements IPluginAnalyzerContributor,
BugReporter,
IClassScreener,
FindBugsProgress {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.spotbugs";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpotbugsPlugin.class);
    private static final String ISSUE_ID_ERROR = "SpotbugsIssueError";
    private static final String ISSUE_ID_WARNING = "SpotbugsIssueWarning";
    private static final String ISSUE_ID_INFO = "SpotbugsIssueInfo";
    private static final String ISSUE_NAME_ERROR = "Spotbugs error";
    private static final String ISSUE_NAME_WARNING = "Spotbugs warning";
    private static final String ISSUE_NAME_INFO = "Spotbugs info";
    private static final String JAVA = "Java";
    private final SonargraphStringPluginAttribute m_analysisEffort;
    private final SonargraphIntPluginAttribute m_minimumRank;
    private final SonargraphIntPluginAttribute m_minimumConfidence;
    private final SonargraphBooleanPluginAttribute m_badPractice;
    private final SonargraphBooleanPluginAttribute m_maliciousCodeVulnerability;
    private final SonargraphBooleanPluginAttribute m_correctness;
    private final SonargraphBooleanPluginAttribute m_performance;
    private final SonargraphBooleanPluginAttribute m_security;
    private final SonargraphBooleanPluginAttribute m_dodgyCode;
    private final SonargraphBooleanPluginAttribute m_multithreadedCorrectness;
    private final SonargraphBooleanPluginAttribute m_internationalization;
    private final SonargraphBooleanPluginAttribute m_experimental;
    private final SonargraphStringPluginAttribute m_scariest;
    private final SonargraphStringPluginAttribute m_scary;
    private final SonargraphStringPluginAttribute m_troubling;
    private final SonargraphStringPluginAttribute m_ofConcern;
    private IPluginIssueId m_errorIssue;
    private IPluginIssueId m_warningIssue;
    private IPluginIssueId m_infoIssue;
    private ClassFileRegistry m_classFileRegistry;
    private IAnalyzerPluginContext m_context;
    private ResultSet m_result;
    private ProjectStats m_projectStats;
    private BugCollection m_bugCollection;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$edu$umd$cs$findbugs$BugRankCategory;

    public SpotbugsPlugin() {
        LOGGER.debug("[" + this.getId() + "] Create");
        this.m_analysisEffort = new SonargraphStringPluginAttribute("analysisEffort", "Analysis Effort", "Set Spotbugs analysis effort", "Basic", "default", Arrays.asList("Maximum", "Default", "Minimum"), Arrays.asList("max", "default", "min"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_analysisEffort);
        this.m_minimumRank = new SonargraphIntPluginAttribute("minimumRank", "Minimum Rank", "Minimum rank to report (1 is most severe, 20 is least)", "Basic", 14, Arrays.asList("1 (Scariest)", "2 (Scariest)", "3 (Scariest)", "4 (Scariest)", "5 (Scary)", "6 (Scary)", "7 (Scary)", "8 (Scary)", "9 (Scary)", "10 (Troubling)", "11 (Troubling)", "12 (Troubling)", "13 (Troubling)", "14 (Troubling)", "15 (Of Concern)", "16 (Of Concern)", "17 (Of Concern)", "18 (Of Concern)", "19 (Of Concern)", "20 (Of Concern)"), Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_minimumRank);
        this.m_minimumConfidence = new SonargraphIntPluginAttribute("minimumConfidence", "Minimum Confidence", "Minimum confidence to report", "Basic", 2, Arrays.asList("High", "Medium", "Low"), Arrays.asList(1, 2, 3));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_minimumConfidence);
        String categories = "categories";
        this.m_badPractice = new SonargraphBooleanPluginAttribute("badPractice", "Bad practice", "Category 'Bad practice'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_badPractice);
        this.m_maliciousCodeVulnerability = new SonargraphBooleanPluginAttribute("maliciousCodeVulnerability", "Malicious code vulnerability", "Category 'Malicious code vulnerability'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_maliciousCodeVulnerability);
        this.m_correctness = new SonargraphBooleanPluginAttribute("correctness", "Correctness", "Category 'Correctness'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_correctness);
        this.m_performance = new SonargraphBooleanPluginAttribute("performance", "Performance", "Category 'Performance'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_performance);
        this.m_security = new SonargraphBooleanPluginAttribute("security", "Security", "Category 'Security'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_security);
        this.m_dodgyCode = new SonargraphBooleanPluginAttribute("dodgyCode", "Dodgy code", "Category 'Dodgy code'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_dodgyCode);
        this.m_multithreadedCorrectness = new SonargraphBooleanPluginAttribute("multithreadedCorrectness", "Multithreaded correctness", "Category 'Multithreaded correctness'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_multithreadedCorrectness);
        this.m_internationalization = new SonargraphBooleanPluginAttribute("internationalization", "Internationalization", "Category 'Internationalization'", "categories", true);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_internationalization);
        this.m_experimental = new SonargraphBooleanPluginAttribute("experimental", "Experimental", "Category 'Experimental'", "categories", false);
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_experimental);
        String rank = "rank";
        this.m_scariest = new SonargraphStringPluginAttribute("scariest", "Scariest", "Mark bugs with rank 'Scariest' as ...", "rank", "warning", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_scariest);
        this.m_scary = new SonargraphStringPluginAttribute("scary", "Scary", "Mark bugs with rank 'Scary' as ...", "rank", "warning", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_scary);
        this.m_troubling = new SonargraphStringPluginAttribute("troubling", "Troubling", "Mark bugs with rank 'Troubling' as ...", "rank", "warning", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_troubling);
        this.m_ofConcern = new SonargraphStringPluginAttribute("ofConcern", "Of Concern", "Mark bugs with rank 'Of Concern' as ...", "rank", "warning", Arrays.asList("Error", "Warning", "Info"), Arrays.asList("error", "warning", "info"));
        this.addAttributeDefinition((SonargraphPluginAttribute)this.m_ofConcern);
        LOGGER.debug("[" + this.getId() + "] Instantiated");
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Uses Spotbugs to detect issues.";
    }

    public String getAvailableForLanguages() {
        return JAVA;
    }

    public String getPresentationName() {
        return "Sonargraph Spotbugs Plugin";
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton(JAVA);
    }

    public IPluginAnalyzerContributor getAnalyzerContributor() {
        return this;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        LOGGER.debug("[" + this.getId() + "] Initialize");
        this.m_errorIssue = contributor.createIssueId(ISSUE_ID_ERROR, ISSUE_NAME_ERROR, PluginIssueSeverity.ERROR, PluginIssueType.ELEMENT);
        this.m_warningIssue = contributor.createIssueId(ISSUE_ID_WARNING, ISSUE_NAME_WARNING, PluginIssueSeverity.WARNING, PluginIssueType.ELEMENT);
        this.m_infoIssue = contributor.createIssueId(ISSUE_ID_INFO, ISSUE_NAME_INFO, PluginIssueSeverity.INFO, PluginIssueType.ELEMENT);
        LOGGER.debug("[" + this.getId() + "] Initialize - done");
    }

    public void cleared(IPluginContext context) {
        LOGGER.debug("[" + this.getId() + "] Cleared");
    }

    private Set<DetectorFactory> getDetectorFactories() {
        BugCategory correctness;
        ArrayList<String> bugCategories = new ArrayList<String>();
        if (this.m_badPractice.getValue().booleanValue()) {
            BugCategory badPractice = DetectorFactoryCollection.instance().getBugCategory("BAD_PRACTICE");
            bugCategories.add(badPractice.getCategory());
        }
        if (this.m_maliciousCodeVulnerability.getValue().booleanValue()) {
            BugCategory maliciousCode = DetectorFactoryCollection.instance().getBugCategory("MALICIOUS_CODE");
            bugCategories.add(maliciousCode.getCategory());
        }
        if (this.m_correctness.getValue().booleanValue()) {
            correctness = DetectorFactoryCollection.instance().getBugCategory("CORRECTNESS");
            bugCategories.add(correctness.getCategory());
        }
        if (this.m_performance.getValue().booleanValue()) {
            BugCategory performance = DetectorFactoryCollection.instance().getBugCategory("PERFORMANCE");
            bugCategories.add(performance.getCategory());
        }
        if (this.m_security.getValue().booleanValue()) {
            BugCategory security = DetectorFactoryCollection.instance().getBugCategory("SECURITY");
            bugCategories.add(security.getCategory());
        }
        if (this.m_dodgyCode.getValue().booleanValue()) {
            BugCategory style = DetectorFactoryCollection.instance().getBugCategory("STYLE");
            bugCategories.add(style.getCategory());
        }
        if (this.m_experimental.getValue().booleanValue()) {
            BugCategory experimental = DetectorFactoryCollection.instance().getBugCategory("EXPERIMENTAL");
            bugCategories.add(experimental.getCategory());
        }
        if (this.m_correctness.getValue().booleanValue()) {
            correctness = DetectorFactoryCollection.instance().getBugCategory("MT_CORRECTNESS");
            bugCategories.add(correctness.getCategory());
        }
        if (this.m_internationalization.getValue().booleanValue()) {
            BugCategory internationalization = DetectorFactoryCollection.instance().getBugCategory("I18N");
            bugCategories.add(internationalization.getCategory());
        }
        if (bugCategories.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DetectorFactory> detectorFactories = new HashSet<DetectorFactory>();
        for (DetectorFactory factory : DetectorFactoryCollection.instance().getFactories()) {
            if (factory.isHidden() || !factory.isDefaultEnabled() || !factory.isEnabledForCurrentJRE()) {
                LOGGER.debug("Detector factory {} is hidden/not enabled/not enabled for current JRE", (Object)factory.toString());
                continue;
            }
            boolean skipDetectorFactory = true;
            for (BugPattern bugPattern : factory.getReportedBugPatterns()) {
                if (!bugCategories.contains(bugPattern.getCategory())) continue;
                skipDetectorFactory = false;
                break;
            }
            if (!skipDetectorFactory) {
                LOGGER.debug("Detector factory {} added", (Object)factory.toString());
                detectorFactories.add(factory);
                continue;
            }
            LOGGER.debug("Detector factory {} skipped", (Object)factory.toString());
        }
        return detectorFactories;
    }

    public void reportMissingClass(ClassNotFoundException ex) {
    }

    public void reportMissingClass(ClassDescriptor classDescriptor) {
    }

    public void logError(String message) {
        LOGGER.warn("Error: {}", (Object)message);
    }

    public void logError(String message, Throwable e) {
        LOGGER.warn("Error: {} {}", (Object)message, (Object)e.getMessage());
    }

    public void reportSkippedAnalysis(MethodDescriptor method) {
    }

    public void observeClass(ClassDescriptor classDescriptor) {
    }

    public void setErrorVerbosity(int level) {
    }

    public void setPriorityThreshold(int threshold) {
    }

    /*
     * Exception decompiling
     */
    public void reportBug(BugInstance bugInstance) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl75 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl75 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void finish() {
    }

    public void reportQueuedErrors() {
    }

    public void addObserver(BugReporterObserver observer) {
    }

    public ProjectStats getProjectStats() {
        if (this.m_projectStats == null) {
            this.m_projectStats = new ProjectStats();
        }
        return this.m_projectStats;
    }

    public BugCollection getBugCollection() {
        if (this.m_bugCollection == null) {
            this.m_bugCollection = new SortedBugCollection(this.getProjectStats());
        }
        return this.m_bugCollection;
    }

    public boolean vacuous() {
        return false;
    }

    public boolean matches(String relPath) {
        assert (this.m_classFileRegistry != null) : "Parameter 'm_classFileRegistry' of method 'matches' must not be null";
        if (relPath != null && !relPath.isEmpty()) {
            return this.m_classFileRegistry.getClassFile(relPath) != null;
        }
        return false;
    }

    public void reportNumberOfArchives(int numArchives) {
    }

    public void startArchive(String name) {
        assert (this.m_context != null) : "'m_context' of method 'startArchive' must not be null";
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
    }

    public void finishArchive() {
    }

    public void predictPassCount(int[] classesPerPass) {
        assert (this.m_context != null) : "'m_context' of method 'predictPassCount' must not be null";
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
        int overall = 0;
        int[] nArray = classesPerPass;
        int n = classesPerPass.length;
        int n2 = 0;
        while (n2 < n) {
            int next = nArray[n2];
            overall += next;
            ++n2;
        }
        this.m_context.beginBlockOfWork(overall);
    }

    public void startAnalysis(int numClasses) {
        assert (this.m_context != null) : "'m_context' of method 'startAnalysis' must not be null";
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
    }

    public void finishPerClassAnalysis() {
        assert (this.m_context != null) : "'m_context' of method 'finishPerClassAnalysis' must not be null";
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
    }

    public void finishClass() {
        assert (this.m_context != null) : "'m_context' of method 'finishClass' must not be null";
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (this.m_context.hasBeenCanceled()) {
            Thread.currentThread().interrupt();
        }
        this.m_context.workItemCompleted();
    }

    /*
     * Exception decompiling
     */
    public void analyze(IAnalyzerPluginContext context, ResultSet result) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$edu$umd$cs$findbugs$BugRankCategory() {
        if ($SWITCH_TABLE$edu$umd$cs$findbugs$BugRankCategory != null) {
            return $SWITCH_TABLE$edu$umd$cs$findbugs$BugRankCategory;
        }
        int[] nArray = new int[BugRankCategory.values().length];
        try {
            nArray[BugRankCategory.OF_CONCERN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BugRankCategory.SCARIEST.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BugRankCategory.SCARY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[BugRankCategory.TROUBLING.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$edu$umd$cs$findbugs$BugRankCategory = nArray;
        return nArray;
    }

    private static /* synthetic */ void lambda$0(Project project, String d) {
        boolean bl = project.addFile(d);
    }

    private static /* synthetic */ void lambda$1(UserPreferences userPreferences, DetectorFactory d) {
        userPreferences.enableDetector(d, true);
    }
}

