/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.IJsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.JsonFile;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.file.Path;

final class NxProjectJsonFile
extends JsonFile {
    private final Path m_sourceRoot;
    private final IJsonFileManager.IJsonFile m_tsConfigJsonFile;

    NxProjectJsonFile(Path path, Path nxPath, IJsonFileManager manager, IExecutionContext context) throws IOException {
        super(path, manager);
        assert (path != null) : "Parameter 'path' of method 'NxProjectJsonFile' must not be null";
        assert (nxPath != null) : "Parameter 'nxPath' of method 'NxProjectJsonFile' must not be null";
        assert (manager != null) : "Parameter 'manager' of method 'NxProjectJsonFile' must not be null";
        assert (context != null) : "Parameter 'context' of method 'NxProjectJsonFile' must not be null";
        String root = (String)this.getDocumentContext().read("$.sourceRoot", new Predicate[0]);
        this.m_sourceRoot = root != null ? nxPath.getParent().resolve(Path.of(root, new String[0])) : null;
        String config = (String)this.getDocumentContext().read("$.targets.build.options.tsConfig", new Predicate[0]);
        Path configPath = nxPath.getParent().resolve(config);
        this.m_tsConfigJsonFile = manager.computeIfAbsent(configPath, () -> manager.createTsConfigJsonFile(configPath, context));
    }

    Path getSourceRoot() {
        return this.m_sourceRoot;
    }

    IJsonFileManager.IJsonFile getTsConfigJsonFile() {
        return this.m_tsConfigJsonFile;
    }
}

