/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.IWorkspaceDependencyElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotSourceFilePath;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.element.CSharpStructureItem;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpSourceFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpAssembly;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModuleType;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.util.List;

public abstract class CSharpModule
extends Module {
    private CSharpModuleType m_type;
    private String m_assemblyName;

    public CSharpModule(NamedElement parent) {
        super(parent);
    }

    protected CSharpModule(NamedElement parent, String name, String id, CSharpModuleType type) {
        super(parent, name, id);
        this.m_type = type;
        this.m_assemblyName = name;
    }

    public final Language getLanguage() {
        return CSharpLanguage.INSTANCE;
    }

    public final List<? extends ISnapshotSourceFilePath> getSourceFiles() {
        return this.getChildrenRecursively(CSharpSourceFile.class, new Class[]{ProgrammingElement.class});
    }

    public final String getAssemblyNameOfModule() {
        return this.m_assemblyName;
    }

    public final void setAssemblyNameOfModule(String assemblyName) {
        assert (assemblyName != null) : "Parameter 'assemblyName' of method 'setAssemblyNameOfModule' must not be null";
        this.m_assemblyName = assemblyName;
    }

    public final String getImageResourceName() {
        return Module.class.getSimpleName();
    }

    public final String getPresentationKind() {
        return "C# Module";
    }

    public final Module.IModuleType getType() {
        return this.m_type;
    }

    protected final boolean includeAsOutgoing(IWorkspaceDependencyElement to) {
        return super.includeAsOutgoing(to) && !(to instanceof CSharpAssembly);
    }

    public final String getRootDirectoryPathFileTypePresentationKind(boolean lowerCase) {
        return lowerCase ? "C# source" : "C# Source";
    }

    public final IStructureItem getStructureItem() {
        return CSharpStructureItem.MODULE;
    }

    public final RootDirectoryPath createRootDirectoryPath(IModelServiceProvider msp, NamedElement parent, TFile file) {
        return new CSharpRootDirectoryPath(parent, msp, file);
    }

    public final Class<? extends RootDirectoryPath> getRootDirectoryPathClass() {
        return CSharpRootDirectoryPath.class;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_type.getStandardName());
        writer.writeString(this.m_assemblyName);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_type = CSharpModuleType.fromStandardName(reader.readString());
        this.m_assemblyName = reader.readString();
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCSharpModule(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCSharpModule(CSharpModule var1);
    }
}

