/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.ISonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginConfiguration;
import java.util.Map;

public abstract class SonargraphPluginAttribute
implements ISonargraphPluginAttribute {
    private final String m_name;
    private final String m_presentatioName;
    private final String m_description;
    private final String m_group;
    private ISonargraphPluginConfiguration m_configuration;

    public SonargraphPluginAttribute(String name, String presentationName, String description, String group) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'SonargraphPluginAttribute' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'SonargraphPluginAttribute' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'SonargraphPluginAttribute' must not be null";
        assert (group == null || !group.isEmpty()) : "Parameter 'group' of method 'SonargraphPluginAttribute' must be null or not empty";
        this.m_name = name;
        this.m_presentatioName = presentationName;
        this.m_description = description;
        this.m_group = group;
    }

    final void setConfiguration(ISonargraphPluginConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'setConfiguration' must not be null";
        this.m_configuration = configuration;
    }

    protected final ISonargraphPluginConfiguration getConfiguration() {
        assert (this.m_configuration != null) : "'m_configuration' of method 'getConfiguration' must not be null";
        return this.m_configuration;
    }

    public final String getName() {
        return this.m_name;
    }

    public String getPresentatioName() {
        return this.m_presentatioName;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final String getGroup() {
        return this.m_group;
    }

    public abstract Object getDefaultValue();

    public abstract Object getValue();

    public abstract Map<String, Object> getOptionLabelToValue();

    public final Object getOptionValue(String optionLabel) {
        assert (optionLabel != null && optionLabel.length() > 0) : "Parameter 'optionLabel' of method 'getOptionValue' must not be empty";
        Object value = this.getOptionLabelToValue().get(optionLabel);
        assert (value != null) : "Unknown option label '" + optionLabel + "' in method 'getOptionValue'";
        return value;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] name='" + this.m_name + "', description='" + this.m_description + "', group=" + (String)(this.m_group == null ? "<none>" : "'" + this.m_group + "'");
    }
}

