/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericClass;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericField;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericFunctionWithBody;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericVariable;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonSearchPath;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import java.util.Map;

class InitializationVisitor
extends NamedElementVisitor
implements PythonSourceFile.IVisitor,
GenericPackage.IVisitor,
GenericClass.IVisitor,
GenericFunctionWithBody.IVisitor,
External.IVisitor,
Module.IVisitor,
GenericVariable.IVisitor,
GenericField.IVisitor {
    private final IWorkerContext m_workerContext;
    private final MultipleValueMap<String, Scope> m_moduleDirectory;
    private final Map<NamedElement, Scope> m_scopeMap;
    private final PythonSearchPath m_searchPath;
    private Scope m_currentScope = null;

    public InitializationVisitor(IWorkerContext workerContext, MultipleValueMap<String, Scope> moduleDirectory, Map<NamedElement, Scope> scopeMap, PythonSearchPath searchPath) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'InitializationVisitor' must not be null";
        assert (moduleDirectory != null) : "Parameter 'moduleDirectory' of method 'InitializationVisitor' must not be null";
        assert (scopeMap != null) : "Parameter 'scopeMap' of method 'InitializationVisitor' must not be null";
        assert (searchPath != null) : "Parameter 'searchPath' of method 'InitializationVisitor' must not be null";
        this.m_workerContext = workerContext;
        this.m_moduleDirectory = moduleDirectory;
        this.m_scopeMap = scopeMap;
        this.m_searchPath = searchPath;
    }

    public void visitNamedElement(NamedElement element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        if (this.m_currentScope != null) {
            this.m_currentScope.addItem(element);
        }
        super.visitNamedElement(element);
    }

    public void visitGenericFunction(GenericFunctionWithBody element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        assert (this.m_currentScope != null);
        this.m_currentScope = this.m_currentScope.addScope(element.getShortName(), (NamedElement)element);
        this.visitChildrenOf((NamedElement)element);
        this.m_currentScope = this.m_currentScope.getParent();
    }

    public void visitGenericClass(GenericClass element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        assert (this.m_currentScope != null);
        this.m_currentScope = this.m_currentScope.addScope(element.getShortName(), (NamedElement)element);
        this.visitChildrenOf((NamedElement)element);
        this.m_currentScope = this.m_currentScope.getParent();
    }

    public void visitGenericPackage(GenericPackage element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        this.m_currentScope = this.m_currentScope == null ? new Scope(null, (NamedElement)element) : this.m_currentScope.addScope(element.getShortName(), (NamedElement)element);
        for (Scope scope : this.m_moduleDirectory.get((Object)element.getName())) {
            if (this.m_workerContext.hasBeenCanceled()) {
                return;
            }
            if (scope.isPackage()) continue;
            this.m_moduleDirectory.remove((Object)element.getName(), (Object)scope);
            break;
        }
        this.m_moduleDirectory.put((Object)element.getName(), (Object)this.m_currentScope);
        this.m_scopeMap.put((NamedElement)element, this.m_currentScope);
        this.visitChildrenOf((NamedElement)element);
        this.m_currentScope = this.m_currentScope.getParent();
    }

    @Override
    public void visitPythonSourceFile(PythonSourceFile element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        String name = FileUtility.removeExtension((String)element.getShortName());
        this.m_currentScope = this.m_currentScope == null ? new Scope(name, null, (NamedElement)element) : this.m_currentScope.addScope(name, (NamedElement)element);
        if (this.m_moduleDirectory.get((Object)element.getPythonModuleName()).isEmpty()) {
            this.m_moduleDirectory.put((Object)element.getPythonModuleName(), (Object)this.m_currentScope);
            this.m_scopeMap.put((NamedElement)element, this.m_currentScope);
            this.visitChildrenOf((NamedElement)element);
            this.m_currentScope = this.m_currentScope.getParent();
            this.m_searchPath.registerModuleName(element.getPythonModuleName());
        }
    }

    public void visitGenericField(GenericField element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        this.m_currentScope.addItem((NamedElement)element);
    }

    public void visitGenericVariable(GenericVariable element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        this.m_currentScope.addItem((NamedElement)element);
    }

    public void visitModule(Module element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        if (element.getLanguage() == PythonLanguage.INSTANCE) {
            this.visitChildrenOf((NamedElement)element);
        }
    }

    public void visitExternal(External element) {
        if (this.m_workerContext.hasBeenCanceled()) {
            return;
        }
        if (element.getLanguage() == PythonLanguage.INSTANCE) {
            this.visitChildrenOf((NamedElement)element);
        }
    }
}

