/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.DependencyCreator;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.InstanceScope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonClass;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonDependencyType;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

final class ClassScope
extends Scope {
    private final List<ClassScope> m_baseClasses = new ArrayList<ClassScope>();
    private final InstanceScope m_instanceScope = new InstanceScope(this, this.getModelObject());

    ClassScope(Scope parentScope, PythonClass modelObject) {
        super(parentScope, (NamedElement)modelObject);
    }

    @Override
    InstanceScope getInstanceScope() {
        return this.m_instanceScope;
    }

    void addBaseClass(ClassScope cls, int line) {
        assert (cls != null) : "Parameter 'cls' of method 'addBaseClass' must not be null";
        this.m_baseClasses.add(cls);
        this.m_instanceScope.addBaseClass(cls.getInstanceScope());
        DependencyCreator.createDependency(this.getModelObject(), cls.getModelObject(), PythonDependencyType.EXTENDS, line);
    }

    private ScopeItem lookupMemberInBaseClasses(String name, Set<ClassScope> visited) {
        ScopeItem result = null;
        for (ClassScope cls : this.m_baseClasses) {
            if (visited.add(cls) && ((result = cls.lookupLocal(name)) != null || (result = cls.lookupMemberInBaseClasses(name, visited)) != null)) break;
        }
        return result;
    }

    @Override
    ScopeItem lookupMember(String name, PythonSourceFile source, int line, boolean fromFunctionBody) {
        ScopeItem result = this.lookupLocal(name);
        if (result != null) {
            return result;
        }
        return this.lookupMemberInBaseClasses(name, (Set<ClassScope>)new THashSet());
    }
}

