/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.settings;

import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;

public class PythonInterpreterLocator {
    private PythonInterpreterLocator() {
    }

    public static String findInDirectory(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'findInDirectory' must not be null";
        if (!dir.isDirectory()) {
            return null;
        }
        TFile interpreter = new TFile((File)dir, PythonInterpreterLocator.getInterpreterName());
        if (interpreter.isFile() && interpreter.canExecute()) {
            return interpreter.getNormalizedAbsolutePath();
        }
        TFile[] tFileArray = dir.listFiles();
        int n = tFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String result;
            TFile child = tFileArray[n2];
            if (child.isDirectory() && (result = PythonInterpreterLocator.findInDirectory(child)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static String findInSystemWidePath() {
        TFile interpreter;
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("Path");
        }
        if (path == null) {
            return null;
        }
        String[] pathElements = Platform.isWindows() ? path.split(";") : path.split(":");
        SearchPath sp = new SearchPath(pathElements);
        if (!Platform.isWindows()) {
            sp.add("/usr/local/bin");
        }
        if ((interpreter = sp.locateFile(PythonInterpreterLocator.getInterpreterName())) == null) {
            return null;
        }
        return interpreter.getNormalizedAbsolutePath();
    }

    public static String getInterpreterName() {
        return Platform.isWindows() ? "python.exe" : "python3";
    }
}

