/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.swagger;

import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.PluginDependencyMetaData;
import com.hello2morrow.sonargraph.api.PluginIssueSeverity;
import com.hello2morrow.sonargraph.api.PluginIssueType;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.IModelPluginInfoConsumer;
import com.hello2morrow.sonargraph.plugin.IPluginContext;
import com.hello2morrow.sonargraph.plugin.IPluginModelContributor;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginContributor;
import com.hello2morrow.sonargraph.plugin.SonargraphPlugin;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginManager;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import com.hello2morrow.sonargraph.plugin.swagger.JavaEEWebResourceDetector;
import com.hello2morrow.sonargraph.plugin.swagger.OkHttpWebCallDetector;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwaggerPlugin
extends SonargraphPlugin
implements IPluginModelContributor {
    public static final String ID = "com.hello2morrow.sonargraph.plugin.swagger";
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerPlugin.class);
    private JavaEEWebResourceDetector m_javaEEResourceDetector;
    private OkHttpWebCallDetector m_callDetector;

    public SwaggerPlugin() {
        LOGGER.debug("[" + this.getId() + "] Instantiated");
        SonargraphPluginManager.getInstance().addPlugin((SonargraphPlugin)this);
    }

    public String getId() {
        return ID;
    }

    public String getVendor() {
        return "hello2morrow GmbH";
    }

    public String getVersion() {
        return "n/a";
    }

    public String getDescription() {
        return "Detects and adds web resources and calls generated by Swagger for the OkHttpClient framework.";
    }

    public String getAvailableForLanguages() {
        return "Java";
    }

    public String getPresentationName() {
        return "Sonargraph Swagger Plugin";
    }

    public Set<String> getSupportedLanguages() {
        return Collections.singleton("Java");
    }

    public IPluginModelContributor getModelContributor() {
        return this;
    }

    public void initialize(ISonargraphPluginContributor contributor) {
        assert (contributor != null) : "Parameter 'contributor' of method 'initialize' must not be null";
        IPluginIssueId applicationPathIsNotUniqueIssueId = contributor.createIssueId("ApplicationPathNotUnique", "@ApplicationPath can only occur once", PluginIssueSeverity.WARNING, PluginIssueType.DEPENDENCY);
        PluginProgrammingElementMetaData webResourceMetaData = contributor.createProgrammingElementMetaData("WebResource", "WebResource", false);
        PluginProgrammingElementMetaData externalWebResourceMetaData = contributor.createProgrammingElementMetaData("ExternalWebResource", "WebResource", true);
        PluginProgrammingElementMetaData webCallMetaData = contributor.createProgrammingElementMetaData("WebCall", "WebCall", false);
        PluginDependencyMetaData httpCallMetaData = contributor.createDependencyMetaData("HttpCall", false, true, false);
        this.m_javaEEResourceDetector = new JavaEEWebResourceDetector(this.getId(), webResourceMetaData, applicationPathIsNotUniqueIssueId);
        this.m_callDetector = new OkHttpWebCallDetector(this.getId(), webResourceMetaData, externalWebResourceMetaData, webCallMetaData, httpCallMetaData);
    }

    public void createModelElements(IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) {
        assert (context != null) : "Parameter 'context' of method 'createModelElements' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createModelElements' must not be null";
        assert (this.m_javaEEResourceDetector != null) : "'m_javaEEResourceDetector' of method 'createModelElements' must not be null";
        LOGGER.debug("Creating model elements");
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'createModelElements' must not be null";
        this.m_javaEEResourceDetector.detect(context, javaAccess);
    }

    public void createDependencies(IModelPluginContext context, IModelPluginInfoConsumer infoConsumer) {
        assert (context != null) : "Parameter 'context' of method 'createDependencies' must not be null";
        assert (infoConsumer != null) : "Parameter 'infoConsumer' of method 'createDependencies' must not be null";
        assert (this.m_callDetector != null) : "'m_callDetector' of method 'createDependencies' must not be null";
        LOGGER.debug("Creating dependencies");
        IPluginJavaAccess javaAccess = (IPluginJavaAccess)context.getAccess(IPluginJavaAccess.class);
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'createModelElements' must not be null";
        this.m_callDetector.detect(context, javaAccess);
    }

    public void cleared(IPluginContext context) {
    }
}

