<!DOCTYPE html>
<%
boolean isQualityGateEnabled = currentReport.getAvailableFeatures().contains(com.hello2morrow.sonargraph.core.model.common.SonargraphFeature.ARCHITECTURE);
%>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <style type="text/css" MEDIA="all">@import url("hello2morrow.css");</style>
        <script src="tablefilter/tablefilter.js"></script>
        <title>Sonargraph Architect Diff Report - <%=systemInfo.title%></title>
        <link rel="icon" href="favicon.png">
    </head>
	<style> 
        body { 
            min-width: 1800px; 
        } 
    </style> 
    <body>
    <script>
    	window.name = "<%=systemInfo.getTargetFile().getName()%>";
    </script>
        <a name="top"></a>
        <table border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td width="200" bgcolor="#333333"><img src="spacer.gif" alt="" width="200" height="65" border="0"></td>
                <td width="23" bgcolor="E3E4E5"><img src="spacer.gif" width="23" height="1"></td>
                <td width="100%" bgcolor="E3E4E5">
                    <table border="0" cellspacing="0" cellpadding="0">
                        <tr>
                            <td width="7" bgcolor="e3e4e5"><img src="spacer.gif" width="7" height="1"></td>
                            <td><img src="hello2morrow.gif" alt="hello2morrow" width="227" height="23" border="0"></td>
                            <td width="100%" align="right" bgcolor="e3e4e5"><img src="header.gif" alt="hello2morrow" width="543" height="65" border="0"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="3" bgcolor="#000000"></td>
            </tr>
            <tr>
<!-- start of navigation -->            
                <td bgcolor="#A7A9AC" valign="top">
                    <div class="leftNav">
                        <ul>
                            <li><a href="#system"><% if (systemInfo.hasChanges()) {out.print("(!) ");} %>System</a></li>
                            <li><a href="#metric"><% if (metricInfo.hasChanges()) {out.print("(!) ");} %>System Metrics</a></li>
                            <li><a href="#workspace"><% if (workspaceInfo.hasChanges()) {out.print("(!) ");} %>Workspace</a></li>
                            <li><a href="#issue"><% if (issueInfo.hasChanges()) {out.print("(!) ");} %>Issues</a></li>
                            <li><a href="#ignore"><% if (resolutionInfo.hasIgnoreChanges()) {out.print("(!) ");} %>Ignored Issues</a></li>
                            <li><a href="#task"><% if (resolutionInfo.hasTaskChanges()) {out.print("(!) ");} %>Tasks</a></li>
                            <li><a href="#refactoring"><% if (resolutionInfo.hasRefactoringChanges()) {out.print("(!) ");} %>Refactorings</a></li>
                            <li><a href="#cycle"><% if (issueInfo.hasCycleChanges()) {out.print("(!) ");} %>Cycle Groups</a></li>
                            <li><a href="#duplicates"><% if (issueInfo.hasDuplicateChanges()) {out.print("(!) ");} %>Duplicate Code Blocks</a></li>
                        </ul>
                    </div>
                </td>
<!-- end of navigation -->
                <!-- start of spacer -->
                <td width="23"><img src="spacer.gif" width="23" height="1"></td><!-- end of spacer -->
                
                <!-- real content -->
                <td width="100%">
                    <table width="100%" border="0">
                        <tr>
                            <td width="1%" height="80" valign="center">
                                <image src="logo.gif" width="350"></image>
                            </td>
                        </tr>
			            <tr>
			                <td>
			                    <h1><a name="system"></a>System Diff Report for <%= systemInfo.title %></h1>
			                </td>
			            </tr>
			            <tr>
			                <td>
			                    <strong>Path: </strong><%= systemInfo.systemDirectoryPath %><br/>
			                    <strong>System Description: </strong><%= systemInfo.softwareSystem.description %><br/>
			                    <strong>Sonargraph Version: </strong><%= currentReport.version %><br/>
			                    <strong>Current Virtual Model: </strong><%= currentReport.currentVirtualModel %> <br/>
			                    <%
			                        if (currentReport.getActiveProfile() != null && currentReport.getActiveProfile().length() > 0)
			                        {
			                    %>
			                            <strong>Workspace Profile: </strong><%= currentReport.activeProfile %> <br/>
			                    <%
			                        }
			                    %>
			                    <%
			                        if (currentReport.getQualityModelPath() != null && currentReport.getQualityModelPath().length() > 0)
			                        {
			                    %>
			                            <strong>Quality Model: </strong><%= currentReport.qualityModelPath %> <br/>
			                    <%
			                        }
			                    %>
			                    <strong>Analyzer Execution Level: </strong><%= currentReport.getAnalyzerExecutionLevel() %> <br/>
			                    <br/>
			                    <strong>Diff Creation: </strong><%= systemInfo.diffCreationTimeStamp %><br/>
			                    <strong>Baseline Report: </strong><%= systemInfo.baselineReportPath %><br/>
			                    <strong>Baseline Creation: </strong><%=systemInfo.baselineReportTimestamp %><br/>
			                    <strong>Baseline Context Info: </strong><%=systemInfo.baselineContextInfo %><br/>
			                    <%
                                if (mainReport != null)
                                {
                                %>
                                	<strong>Full Report: </strong><a href="<%= mainReport%>"><%= mainReport%></a> <br/>
                                <%
                                }
                                %> 
			                </td>
			            </tr>
<!-- quality gates -->
					<%
					if (isQualityGateEnabled)
            		{
            		%>
						<tr>
							<td>
								<h2><a name="qualitygates"></a>Current State of Quality Gates (<%=currentReport.getQualityGateToResultMap().size()%>)</h2>
								<% 
								if(currentReport.getQualityGateToResultMap().isEmpty())
								{
								%>
									No active quality gates exist.
								<%
								} 
								else
								{
									for (java.util.Map.Entry<com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate, com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult> entry : currentReport.getQualityGateToResultMap())
									{
										com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate qualityGate = entry.getKey();
										com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResult result = entry.getValue();
										String tableId = "qualitygates_" + qualityGate.getShortName();
										String qualityGateStatusImage = result.getResultStatus().getImageResourceName();
										if (qualityGateStatusImage != null)
										{
											out.println("<h3>Quality Gate \"" + qualityGate.getShortName() + "\" (<img style=\"vertical-align: middle;\" src=\"" + qualityGateStatusImage + ".gif\"/> " + result.getResultStatus().getPresentationName() 
												+ ")</h3>");
										}
										else
										{
											out.println("<h3>Quality Gate " + qualityGate.getShortName() + ", Status: " + result.getResultStatus().getPresentationName() + "</h3>");											
										} 										
								%>
								    <table class="techTable" id="<%=tableId%>" width="100%">
	                                    <thead>
		                                    <tr>
		                                        <th>Condition</th>
		                                    	<th>Status</th>
		                                    	<th>Information</th>
		                                    </tr>                                   
		                                </thead>
	                                    <%
	                                      boolean firstCurrentCondition = false;
	                                      boolean firstBaselineCondition = false;
	                                      
	                                      for (com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement qualityGateElement 
	                                      	: qualityGate.getChildrenRecursively(com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement.class, 
	                                      	  com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElement.class))
	                                      {
	                                      	//This if-else block controls the info line for current and baseline conditions
	                                      	if (qualityGateElement.getParent(com.hello2morrow.sonargraph.core.model.system.qualitygate.CurrentSystemConditions.class) != null)
	                                      	{
	                                      		if (!firstCurrentCondition)
	                                      		{
	                                      			out.println("<tr>");
		                                        	out.println("<td colspan=\"3\">Current System Conditions");
		                                        	out.println("</td>");
		                                        	out.println("</tr>");
	                                      			firstCurrentCondition = true;
                                      			}
	                                      	}
	                                      	else
	                                      	{
	                                      		if (!firstBaselineCondition)
	                                      		{
		                                      		firstBaselineCondition = true;
	                                      	  		out.println("<tr>");
		                                        	out.println("<td colspan=\"3\">Baseline Conditions");
		                                        	out.println("</td>");
		                                        	out.println("</tr>");
		                                        }
		                                    }	
		                                                                            	
	                                        com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateResultElement resultElement = qualityGate.getResultElementFor(qualityGateElement);
	                                        out.println("<tr>");
	                                        out.println("<td>");
	                                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + qualityGateElement.getPresentationName(false));
	                                        out.println("</td>");
	                                        if (resultElement != null)
	                                        {
		                                        out.println("<td style=\"vertical-align: middle;\">");
		                                        if (resultElement.getResultStatus() != null)
		                                        {
			                                        StringBuilder line = new StringBuilder();
			                                        if (resultElement.getResultStatus().getImageResourceName() != null)
			                                        {
			                                        	line.append("<img style=\"vertical-align: middle;\" src=\"").append(resultElement.getResultStatus().getImageResourceName()).append(".gif\"/>");
			                                        }
			                                        line.append(" ").append(resultElement.getResultStatus().getPresentationName()); 
	                                        		out.println(line);
	                                        	}
		                                        out.println("</td>");
		                                        out.println("<td>");
	                                        	out.println(resultElement.getInformation());
		                                        out.println("</td>");
	                                        } 
	                                        else
	                                        {
	                                        	out.println("<td>");
	                                        	out.println("</td>");
		                                        out.println("<td>");
	                                        	out.println("</td>");
	                                        } 
	                                        out.println("</tr>");
	                                      } 
	                                    %>
	                                </table>
	                                <script>
	                            		var filtersConfig = {
											base_path: 'tablefilter/',
							        		alternate_rows: true,
							        		grid: false,
										    col_widths: ['', '200px', '450px'],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('<%=tableId%>', filtersConfig);
										tf.init();
									</script>
									<% 
									}
								}
								%> 
							</td>
						</tr>
                   <%
                   }
                   %>			            
			            
<!-- System  Diff -->                
					<% if (!systemInfo.isSystemInfoChanged())
					{ 
					%>
						<tr>
							<td>
								<h2><a name="system"></a>System (Unmodified)<a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
							<td>
						</tr>
					<%      
					}
					else 
					{
					%>
                        <tr>
                            <td>
	                        <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff> propertyDiffs = systemInfo.getSimplePropertyDiffs();
	                        if (!propertyDiffs.isEmpty())
	                        {
	                        %>
                                <h3><a name="system"></a>System Properties</h3>
                                <table class="techTable" id="systemProperties">
                                    <thead>
	                                    <tr>
	                                        <th width="150">Property</th>
	                                        <th width="100">Change</th>
	                                        <th>Details</th>
	                                    </tr>
	                                </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff property : propertyDiffs)
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(property.getPresentationName(true));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(property.getChange().getPresentationName());
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(property.getChangeDescription());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['150px', '100px', ''],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('systemProperties', filtersConfig);
									tf.init();
								</script>
	                        <% 
	                        } 
	                        %> 
                            </td>
                        </tr>
                        
<!-- Features --> 
                        <tr>
                            <td>
                            <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.FeatureDiff> featureDiffs = systemInfo.getFeatureDiffs();
	                        if (!featureDiffs.isEmpty())
	                        {
	                        %>
	                            <h3>Features  <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
	                            <table class="techTable" id="features">
	                                <thead>
	                                    <tr>
	                                        <th width="250">Name</th>
	                                        <th width="100">Change</th>		                                        
	                                    </tr>
	                                </thead>
	                                <% 
	                                  for (com.hello2morrow.sonargraph.core.model.system.diff.FeatureDiff featureDiff : featureDiffs)
	                                  {
	                                    out.println("<tr>");
	                                    out.println("<td>");
	                                    out.println(featureDiff.getPresentationName(true));
	                                    out.println("</td>");
	                                    out.println("<td>");
	                                    out.println(featureDiff.getChange().getPresentationName());
	                                    out.println("</td>");
	                                    out.println("</tr>");
	                                  }
	                                %>
	                            </table>
	                            <script>
	                        		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['', '100px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('features', filtersConfig);
									tf.init();
								</script>
							<%
							}
							%>
                            </td>
                        </tr>
<!-- Analyzers --> 
                        <tr>
                            <td>
	                        <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.analyzer.AnalyzerDiff> analyzerDiffs = systemInfo.getAnalyzerDiffs();
	                        if (!analyzerDiffs.isEmpty())
	                        {
	                        %>
                                <h3>Analyzers <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
                                <table class="techTable" id="analyzers">
                                    <thead>
	                                    <tr>
	                                        <th width="250">Name</th>
	                                        <th width="100">Change</th>		                                        
	                                    </tr>
	                                </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.system.diff.analyzer.AnalyzerDiff analyzerDiff : analyzerDiffs)
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(analyzerDiff.getPresentationName(true));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(analyzerDiff.getChange().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['', '100px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('analyzers', filtersConfig);
									tf.init();
								</script>
	                        <% 
	                        } 
	                        %> 
                            </td>
                        </tr>
                        
<!-- Analyzer Configurations -->
						<tr>
                            <td>
	                        <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.analyzer.AnalyzerConfigurationDiff> analyzerConfigurationDiffs = systemInfo.getAnalyzerConfigurationDiffs();
	                        if (!analyzerConfigurationDiffs.isEmpty())
	                        {
	                        %>
	                            <h3>Analyzer Configurations  <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
	                            <table class="techTable" id="analyzerConfigurations">
	                                <thead>
	                                    <tr>
	                                        <th width="450">Name</th>
	                                        <th width="100">Change</th>
	                                        <th>Details</th>		                                        
	                                    </tr>
	                                </thead>
	                                <% 
	                                  for (com.hello2morrow.sonargraph.core.model.system.diff.StructureContainerDiff analyzerConfigurationDiff : analyzerConfigurationDiffs)
	                                  {
	                                    out.println("<tr>");
	                                    out.println("<td>");
	                                    out.println(analyzerConfigurationDiff.getPresentationName(true));
	                                    out.println("</td>");
	                                    out.println("<td>");
	                                    out.println(analyzerConfigurationDiff.getChange().getPresentationName());
	                                    out.println("</td>");
	                                    out.println("<td>");
	                                    out.println(analyzerConfigurationDiff.getChangeDescription());
	                                    out.println("</td>");
	                                    out.println("</tr>");
	                                    if (analyzerConfigurationDiff instanceof com.hello2morrow.sonargraph.core.model.system.diff.analyzer.MetricThresholdAnalyzerConfigurationDiff)
	                                    {
	                                    	//Metric level | Metric
	                                    	for (com.hello2morrow.sonargraph.foundation.utilities.StrictPair<String, com.hello2morrow.sonargraph.core.model.system.diff.analyzer.MetricThresholdValueDiff> nextPair : systemInfo.getMetricThresholdDiffs(analyzerConfigurationDiff))
	                                    	{
	                                    		out.println("<td>");
		                                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + nextPair.getFirst());
		                                        out.println("</td>");
		                                        out.println("<td>");
		                                        out.println(nextPair.getSecond().getChange().getPresentationName());
		                                        out.println("</td>");
		                                        out.println("<td>");
		                                        out.println(nextPair.getSecond().getChangeDescription());
		                                        out.println("</td>");
		                                        out.println("</tr>");
	                                    	} 	
	                                    }
	                                    else 
	                                    {
	                                        for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff propertyDiff : systemInfo.getAnalyzerConfigurationElementDiffs(analyzerConfigurationDiff))
	                                        {
	                                        	out.println("<tr>");
		                                        out.println("<td>");
		                                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + propertyDiff.getPresentationName(true));
		                                        out.println("</td>");
		                                        out.println("<td>");
		                                        out.println(propertyDiff.getChange().getPresentationName());
		                                        out.println("</td>");
		                                        out.println("<td>");
		                                        out.println(propertyDiff.getChangeDescription());
		                                        out.println("</td>");
		                                        out.println("</tr>");
	                                        }
	                                    }
	                                  }
	                                %>
	                            </table>
	                            <script>
	                        		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['350px', '100px', ''],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('analyzerConfigurations', filtersConfig);
									tf.init();
								</script>
	                        <% 
	                        } 
	                        %> 
                            </td>
                        </tr>                         
<!-- Plugins --> 
                        <tr>
                            <td>
	                        <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff> pluginDiffs = systemInfo.getPluginDiffs();
	                        if (!pluginDiffs.isEmpty())
	                        {
	                        %>
                                <h3>Plugins <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
                                <table class="techTable" id="plugins">
                                    <thead>
	                                    <tr>
	                                        <th width="250">Name</th>
	                                        <th width="100">Change</th>		                                        
	                                    </tr>
	                                </thead>
                                    <% 
                                      for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff pluginDiff : pluginDiffs)
                                      {
                                        out.println("<tr>");
                                        out.println("<td>");
                                        out.println(pluginDiff.getPresentationName(true));
                                        out.println("</td>");
                                        out.println("<td>");
                                        out.println(pluginDiff.getChange().getPresentationName());
                                        out.println("</td>");
                                        out.println("</tr>");
                                      }
                                    %>
                                </table>
                                <script>
                            		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['', '100px'],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('plugins', filtersConfig);
									tf.init();
								</script>
	                        <% 
	                        } 
	                        %> 
                            </td>
                        </tr>
	                    
<!-- plugin configurations --> 
						<tr>
                            <td>
	                        <%
	                        List<com.hello2morrow.sonargraph.core.model.system.diff.StructureContainerDiff> pluginConfigurationDiffs = systemInfo.getPluginConfigurationDiffs();
	                        if (!pluginConfigurationDiffs.isEmpty())
	                        {
	                        %>
	                            <h3>Plugin Configurations  <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
	                            <table class="techTable" id="pluginConfigurations">
	                                <thead>
	                                    <tr>
	                                        <th width="450">Name</th>
	                                        <th width="100">Change</th>
	                                        <th>Details</th>		                                        
	                                    </tr>
	                                </thead>
	                                <% 
	                                  for (com.hello2morrow.sonargraph.core.model.system.diff.StructureContainerDiff pluginConfigurationDiff : pluginConfigurationDiffs)
	                                  {
	                                    out.println("<tr>");
	                                    out.println("<td>");
	                                    out.println(pluginConfigurationDiff.getPresentationName(true));
	                                    out.println("</td>");
	                                    out.println("<td>");
	                                    out.println(pluginConfigurationDiff.getChange().getPresentationName());
	                                    out.println("</td>");
	                                    out.println("<td>");
	                                    out.println(pluginConfigurationDiff.getChangeDescription());
	                                    out.println("</td>");
	                                    out.println("</tr>");
	                                    
                                        for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff propertyDiff : systemInfo.getPluginConfigurationElementDiffs(pluginConfigurationDiff))
                                        {
                                        	out.println("<tr>");
	                                        out.println("<td>");
	                                        out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + propertyDiff.getPresentationName(true));
	                                        out.println("</td>");
	                                        out.println("<td>");
	                                        out.println(propertyDiff.getChange().getPresentationName());
	                                        out.println("</td>");
	                                        out.println("<td>");
	                                        out.println(propertyDiff.getChangeDescription());
	                                        out.println("</td>");
	                                        out.println("</tr>");
                                        }
	                                  }
	                                %>
	                            </table>
	                            <script>
	                        		var filtersConfig = {
										base_path: 'tablefilter/',
										alternate_rows: true,
						        		grid: false,
									    col_widths: ['350px', '100px', ''],
						        		themes: [{ name: 'default' }]
								    };
									var tf = new TableFilter('pluginConfigurations', filtersConfig);
									tf.init();
								</script>
	                        <% 
	                        } 
	                        %> 
                            </td>
                        </tr>
                        
<!-- Quality Gate Configuration -->
                        <% if(isQualityGateEnabled)
                        {
                        %>                        
                        <tr>
                            <td>
                            <%
                            List<com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateDiff> qualityGateDiffs = systemInfo.getQualityGateDiffs();
                            if (!qualityGateDiffs.isEmpty())
                            {
                            %>
                                <h3>Quality Gate Configurations  <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
                                <% 
                                int qualityGateIndex = 0;
                                for (com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateDiff nextQualityGate : qualityGateDiffs)
                                {
                                    String qualityGateId = "qualityGateConfiguration_" + qualityGateIndex++;
                                %>
                                <h4><%=nextQualityGate.getPresentationName(true)%> (<%=nextQualityGate.getChange().getPresentationName()%>)</h4>
                                <table class="techTable" id="<%=qualityGateId%>" width="100%">
                                    <thead>
                                        <tr>
                                            <th width="600">Condition</th>
                                            <th width="100">Change</th>
                                            <th>Details</th>                                                
                                        </tr>
                                    </thead>
                                    <% 
                                    List<com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff> currentConditionDiffs = systemInfo.getCurrentSystemConditionDiffs(nextQualityGate);
                                    if (!currentConditionDiffs.isEmpty())
                                    {
                                        out.println("<tr>");
                                        out.println("<td colspan='3'>");
                                        out.println("Current System Conditions");
                                        out.println("</td>");                                        
                                        out.println("</tr>");
                                        
                                        for (com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff nextElementDiff : currentConditionDiffs)
                                        {
                                            out.println("<tr>");
                                            out.println("<td>");
                                            out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + nextElementDiff.getPresentationName(false));
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(nextElementDiff.getChange().getPresentationName());
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(nextElementDiff.getChangeDescription());
                                            out.println("</td>");
                                            out.println("</tr>");
                                        
                                            for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff propertyDiff : systemInfo.getQualityGateElementPropertyDiffs(nextElementDiff))
                                            {
                                                out.println("<tr>");
                                                out.println("<td>");
                                                out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Property: " + propertyDiff.getPresentationName(true));
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(propertyDiff.getChange().getPresentationName());
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(propertyDiff.getChangeDescription());
                                                out.println("</td>");
                                                out.println("</tr>");
                                            }
                                        }
                                    }
                                    
                                    List<com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff> baselineConditionDiffs = systemInfo.getBaselineConditionDiffs(nextQualityGate);
                                    if (!baselineConditionDiffs.isEmpty())
                                    {
                                        out.println("<tr>");
                                        out.println("<td colspan='3'>");
                                        out.println("Baseline Conditions");
                                        out.println("</td>");                                        
                                        out.println("</tr>");
                                        for (com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff nextElementDiff : baselineConditionDiffs)
                                        {
                                            out.println("<tr>");
                                            out.println("<td>");
                                            out.println("&nbsp;&nbsp;&nbsp;&nbsp;" + nextElementDiff.getPresentationName(false));
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(nextElementDiff.getChange().getPresentationName());
                                            out.println("</td>");
                                            out.println("<td>");
                                            out.println(nextElementDiff.getChangeDescription());
                                            out.println("</td>");
                                            out.println("</tr>");
                                        
                                            for (com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff propertyDiff : systemInfo.getQualityGateElementPropertyDiffs(nextElementDiff))
                                            {
                                                out.println("<tr>");
                                                out.println("<td>");
                                                out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Property: " + propertyDiff.getPresentationName(true));
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(propertyDiff.getChange().getPresentationName());
                                                out.println("</td>");
                                                out.println("<td>");
                                                out.println(propertyDiff.getChangeDescription());
                                                out.println("</td>");
                                                out.println("</tr>");
                                            }
                                        }
                                    }
                                    %>
                                </table>
                                <script>
                                    var filtersConfig = {
                                        base_path: 'tablefilter/',
                                        alternate_rows: true,
                                        grid: false,
                                        col_widths: ['', '200px', '300px'],
                                        themes: [{ name: 'default' }]
                                    };
                                    var tf = new TableFilter('<%=qualityGateId%>', filtersConfig);
                                    tf.init();
                                </script>
                                <% 
                                }
                                %>    
                            <% 
                            } 
                            %> 
                            </td>
                        </tr>
                   <%
                   } //end of quality gate configuration
                   %>        
				<%
				} //end of basic system info 
				%>
							            
<!-- System Metrics -->
               <tr>
                    <td>
                    <%
                    List<com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff> metricValueDiffs = metricInfo.getValueDiffs();
                    if (metricValueDiffs.isEmpty())
                    {
                    %>
                    	<h2><a name="metric"></a>System Metrics (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <%
                    }
                    else
                    {
                    %>
                        <h2><a name="metric"></a>System Metrics <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                        <table class="techTable" id="systemMetrics">
                            <thead>
                                <tr>
                                    <th>Metric</th>
                                    <th>Categories</th>
                                    <th>Change</th>
                                    <th>Details</th>
                                    <%
                                    if (currentReport.isQualityGateCheckActive())
                                	{
                                	%>
                                		<th>Affecting Quality Gate(s)</th>
                                	<%
                                	}
                                	%>		                                        
                                </tr>
                            </thead>
                            <% 
                              int i = 0;
                              for (com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff metricValueDiff : metricValueDiffs)
                              {
                                out.println("<tr>");
                                out.println("<td>");
                                out.println(metricValueDiff.getMetricPresentationName());
                                out.println("</td>");
                                out.println("<td>");
                                out.println(metricInfo.getCategories(metricValueDiff));
                                out.println("</td>");
                                out.println("<td>");
                                out.println(metricValueDiff.getChange());
                                out.println("</td>");
                                out.println("<td>");
                                out.println(metricValueDiff.getChangeDescription());
                                out.println("</td>");
                                if (currentReport.isQualityGateCheckActive())
                                {
                                	com.hello2morrow.sonargraph.core.model.element.Element currentValue = metricValueDiff.getCurrentElement();
                                	boolean affecting = currentValue != null && currentReport.metricValueAffectingQualityGates(currentValue);
	                            	if (affecting)
                                	{
                                		out.println("<td class=\"qualityGateAffecting\">");
                                	}
                                	else
                                	{
                                		out.println("<td>");
                                	}
                                	out.println(affecting);
                                	out.println("</td>");
                                }                                        
                                out.println("</tr>");
                                i++;
                              }
                            %>
                        </table>
                        <script>
                        	var rowCount = <%=i%>;
                    		var rowCounts = [25, 50];
                    		if (rowCount > 50)
                    		{
                    			rowCounts = [25, 50, rowCount];
                    		}
                    		var enablePaging = rowCount > 25;
	                                		
                    		var filtersConfig = {
								base_path: 'tablefilter/',
				        		extensions:[{
				        			name: 'sort',
				        			types: ['string', 'string', 'string', 'string']
				        			}],
								alternate_rows: true,
								rows_counter: true,
				            	rows_counter_text: 'Metrics: ',
				            	btn_reset: true,
				            	status_bar: true,
				            	loader: true,
								mark_active_columns: true,
								highlight_keywords: true,
								paging: enablePaging,
						        results_per_page: ['Metrics/Page: ', rowCounts],
						        
						        <%
                                if (currentReport.isQualityGateCheckActive())
                            	{
                            	%>
                            		col_widths: ['350px', '350px', '150px', '', '250px'],
                            	<%
                            	} 
                            	else 
                            	{
                            	%>
                            		col_widths: ['350px', '350px', '150px', ''],
                            	<%
                            	}
                            	%>
						        
						        
				        		themes: [{ name: 'default' }]
						    };
							var tf = new TableFilter('systemMetrics', filtersConfig);
							tf.init();
						</script>
                    <% 
                    } 
                    %> 
                    </td>
                </tr>
                						
<!-- Workspace -->
                    <%
                    if (!workspaceInfo.hasChanges())
                    {
                    %>
                    <tr>
                    	<td width="100%"> <!-- these 100% are needed, otherwise the table cell is not expanded later on for wider tables -->
                    		<h2><a name="workspace"></a>Workspace (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    	</td>
                    </tr>
                    <%
                    }
                    else
                    {
                    %>
	                    <tr>
	                    	<td width="100%"> <!-- these 100% are needed, otherwise the table cell is not expanded later on for wider tables -->
	                        	<h2><a name="workspace"></a>Workspace <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
	                        </td>
	                    </tr>
	                    <% 
	                    List<com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff> workspaceFilterPatternDiffs = workspaceInfo.getWorkspaceFilterPatterns();
	                    if (!workspaceFilterPatternDiffs.isEmpty())
	                    {
	                    %>
		                    <tr>
		                    	<td>
		                    		<h3>Workspace Filter <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
			                        <table class="techTable" id="workspaceFilter">
			                            <thead>
			                                <tr>
			                                    <th width="100">Type</th>
			                                    <th width="400">Pattern</th>
			                                    <th width="100">Info</th>
			                                    <th width="150">Change</th>
			                                    <th>Details</th>		                                        
			                                </tr>
			                            </thead>
			                            <% 
			                              for (com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff patternDiff : workspaceFilterPatternDiffs)
			                              {
			                                out.println("<tr>");
			                                out.println("<td>");
			                                out.println(patternDiff.getType());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getShortName());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getInformation());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChange());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChangeDescription());
			                                out.println("</td>");                                        
			                                out.println("</tr>");
			                              }
			                            %>
			                        </table>
			                        <script>
			                    		var filtersConfig = {
											base_path: 'tablefilter/',
											alternate_rows: true,
							        		grid: false,
							        		col_types:['string', 'string', 'string', 'string'],
										    col_widths: ['150px', '250px', '250px', '150px', ''],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('workspaceFilter', filtersConfig);
										tf.init();
									</script>
								</td>
							</tr>
	                    <% 
	                    } //End of WorkspaceFilter
	                    %>
	                    <% 
	                    List<com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff> productionCodeFilterPatternDiffs = workspaceInfo.getProductionCodeFilterPatterns();
	                    if (!productionCodeFilterPatternDiffs.isEmpty())
	                    {
	                    %>
		                    <tr>
		                    	<td>
		                    		<h3>Production Code Filter <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
			                        <table class="techTable" id="productionCodeFilter">
			                            <thead>
			                                <tr>
			                                    <th width="100">Type</th>
			                                    <th width="400">Pattern</th>
			                                    <th width="100">Info</th>
			                                    <th width="150">Change</th>
			                                    <th>Details</th>		                                        
			                                </tr>
			                            </thead>
			                            <% 
			                              for (com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff patternDiff : productionCodeFilterPatternDiffs)
			                              {
			                                out.println("<tr>");
			                                out.println("<td>");
			                                out.println(patternDiff.getType());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getShortName());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getInformation());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChange());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChangeDescription());
			                                out.println("</td>");                                        
			                                out.println("</tr>");
			                              }
			                            %>
			                        </table>
			                        <script>
			                    		var filtersConfig = {
											base_path: 'tablefilter/',
											alternate_rows: true,
							        		grid: false,
							        		col_types:['string', 'string', 'string', 'string'],
										    col_widths: ['150px', '250px', '250px', '150px', ''],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('productionCodeFilter', filtersConfig);
										tf.init();
									</script>
								</td>
							</tr>
	                    <% 
	                    }	//End of ProductionCodeFilter
	                    %>
	                    <% 
	                    List<com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff> issueFilterPatternDiffs = workspaceInfo.getIssueFilterPatterns();
	                    if (!issueFilterPatternDiffs.isEmpty())
	                    {
	                    %>
		                    <tr>
		                    	<td>
		                    		<h3>Issue Filter <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
			                        <table class="techTable" id="issueFilter">
			                            <thead>
			                                <tr>
			                                    <th width="100">Type</th>
			                                    <th width="400">Pattern</th>
			                                    <th width="100">Info</th>
			                                    <th width="150">Change</th>
			                                    <th>Details</th>		                                        
			                                </tr>
			                            </thead>
			                            <% 
			                              for (com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff patternDiff : issueFilterPatternDiffs)
			                              {
			                                out.println("<tr>");
			                                out.println("<td>");
			                                out.println(patternDiff.getType());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getShortName());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getInformation());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChange());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(patternDiff.getChangeDescription());
			                                out.println("</td>");                                        
			                                out.println("</tr>");
			                              }
			                            %>
			                        </table>
			                        <script>
			                    		var filtersConfig = {
											base_path: 'tablefilter/',
											alternate_rows: true,
							        		grid: false,
							        		col_types:['string', 'string', 'string', 'string', 'string'],
										    col_widths: ['150px', '250px', '250px', '150px', ''],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('issueFilter', filtersConfig);
										tf.init();
									</script>
								</td>
							</tr>
	                    <% 
	                    } //End of IssueFilter
	                    %>						                   
	                    <% 
	                    List<com.hello2morrow.sonargraph.core.persistence.diff.WorkspaceInfo.RootPathInfo> rootPathDiffs = workspaceInfo.getRootDirectoryChanges();
	                    if (!rootPathDiffs.isEmpty())
	                    {
	                    %>
		                    <tr>
		                    	<td>
		                    		<h3>Root Directories <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h3>
			                        <table class="techTable" id="rootDirectories" width="100%">
			                            <thead>
			                                <tr>
			                                    <th width="300">Module</th>
			                                    <th width="400">Root Path</th>
			                                    <!-- th width="100">Information</th -->
			                                    <th width="150">Change</th>
			                                    <th>Details</th>		                                        
			                                </tr>
			                            </thead>
			                            <% 
			                              int i = 0;
			                              for (com.hello2morrow.sonargraph.core.persistence.diff.WorkspaceInfo.RootPathInfo rootPathDiff : rootPathDiffs)
			                              {
			                                out.println("<tr>");
			                                out.println("<td>");
			                                out.println(rootPathDiff.getModuleName());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(rootPathDiff.getPath());
			                                out.println("</td>");
			                                /*
			                                out.println("<td>");
			                                out.println(rootPathDiff.getInformation());
			                                out.println("</td>");
			                                */
			                                out.println("<td>");
			                                out.println(rootPathDiff.getChange());
			                                out.println("</td>");
			                                out.println("<td>");
			                                out.println(rootPathDiff.getChangeDescription());
			                                out.println("</td>");                                        
			                                out.println("</tr>");
			                                i++;
			                              }
			                            %>
			                        </table>
			                        <script>
			                        	var rowCount = <%=i%>;
                                		var rowCounts = [25, 50];
                                		if (rowCount > 50)
                                		{
                                			rowCounts = [25, 50, rowCount];
                                		}
                                		var enablePaging = rowCount > 25;
			                    		var filtersConfig = {
											base_path: 'tablefilter/',
							        		extensions:[{
								          		name: 'sort',
								          		types: ['string', 'string', 'string', 'string']
							        		}],
											alternate_rows: true,
											rows_counter: true,
							            	rows_counter_text: 'Root Directories: ',
							            	btn_reset: true,
							            	status_bar: true,
							            	loader: true,
											mark_active_columns: true,
											highlight_keywords: true,
											paging: enablePaging,
									        results_per_page: ['Directories/Page: ', rowCounts],
									       	col_widths: ['', '', '150px', ''],
							        		themes: [{ name: 'default' }]
									    };
										var tf = new TableFilter('rootDirectories', filtersConfig);
										tf.init();
									</script>
								</td>
							</tr>
	                    <% 
	                    } //End of Roots
	                    %>
	                <%
                    } //End of Workspace Info
                    %>                   			                 											
<!-- Issues -->
            <tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff> issueDiffs = issueInfo.getIssueChanges();
                if (issueDiffs.isEmpty())
                {
                %>
                	<h2><a name="issue"></a>Issues (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="issue"></a>Issues <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="issues" width="100%">
                        <thead>
                            <tr>
                                <th>Issue</th>
                                 <%
                                if (currentReport.isQualityGateCheckActive())
                            	{
                            	%>
                            		<th>Affecting<br/>Quality Gate(s)</th>
                            	<%
                            	}
                            	%>
                                <th>Severity</th>
                                <th>Category</th>
                                <th>Element</th>
                                <th>Change</th>
                                <th>Details</th>		                                        
                                <th>Provider</th>
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff issueDiff : issueDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(issueDiff.getPresentationName(true));
                            out.println("</td>");
                            
                            if (currentReport.isQualityGateCheckActive())
                            {
                            	com.hello2morrow.sonargraph.core.model.element.Element currentElement = issueDiff.getCurrentElement();
                            	boolean affecting = currentElement != null && currentReport.issueAffectingQualityGates(issueDiff.getCurrent());
                            	if (affecting)
                            	{
                            		out.println("<td class=\"qualityGateAffecting\">");
                            	} 
                            	else
                            	{
                            		out.println("<td>");
                            	}
                            	out.println(affecting);
                            	out.println("</td>");
                            }
                            
                            out.println("<td>");
                            out.println(issueDiff.getSeverity().getPresentationName());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueDiff.getIssueCategoryPresentationName());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueDiff.getAffectedElementPresentationName(false));
                            out.println("</td>"); 
                            out.println("<td>");
                            out.println(issueDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueDiff.getChangeDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueDiff.getProviderPresentationName());
                            out.println("</td>");
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort'				          		
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Issues: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Issues/Page: ', rowCounts],
					        <%
                            if (currentReport.isQualityGateCheckActive())
                        	{
                        	%>
                        		col_widths: ['200px', '130px', '100px', '150px', '', '200px', '450px', '250px'],
                        	<%
                        	}
                        	else
                        	{
                        	%>
                        		col_widths: ['200px', '100px', '150px', '', '200px', '450px', '250px'],
                        	<%
                        	}
                        	%>
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('issues', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of issues
                %>
				</td>
			</tr>
                         
<!-- Ignores -->
		     <tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff> ignoreDiffs = resolutionInfo.getIgnoreChanges();
                if (ignoreDiffs.isEmpty())
                {
                %>
                	<h2><a name="ignore"></a>Ignores (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="ignore"></a>Ignores <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="ignores" width="100%">
                        <thead>
                            <tr>
                                <th width="150">Change</th>
                                <th width="300">Details</th>		                                        
                                <th>Definition</th>
                                <th width="300">Description</th>
                                <th width="150">Created</th>
                                <th width="100">Matched</th>                                
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff ignoreDiff : ignoreDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(ignoreDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(ignoreDiff.getChangeDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(ignoreDiff.getDefinition());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(ignoreDiff.getDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(ignoreDiff.getCreatedAsFormattedString());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(ignoreDiff.getMatchingElementsCount());
                            out.println("</td>"); 
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort',
				          		types: ['string', 'string']
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Ignores: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Resolutions/Page: ', rowCounts],
					       	col_widths: ['150px', '300px', '', '300px', '150px', '100px'],
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('ignores', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of ignores
                %>
				</td>
			</tr>

<!-- Tasks -->
			<tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff> taskDiffs = resolutionInfo.getTaskChanges();
                if (taskDiffs.isEmpty())
                {
                %>
                	<h2><a name="task"></a>Tasks (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="task"></a>Tasks <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="tasks" width="100%">
                        <thead>
                            <tr>
                                <th width="150">Change</th>
                                <th width="300">Details</th>		                                        
                                <th>Definition</th>
                                <th width="300">Description</th>
                                <th width="100">Priority</th>
                                <th width="150">Assignee</th>
                                <th width="150">Created</th>
                                <th width="100">Matched</th>                                
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff taskDiff : taskDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(taskDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(resolutionInfo.getChangeDescription(taskDiff));
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getDefinition());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getPriority().getPresentationName());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getAssignee());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getCreatedAsFormattedString());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(taskDiff.getMatchingElementsCount());
                            out.println("</td>"); 
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort',
				          		types: ['string', 'string']
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Tasks: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Tasks/Page: ', rowCounts],
					       	col_widths: ['150px', '300px', '', '300px', '150px', '100px'],
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('tasks', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of tasks
                %>
				</td>
			</tr>
			
<!-- Refactorings -->
			<tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.resolution.RefactoringDefinitionDiff> refactoringDiffs = resolutionInfo.getRefactoringChanges();
                if (refactoringDiffs.isEmpty())
                {
                %>
                	<h2><a name="refactoring"></a>Refactorings (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="refactoring"></a>Refactorings <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="refactorings" width="100%">
                        <thead>
                            <tr>
                                <th width="150">Change</th>
                                <th width="300">Details</th>		                                        
                                <th>Definition</th>
                                <th width="100">Status</th>
                                <th width="300">Description</th>
                                <th width="100">Priority</th>
                                <th width="150">Assignee</th>
                                <th width="150">Created</th>
                                <th width="100">Matched</th>                                
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.resolution.RefactoringDefinitionDiff refactoringDiff : refactoringDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(refactoringDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(resolutionInfo.getChangeDescription(refactoringDiff));
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getDefinition());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getStatus().getPresentationName());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getPriority().getPresentationName());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getAssignee());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getCreatedAsFormattedString());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(refactoringDiff.getMatchingElementsCount());
                            out.println("</td>"); 
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort',
				          		types: ['string', 'string', 'string', 'string', 'string', 'string', 'string', 'string', 'number']
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Refactorings: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Refactorings/Page: ', rowCounts],
					       	col_widths: ['150px', '300px', '', '300px', '150px', '100px'],
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('refactorings', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of refactorings
                %>
				</td>
			</tr>
<!-- Cycle Groups -->
			<tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff> cycleDiffs = issueInfo.getCycleChanges();
                if (cycleDiffs.isEmpty())
                {
                %>
                	<h2><a name="cycle"></a>Cycle Groups (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="cycle"></a>Cycle Groups <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="cycles" width="100%">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <%
                                if (currentReport.isQualityGateCheckActive())
                            	{
                            	%>
                            		<th>Affecting Quality Gate(s)</th>
                            	<%
                            	}
                            	%>
                                <th>Size</th>		                                        
                                <th>Scope</th>
                                <th>Change</th>
                                <th>Details</th>
                                <th>Resolution</th>
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.issue.CycleGroupIssueDiff cycleDiff : cycleDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(cycleDiff.getPresentationName(true));
                            for (String nextCyclic : issueInfo.getCyclicElementNames(cycleDiff))
                            {
                            	out.println("<br/>&nbsp;&nbsp;&nbsp;&nbsp;" + nextCyclic);
                            }
                            out.println("</td>");
                            if (currentReport.isQualityGateCheckActive())
                            {
                            	com.hello2morrow.sonargraph.core.model.element.Element currentElement = cycleDiff.getCurrentElement();
                            	boolean affecting = currentElement != null && currentReport.issueAffectingQualityGates(cycleDiff.getCurrent());
                            	if (affecting)
                            	{
                            		out.println("<td class=\"qualityGateAffecting\">");
                            	} 
                            	else
                            	{
                            		out.println("<td>");
                            	}
                            	out.println(affecting);
                            	out.println("</td>");
                            }
                            out.println("<td>");
                            out.println(cycleDiff.getNumberOfCyclicElements());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(cycleDiff.getScope());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(cycleDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(cycleDiff.getChangeDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueInfo.getResolution(cycleDiff));
                            out.println("</td>");                            
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort',
				          		types: ['string', 'number', 'string', 'string', 'string', 'string']
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Cycle Groups: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Cyles/Page: ', rowCounts],
					       	<%
                            if (currentReport.isQualityGateCheckActive())
                        	{
                        	%>
                        		col_widths: ['', '180px', '100px', '250px', '100px', '450px', '100px'],
                        	<%
                        	}
                        	else
                        	{
                        	%>
                        		col_widths: ['', '100px', '250px', '100px', '450px', '100px'],	
                        	<%
                        	}
                        	%>
					       	
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('cycles', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of cycles
                %>
				</td>
			</tr>
<!-- Duplicate Code Blocks -->
			<tr>
            	<td>
	           <% 
                List<com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff> duplicateDiffs = issueInfo.getDuplicateChanges();
                if (duplicateDiffs.isEmpty())
                {
                %>
                	<h2><a name="duplicates"></a>Duplicate Code Blocks (Unmodified) <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                <%
                }
                else
                {
                %>
            		<h2><a name="duplicates"></a>Duplicate Code Blocks <a href="#top"><font size="1" color="#9999ff">[Top]</font></a></h2>
                    <table class="techTable" id="duplicates" width="100%">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <%
                                if (currentReport.isQualityGateCheckActive())
                            	{
                            	%>
                            		<th>Affecting Quality Gate(s)</th>
                            	<%
                            	}
                            	%>
                                <th>Change</th>		                                        
                                <th>Details</th>
                                <th>Occurrences</th>                                
                                <th>Resolution</th>
                            </tr>
                        </thead>
                        <% 
                          int i = 0;
                          for (com.hello2morrow.sonargraph.core.model.system.diff.issue.DuplicateCodeBlockIssueDiff duplicateDiff : duplicateDiffs)
                          {
                            out.println("<tr>");
                            out.println("<td>");
                            out.println(duplicateDiff.getPresentationName(true));
                            for (String nextOcc : issueInfo.getDuplicateOccurrenceNames(duplicateDiff))
                            {
                            	out.println("<br/>&nbsp;&nbsp;&nbsp;&nbsp;" + nextOcc);
                            }
                            out.println("</td>");
                            
                            if (currentReport.isQualityGateCheckActive())
                            {
                            	com.hello2morrow.sonargraph.core.model.element.Element currentElement = duplicateDiff.getCurrentElement();
                            	boolean affecting = currentElement != null && currentReport.issueAffectingQualityGates(duplicateDiff.getCurrent());
                            	if (affecting)
                            	{
                            		out.println("<td class=\"qualityGateAffecting\">");
                            	} 
                            	else
                            	{
                            		out.println("<td>");
                            	}
                            	out.println(affecting);
                            	out.println("</td>");
                            }
                            
                            out.println("<td>");
                            out.println(duplicateDiff.getChange());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(duplicateDiff.getChangeDescription());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(duplicateDiff.getNumberOfOccurrences());
                            out.println("</td>");
                            out.println("<td>");
                            out.println(issueInfo.getResolution(duplicateDiff));
                            out.println("</td>");                            
                            out.println("</tr>");
                            i++;
                          }
                        %>
                    </table>
                    <script>
                    	var rowCount = <%=i%>;
                		var rowCounts = [25, 50];
                		if (rowCount > 50)
                		{
                			rowCounts = [25, 50, rowCount];
                		}
                		var enablePaging = rowCount > 25;
                		var filtersConfig = {
							base_path: 'tablefilter/',
			        		extensions:[{
				          		name: 'sort',
				          		<%
                                if (currentReport.isQualityGateCheckActive())
                            	{
                            	%>
                            		types: ['string', 'string', 'string', 'string', 'number', 'string']
                            	<%
                            	}
                            	else
                            	{
                            	%>
                            		types: ['string', 'string', 'string', 'number', 'string']	
                            	<%
                            	}
                            	%>				          		
			        		}],
							alternate_rows: true,
							rows_counter: true,
			            	rows_counter_text: 'Duplicate Code Blocks: ',
			            	btn_reset: true,
			            	status_bar: true,
			            	loader: true,
							mark_active_columns: true,
							highlight_keywords: true,
							paging: enablePaging,
					        results_per_page: ['Duplicates/Page: ', rowCounts],
					        <%
                            if (currentReport.isQualityGateCheckActive())
                        	{
                        	%>
                        		col_widths: ['', '180px', '100px', '450px', '120px', '150px'],
                        	<%
                        	}
                        	else
                        	{
                        	%>
                        		col_widths: ['', '100px', '450px', '120px', '150px'],	
                        	<%
                        	}
                        	%>
			        		themes: [{ name: 'default' }]
					    };
						var tf = new TableFilter('duplicates', filtersConfig);
						tf.init();
					</script>
                <% 
                } //End of duplicates
                %>
				</td>
			</tr>			
			
	        </table>
	    </td>
    <!-- end of real content -->
            </tr>
        </table>
    </body>
</html>