/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementKind;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdNamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlReportReaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlReportReaderUtils.class);

    private XmlReportReaderUtils() {
    }

    static XsdElementKind getXsdElementKind(XsdNamedElement xsdNamedElement) {
        assert (xsdNamedElement != null) : "Parameter 'xsdNamedElement' of method 'getXsdElementKind' must not be null";
        Object kind = xsdNamedElement.getKind();
        if (kind == null) {
            String msg = "No associated element kind found for named element: " + xsdNamedElement.getFqName();
            LOGGER.error(msg);
            throw new NullPointerException(msg);
        }
        if (!(kind instanceof XsdElementKind)) {
            String msg = "Associated element kind is of wrong class '" + kind.getClass().getName() + "' for named element: " + xsdNamedElement.getFqName();
            LOGGER.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return (XsdElementKind)kind;
    }
}

