/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings;

import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.settings.ConfigurationLevel;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleOrSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsBuilder;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsDelta
implements ISettingsDelta {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsDelta.class);
    private NamedElement m_originalSettings;
    private NamedElement m_newSettings;
    private IChangeListener m_listener;

    public SettingsDelta(NamedElement original, IChangeListener listener) {
        assert (original != null) : "Parameter 'original' of method 'ModuleSettingsDelta' must not be null";
        this.m_originalSettings = original;
        this.m_newSettings = SettingsBuilder.copy(this.m_originalSettings);
        this.m_listener = listener;
    }

    public boolean isModified() {
        return !SettingsBuilder.areEqual(this.m_originalSettings, this.m_newSettings);
    }

    public void reset() {
        this.m_newSettings = SettingsBuilder.copy(this.m_originalSettings);
    }

    private void removeIssuesRecursively(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'removeIssuesRecursively' must not be null";
        namedElement.removeIssues();
        for (NamedElement child : namedElement.getChildren()) {
            this.removeIssuesRecursively(child);
        }
    }

    public void dispose() {
        this.m_originalSettings = null;
        this.removeIssuesRecursively(this.m_newSettings);
        this.m_newSettings.setParent(null);
        this.m_newSettings = null;
        this.m_listener = null;
    }

    public void setBasePathForIncludes(TFile input) {
        assert (input != null) : "Parameter 'input' of method 'setBasePathForIncludes' must not be null";
        LOGGER.debug("Updated baseDir for includes to " + input.getNormalizedAbsolutePath());
        BasePathForIncludes basePathForIncludes = (BasePathForIncludes)((Object)this.m_newSettings.getUniqueExistingChild(BasePathForIncludes.class));
        if (basePathForIncludes.getAbsolutePath().equals(input.getNormalizedAbsolutePath())) {
            LOGGER.debug("BasePath did not change");
            return;
        }
        basePathForIncludes.setPath(input.getNormalizedAbsoluteFile());
        IChangeListener listener = this.m_listener;
        this.m_listener = null;
        for (ModuleCompilerOptions options : this.m_newSettings.getChildren(ModuleCompilerOptions.class)) {
            String optionsText = this.getCompilerOptionsText(options.getName());
            this.setCompilerOptionsText(options.getName(), optionsText);
        }
        this.m_listener = listener;
        this.notifyChange();
    }

    public void setCppSourceFileExtensions(String extensions) {
        assert (extensions != null && extensions.length() > 0) : "Parameter 'extensions' of method 'setCppSourceFileExtensions' must not be empty";
        NamedElement cppExtensions = (NamedElement)this.m_newSettings.getUniqueChild(CppSourceFileExtensions.class);
        if (cppExtensions != null) {
            cppExtensions.remove();
        }
        HashSet<String> exts = new HashSet<String>(StringUtility.splitAndTrim((String)extensions, (String)","));
        boolean addNew = true;
        if (cppExtensions == null) {
            Set defaults = new CppSourceFileExtensions(null).getSourceFileExtensions();
            boolean bl = addNew = !defaults.equals(exts);
        }
        if (addNew) {
            this.m_newSettings.addChild((NamedElement)new CppSourceFileExtensions(this.m_newSettings, exts));
            this.notifyChange();
        }
    }

    public void setCompilerOptionsText(String definitionId, String optionsText) {
        GroovyTemplateElement template2;
        assert (definitionId != null && definitionId.length() > 0) : "Parameter 'definitionId' of method 'setCompilerOptionsText' must not be empty";
        assert (optionsText != null) : "Parameter 'optionsText' of method 'setCompilerOptionsText' must not be null";
        ModuleOrSystemCompilerOptions options = this.getCompilerOptions(definitionId);
        options.removeIssues();
        for (GroovyTemplateElement template2 : options.getChildren(GroovyTemplateElement.class)) {
            options.removeChild(template2);
            template2.setParent(null);
        }
        for (ICompilerOption option : options.getChildren(ICompilerOption.class)) {
            NamedElement element = (NamedElement)option;
            options.removeChild(element);
            element.setParent(null);
        }
        template2 = new GroovyTemplateElement((NamedElement)options, "Options", optionsText);
        options.addChild(template2);
        options.addOptions(StringUtility.multiLineStringToList((String)template2.getResolvedText()));
        options.validate(false, ConfigurationLevel.MODULE);
        this.notifyChange();
    }

    public String getCompilerOptionsText(String definitionId) {
        assert (definitionId != null) : "Parameter 'definitionId' of method 'getCompilerOptionsText' must not be null";
        ModuleOrSystemCompilerOptions options = this.getCompilerOptions(definitionId);
        GroovyTemplateElement template = (GroovyTemplateElement)((Object)options.getUniqueChild(GroovyTemplateElement.class));
        if (template == null) {
            return "";
        }
        return template.getTemplateText();
    }

    public NamedElement getOriginal() {
        return this.m_originalSettings;
    }

    public NamedElement getModified() {
        return this.m_newSettings;
    }

    public String getResolvedCompilerOptionsText(String definitionId) {
        ModuleOrSystemCompilerOptions options = this.getCompilerOptions(definitionId);
        String resolvedText = StringUtility.concat(options.getOptions(), (String)StringUtility.LINE_SEPARATOR);
        return resolvedText;
    }

    private void notifyChange() {
        if (this.m_listener == null) {
            return;
        }
        this.m_listener.notifyChange(this.isModified());
    }

    public ModuleOrSystemCompilerOptions getCompilerOptions(String definitionId) {
        List optionsList = this.m_newSettings.getChildren((NamedElement.IFilter)new NameFilter(definitionId), ModuleOrSystemCompilerOptions.class);
        assert (optionsList.size() == 1) : "Exactly one child with name '" + definitionId + "' of type '" + ModuleCompilerOptions.class.getName() + "' expected, but found '" + optionsList.size() + "'";
        return (ModuleOrSystemCompilerOptions)((Object)optionsList.get(0));
    }

    public static interface IChangeListener {
        public void notifyChange(boolean var1);
    }
}

