/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature;

import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignatureParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class CppSignature
extends CppSignatureParser
implements ISnapshotWriter.IStorable {
    private static final ProgrammingElement[] EMPTY = new ProgrammingElement[0];
    private final ProgrammingElement[] m_referencedTypes;

    public CppSignature(ISnapshotReader reader) throws IOException, ClassNotFoundException {
        super(reader.readString());
        short size = reader.readShort();
        if (size == 0) {
            this.m_referencedTypes = EMPTY;
        } else {
            this.m_referencedTypes = new ProgrammingElement[size];
            int i = 0;
            while (i < this.m_referencedTypes.length) {
                this.m_referencedTypes[i] = (ProgrammingElement)reader.read(ProgrammingElement.class, new SnapshotArgument[0]);
                ++i;
            }
        }
    }

    public CppSignature(String sig) {
        super(sig);
        this.m_referencedTypes = EMPTY;
    }

    public CppSignature(String signature, ProgrammingElement[] referencedTypes) {
        super(signature);
        this.m_referencedTypes = referencedTypes.length == 0 ? EMPTY : referencedTypes;
    }

    public CppSignature(CppSignature other) {
        super(other.m_signature);
        this.m_referencedTypes = other.m_referencedTypes.length > 0 ? (ProgrammingElement[])other.m_referencedTypes.clone() : other.m_referencedTypes;
    }

    public List<ProgrammingElement> getInvalidReferences() {
        ArrayList<ProgrammingElement> result = new ArrayList<ProgrammingElement>();
        ProgrammingElement[] programmingElementArray = this.m_referencedTypes;
        int n = this.m_referencedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ProgrammingElement type = programmingElementArray[n2];
            if (!type.isValid()) {
                result.add(type);
            }
            ++n2;
        }
        return result;
    }

    public boolean isValid() {
        ProgrammingElement[] programmingElementArray = this.m_referencedTypes;
        int n = this.m_referencedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ProgrammingElement type = programmingElementArray[n2];
            if (!type.isValid()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean persist(ISnapshotProcessor.Mode mode) {
        return true;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        writer.writeString(this.m_signature);
        writer.writeShort((short)this.m_referencedTypes.length);
        ProgrammingElement[] programmingElementArray = this.m_referencedTypes;
        int n = this.m_referencedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ProgrammingElement next = programmingElementArray[n2];
            writer.write((ISnapshotWriter.IStorable)next);
            ++n2;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CppSignature)) {
            return false;
        }
        CppSignature sig = (CppSignature)o;
        if (!this.m_signature.equals(sig.m_signature)) {
            return false;
        }
        return Arrays.equals(this.m_referencedTypes, sig.m_referencedTypes);
    }

    public int hashCode() {
        return this.m_signature.hashCode();
    }

    public boolean hasReferences() {
        return this.m_referencedTypes.length > 0;
    }
}

