/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.IHasFqnSerialNumber;
import java.io.IOException;

public final class CppMacro
extends ProgrammingElement
implements ICppProgrammingElement,
IHasFqnSerialNumber {
    private String m_definition;
    private int m_version = 0;

    public CppMacro(NamedElement parent) {
        super(parent);
    }

    public CppMacro(IModelServiceProvider msp, NamedElement parent, String name, int lineNumber) {
        super(msp, parent, name, lineNumber);
    }

    @Property
    public String getDefinition() {
        return this.m_definition;
    }

    public void setDefinition(String definition) {
        this.m_definition = definition.trim();
    }

    public boolean includeInLogicalModel() {
        return false;
    }

    @Override
    public boolean isRealElement() {
        return false;
    }

    public boolean isMember() {
        return false;
    }

    public IStructureItem getStructureItem() {
        return CPlusPlusStructureItem.PROGRAMMING_ELEMENT;
    }

    @Override
    public void setSerialNumberForQualifiedName(short serialNumberFoQualifiedName) {
        this.m_version = serialNumberFoQualifiedName;
    }

    @Override
    public String getFullyQualifiedNamePart() {
        StringBuilder sb = new StringBuilder("#");
        sb.append(super.getFullyQualifiedNamePart());
        if (this.m_version > 0) {
            sb.append('(');
            sb.append(this.m_version);
            sb.append(')');
        }
        return sb.toString();
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_definition);
        writer.writeInt(this.m_version);
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_definition = reader.readString();
        this.m_version = reader.getVersion() <= 7 ? 0 : reader.readInt();
    }

    @Override
    public ProgrammingElement getProgrammingElement() {
        return this;
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppMacro(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppMacro(CppMacro var1);
    }
}

