/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IArchitectureFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.element.IWorkspaceFilterNamePrefixProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.AbstractComponent;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusStructureItem;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.ICppComponent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class CppComponent
extends AbstractComponent
implements IRefactorable,
ICppComponent {
    private IModelServiceProvider m_msp;
    private String m_shortName;
    private boolean m_isExcluded;
    private boolean m_ignoreIssues;
    private boolean m_isUnbound;
    private AssignmentReason m_assignmentReason = AssignmentReason.UNKNOWN;

    public CppComponent(NamedElement parent) {
        super(parent);
    }

    public CppComponent(IModelServiceProvider msp, NamedElement parent, String name, boolean isUnbound) {
        super(parent);
        assert (msp != null) : "Parameter 'msp' of method 'CppComponent' must not be null";
        this.m_shortName = name;
        this.m_msp = msp;
        this.m_isUnbound = isUnbound;
    }

    public AssignmentReason getAssignmentReason() {
        return this.m_assignmentReason;
    }

    public void setAssignmentReason(AssignmentReason assignmentReason) {
        this.m_assignmentReason = assignmentReason;
    }

    public String getDescription() {
        String reason = "";
        switch (this.m_assignmentReason) {
            case UNKNOWN: {
                reason = "Component could not be asigned to a module automatically";
                break;
            }
            case ANCHORED: {
                reason = "Component is anchorec by its source file";
                break;
            }
            case EXPLICIT: {
                reason = "Component was explicitly asigned to this module";
                break;
            }
            case BY_INCLUDE_FOLDER: {
                reason = "Component was assigned due to include folder belonging to this module";
                break;
            }
            case BY_ROOT_FOLDER: {
                reason = "Component was asssigned based on module root directories";
                break;
            }
            case BY_WEAK_ROOT: {
                reason = "Component was assigned due to provisional root directory";
            }
        }
        return reason;
    }

    @Property
    public boolean isUnbound() {
        return this.m_isUnbound;
    }

    protected void lastChildRemoved() {
        this.remove();
        this.setParent(null);
    }

    public NamedElement getParent() {
        return this.getParent(this.m_msp);
    }

    public List<NamedElement> getChildren() {
        return this.getChildren(this.m_msp);
    }

    public NamedElement getOriginal() {
        return this.getOriginal(this.m_msp);
    }

    public NamedElement getRepresentative() {
        return this.getRepresentative(this.m_msp);
    }

    public boolean hasSourceFiles() {
        return this.hasChildren(true, new Class[]{CppSourceFile.class});
    }

    public String getFullyQualifiedNamePart() {
        return "(C)" + super.getFullyQualifiedNamePart();
    }

    public void setModelServiceProvider(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'setModelServiceProvider' must not be null";
        this.m_msp = msp;
    }

    public Element.IPropertiesManager getPropertiesManager() {
        return this.m_msp.getPropertiesManager();
    }

    public ElementWithIssues.IIssueManager getIssueManager() {
        return this.m_msp.getIssueManager();
    }

    public IVirtualModel getCurrentModel() {
        return this.m_msp.getCurrentModel();
    }

    public void setIsExcluded(boolean excluded) {
        this.m_isExcluded = excluded;
    }

    @Property
    public boolean isExcluded() {
        return this.m_isExcluded;
    }

    public void setIgnoreIssues(boolean ignore) {
        this.m_ignoreIssues = ignore;
    }

    @Property
    public boolean ignoreIssues() {
        return this.m_ignoreIssues;
    }

    public String getName() {
        return this.getArchitectureFilterName();
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public void setShortName(String shortName) {
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'setShortName' must not be empty";
        this.m_shortName = shortName;
    }

    public void store(ISnapshotWriter writer) throws IOException {
        super.store(writer);
        writer.writeString(this.m_shortName);
        writer.writeBoolean(this.m_isUnbound);
        writer.writeString(this.m_assignmentReason.name());
    }

    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        String val;
        super.retrieve(reader);
        this.m_shortName = reader.readString();
        this.m_isUnbound = reader.getVersion() < 5 ? false : reader.readBoolean();
        this.m_assignmentReason = reader.getVersion() <= 25 ? null : ((val = reader.readString()) != null ? AssignmentReason.valueOf(val) : null);
    }

    public NamedElement getNamedElement() {
        return this;
    }

    @Property
    public String getWorkspaceFilterName() {
        if (!this.isExternal()) {
            CppComponent original;
            CppComponent cppComponent = original = this.m_msp != null ? (CppComponent)this.m_msp.getCurrentModel().getOriginal((ElementWithIssues)this) : this;
            assert (original != null) : "'original' of method 'getWorkspaceFilterName' must not be null";
            IWorkspaceFilterNamePrefixProvider provider = (IWorkspaceFilterNamePrefixProvider)original.getParent(IWorkspaceFilterNamePrefixProvider.class, new Class[0]);
            assert (provider != null) : "'provider' of method 'getWorkspaceFilterName' must not be null";
            return provider.getWorkspaceFilterNamePrefix() + original.getShortName();
        }
        return "";
    }

    public String getArchitectureFilterName() {
        IArchitectureFilterNamePrefixProvider provider = (IArchitectureFilterNamePrefixProvider)this.getParent(IArchitectureFilterNamePrefixProvider.class, new Class[0]);
        assert (provider != null) : "'provider' of method 'getArchitectureFilterName' must not be null";
        return provider.getArchitectureFilterNamePrefix() + this.getShortName();
    }

    public int getSize() {
        int sourceElementCount = 0;
        for (ProgrammingElement nextProgrammingElement : this.getChildrenRecursively(ProgrammingElement.class, new Class[0])) {
            int count = nextProgrammingElement.getSourceElementCount();
            if (count <= 0) continue;
            sourceElementCount += count;
        }
        return sourceElementCount;
    }

    public boolean ignoreInModelRepresentation() {
        return false;
    }

    public IStructureItem getStructureItem() {
        return CPlusPlusStructureItem.CPP_COMPONENT;
    }

    @Override
    public boolean containsAtLeastOneSourceFile() {
        return this.getChildren(CppSourceFile.class).size() > 0;
    }

    public List<SourceFile> getSources() {
        return Collections.unmodifiableList(this.getChildren(SourceFile.class));
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitCppComponent(this);
        } else {
            super.accept(visitor);
        }
    }

    public String toString() {
        if (this.m_msp != null && this.m_msp.getCurrentModel().getOriginal((ElementWithIssues)this) != this) {
            StringBuilder builder = new StringBuilder("[Clone] ");
            builder.append(super.toString());
            return builder.toString();
        }
        return super.toString();
    }

    public static enum AssignmentReason {
        UNKNOWN,
        ANCHORED,
        EXPLICIT,
        BY_INCLUDE_FOLDER,
        BY_ROOT_FOLDER,
        BY_WEAK_ROOT;

    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitCppComponent(CppComponent var1);
    }
}

