/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser;

import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementWithSignature;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.signature.CppSignature;
import java.io.IOException;

public class CppFunctionSpec
extends CppElementWithSignature {
    private static final String NUMBER_OF_TEMPLATE_ARGUMENTS = "numberOfTemplateArguments";
    private static final String NUMBER_OF_PARAMETERS = "numberOfParameters";
    private short m_numberOfTemplateArguments;
    private short m_numberOfParameters;

    public CppFunctionSpec() {
    }

    public CppFunctionSpec(CppElement parent, CppElementType type, String name, int lineNo) {
        super(parent, type, name, lineNo);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeShort(NUMBER_OF_PARAMETERS, this.m_numberOfParameters);
        writer.writeShort(NUMBER_OF_TEMPLATE_ARGUMENTS, this.m_numberOfTemplateArguments);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        this.m_numberOfParameters = reader.readShort(NUMBER_OF_PARAMETERS);
        this.m_numberOfTemplateArguments = reader.readShort(NUMBER_OF_TEMPLATE_ARGUMENTS);
    }

    @Override
    public final String getSignature() {
        String sig = super.getSignature();
        String string = sig = sig == CppSignature.UNDEFINED ? CppSignature.UNDEFINED_ROUTINE : sig;
        if (sig.indexOf(40) < 0) {
            return CppSignature.UNDEFINED_ROUTINE;
        }
        return sig;
    }

    @Override
    public final String getKey() {
        if (this.getType() == CppElementType.FUNCTION) {
            return super.getKey();
        }
        String sig = this.getSignature();
        String prefix = sig.substring(0, sig.indexOf(40));
        String result = super.getKey();
        if (prefix.length() > 0) {
            return result + ":" + prefix;
        }
        return result;
    }

    public short getNumberOfTemplateArguments() {
        return this.m_numberOfTemplateArguments;
    }

    public void setNumberOfTemplateArguments(short numberOfTemplateArguments) {
        this.m_numberOfTemplateArguments = numberOfTemplateArguments;
    }

    public short getNumberOfParameters() {
        return this.m_numberOfParameters;
    }

    public void setNumberOfParameters(short numberOfParameters) {
        this.m_numberOfParameters = numberOfParameters;
    }

    @Override
    public void accept(CppElement.Visitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)((Object)visitor)).visitCppFunctionSpec(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor {
        public void visitCppFunctionSpec(CppFunctionSpec var1);
    }
}

