/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser;

import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.TreeMap;

public class CObjectRenderer {
    private static int s_recursionCounter = 0;

    private static boolean isPlural(String singularName, String pluralName) {
        if (singularName.endsWith("y")) {
            return pluralName.equals(singularName.substring(0, singularName.length() - 1) + "ies");
        }
        return pluralName.equals(singularName + "s") || pluralName.equals(singularName + "list");
    }

    private static boolean isPlural(Class<?> clazz, String pluralName) {
        while (clazz != EDG.CObject.class) {
            if (CObjectRenderer.isPlural(clazz.getSimpleName().toLowerCase(), pluralName)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static String renderObject(EDG.CObject obj) {
        StringBuilder sb = new StringBuilder(obj.getClass().getSimpleName());
        if (++s_recursionCounter > 1) {
            sb.append(": ").append(obj.hashCode()).append(": ");
            EDG.SourceCorrespondence sc = obj.sourceCorresp();
            if (sc != null) {
                sb.append(sc.name()).append(": ").append(sc.declPosition().getPosition());
            }
        } else {
            sb.append(": ").append(obj.hashCode()).append('\n');
            EDG.SourceCorrespondence sc = obj.sourceCorresp();
            if (sc != null) {
                sb.append(sc.name()).append(": ").append(sc.declPosition().getPosition()).append('\n');
            }
            Object[] objectArray = CObjectRenderer.renderFields(obj);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                sb.append(o).append('\n');
                ++n2;
            }
        }
        --s_recursionCounter;
        return sb.toString();
    }

    public static Object[] renderFields(Object obj) {
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        Method[] methodArray = obj.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            Method m = methodArray[n2];
            Class<?> declaringClass = m.getDeclaringClass();
            if (declaringClass != EDG.CObject.class && declaringClass != Object.class && m.getParameterTypes().length == 0 && !(name = m.getName()).equals("toString") && !name.contains("_")) {
                try {
                    Object value = m.invoke(obj, new Object[0]);
                    if (value instanceof EDG.CObject && CObjectRenderer.isPlural(value.getClass(), name.toLowerCase())) {
                        Class<?> valueClass = value.getClass();
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(value);
                        try {
                            Method nextMethod = valueClass.getMethod("next", new Class[0]);
                            while ((value = nextMethod.invoke(value, new Object[0])) != null) {
                                values.add(value);
                            }
                            fields.put(name, values);
                        }
                        catch (NoSuchMethodException e) {
                            fields.put(name, value);
                        }
                    } else {
                        fields.put(name, value);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return fields.entrySet().toArray();
    }
}

