/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.IAddedOrChangedSourceFileProcessor;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.foundation.persistence.ObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DaemonException;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.DiagnosticMode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingRequest;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.RuntimeInfo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserDaemon {
    public static final String QUIT = "QUIT";
    public static final String OK = "OK";
    public static final String INIT = "INIT";
    public static final String PARSE = "PARSE";
    public static final String PREPROCESS = "PREPROCESS";
    private static final Logger LOGGER;
    private static final String PARSER_MAIN_CLASS = "com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ParsingServiceMain";
    private static final String CLASSPATH_OPTION = "-cp";
    private static final String JAVA_EXECUTABLE;
    private static final String JAVA_LIBRARY_PATH;
    private static final String PARSER_CLASSPATH;
    private static final String LOGBACK_PARSER_CONFIGURATION_FILE;
    private final int m_id;
    private final LinkedBlockingQueue<ParsingRequest> m_inputQueue;
    private final LinkedBlockingQueue<ParsingResult> m_outputQueue;
    private Process m_process = null;
    private PrintStream m_commandStream;
    private InputStream m_processOutput;
    private final DiagnosticMode m_diagnosticMode;
    private final TFile m_projectDataDir;
    private final TFile m_diagnosticDir;
    private final IAddedOrChangedSourceFileProcessor m_fileListener;
    private boolean m_daemonIsRunning = false;
    private final Thread m_daemonThread;

    static {
        String logbackParserConfigurationFile;
        block16: {
            ArrayList<String> parts;
            block15: {
                String javaLibraryPath;
                block14: {
                    LOGGER = LoggerFactory.getLogger(ParserDaemon.class);
                    JAVA_EXECUTABLE = RuntimeInfo.getJavaExecutable();
                    javaLibraryPath = null;
                    try {
                        String edgLibraryPath = null;
                        switch (Platform.getOperatingSystem()) {
                            case MAC_64: {
                                edgLibraryPath = "lib/Macosx64/libedg.dylib";
                                break;
                            }
                            case MAC_ARM_64: {
                                edgLibraryPath = "lib/MacosxARM64/libedg.dylib";
                                break;
                            }
                            case LINUX_64: {
                                edgLibraryPath = "lib/Linux64/libedg.so";
                                break;
                            }
                            case LINUX_ARM_64: {
                                edgLibraryPath = "lib/LinuxARM64/libedg.so";
                                break;
                            }
                            case WINDOWS_64: {
                                edgLibraryPath = "lib/Windows64/edg.dll";
                                break;
                            }
                            default: {
                                String message = "No EDG library avaliable for OS: " + String.valueOf(Platform.getOperatingSystem());
                                LOGGER.error(message);
                                assert (false) : message;
                                edgLibraryPath = "lib";
                            }
                        }
                        File libraryFile = RuntimeInfo.getFileInBundle("com.hello2morrow.sonargraph.language.provider.cplusplus", edgLibraryPath);
                        File libraryDirectory = libraryFile.getParentFile();
                        String libraryPath = libraryDirectory.getAbsolutePath();
                        LOGGER.info("Java library path for parser: ", (Object)libraryPath);
                        javaLibraryPath = libraryPath;
                    }
                    catch (FileNotFoundException fnfe) {
                        LOGGER.error("Couldn't detect library path for parser: " + fnfe.getMessage());
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError((Object)fnfe.getMessage());
                    }
                }
                JAVA_LIBRARY_PATH = javaLibraryPath;
                parts = new ArrayList<String>();
                try {
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.language.provider.cplusplus"));
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.core"));
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.plugin.api.cplusplus"));
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.plugin.api"));
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.common"));
                    parts.addAll(RuntimeInfo.getBundleInternalClasspath("com.hello2morrow.sonargraph.integration.access"));
                }
                catch (FileNotFoundException fnfe) {
                    LOGGER.error("Couldn't create classpath for ParserDaemon: {}", (Object)fnfe.getMessage());
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)fnfe.getMessage());
                }
            }
            PARSER_CLASSPATH = StringUtility.concat(parts, (String)(Platform.isWindows() ? ";" : ":"));
            LOGGER.info("Classpath: " + PARSER_CLASSPATH);
            logbackParserConfigurationFile = null;
            try {
                logbackParserConfigurationFile = RuntimeInfo.getFileInBundle("com.hello2morrow.sonargraph.language.provider.cplusplus", "logback-parser.xml").getAbsolutePath();
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.error("Logback parser configuration file not found:  " + fnfe.getMessage());
                if ($assertionsDisabled) break block16;
                throw new AssertionError((Object)fnfe.getMessage());
            }
        }
        LOGBACK_PARSER_CONFIGURATION_FILE = logbackParserConfigurationFile;
    }

    ParserDaemon(int id, LinkedBlockingQueue<ParsingRequest> inputQueue, LinkedBlockingQueue<ParsingResult> outputQueue, Thread.UncaughtExceptionHandler handler, InstCompilerDefinition cdef, DiagnosticMode diagnosticMode, TFile projectDataDir, TFile cppDiagnosticsDir, IAddedOrChangedSourceFileProcessor fileListener, int stackSize) {
        assert (inputQueue != null) : "Parameter 'inputQueue' of method 'ParserDaemon' must not be null";
        assert (outputQueue != null) : "Parameter 'outputQueue' of method 'ParserDaemon' must not be null";
        assert (handler != null) : "Parameter 'handler' of method 'ParserDaemon' must not be null";
        assert (cdef != null) : "Parameter 'cdef' of method 'ParserDaemon' must not be null";
        assert (diagnosticMode != null) : "Parameter 'diagnosticMode' of method 'ParserDaemon' must not be null";
        assert (projectDataDir != null) : "Parameter 'projectDataDir' of method 'ParserDaemon' must not be null";
        assert (cppDiagnosticsDir != null) : "Parameter 'cppDiagnosticsDir' of method 'ParserDaemon' must not be null";
        assert (fileListener != null) : "Parameter 'fileListener' of method 'ParserDaemon' must not be null";
        this.m_id = id;
        this.m_inputQueue = inputQueue;
        this.m_outputQueue = outputQueue;
        this.m_diagnosticMode = diagnosticMode;
        this.m_projectDataDir = projectDataDir;
        this.m_diagnosticDir = cppDiagnosticsDir;
        this.m_fileListener = fileListener;
        this.m_daemonThread = new Thread(() -> this.run(cdef, handler, id, stackSize), "ParserDaemon-" + id);
        this.m_daemonThread.setUncaughtExceptionHandler(handler);
        this.m_daemonThread.start();
    }

    void join() {
        try {
            this.m_daemonThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void run(InstCompilerDefinition cdef, Thread.UncaughtExceptionHandler handler, int id, int stackSize) {
        try {
            try {
                ParsingRequest request;
                if (!this.startParserProcess(id, stackSize) || !this.initParserProcess(cdef, false)) {
                    throw new DaemonException(String.format("Daemon process %d: failed to start", this.m_id), DaemonException.ErrorCode.FAILED_TO_START, this.m_id);
                }
                LOGGER.info("Parser daemon {} started.", (Object)this.m_id);
                while (this.m_daemonIsRunning && (request = this.m_inputQueue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                    block14: {
                        CppSourceFile src = request.getSourceFile();
                        try {
                            ParsingResult result = this.processRequest(request, false);
                            assert (result != null);
                            if (result.getModel() != null) {
                                LOGGER.debug(String.format("Daemon %d parsed '%s. Status=%d. Children=%d", this.m_id, src.getName(), result.getStatus(), result.getModel().getSource().getChildren().size()));
                            } else {
                                LOGGER.debug(String.format("Daemon %d parsed '%s. Status=%d.", this.m_id, src.getName(), result.getStatus()));
                            }
                            this.m_outputQueue.put(result);
                            if (result.requestFailed() || src.getTimestamp() == src.getFile().lastModified()) break block14;
                            this.m_fileListener.processAddedOrChangedSourceFile((SourceFile)request.getSourceFile());
                            src.setTimestamp(src.getFile().lastModified());
                        }
                        catch (IOException e) {
                            src.setTimestamp(1L);
                            this.m_daemonIsRunning = false;
                            this.m_outputQueue.put(new ParsingResult(request.getModule(), src, -6, null, null));
                            LOGGER.error(String.format("Parser daemon %d had IOExcception.", this.m_id), (Throwable)e);
                            break;
                        }
                    }
                    if (this.m_daemonIsRunning) continue;
                    if (!this.startParserProcess(id, stackSize) || !this.initParserProcess(cdef, true)) {
                        throw new DaemonException(String.format("Daemon process %d: failed to restart", this.m_id), DaemonException.ErrorCode.FAILED_TO_START, this.m_id);
                    }
                    this.processRequest(request, true);
                }
                if (this.m_daemonIsRunning) {
                    this.endParserProcess();
                    LOGGER.info("Parser daemon {} finished.", (Object)this.m_id);
                }
            }
            catch (IOException e) {
                LOGGER.error("Unexpected termination of parser daemon process caused by: " + e.getMessage(), (Throwable)e);
                throw new DaemonException(String.format("Daemon process %d: unexpected termination", this.m_id), DaemonException.ErrorCode.UNEXPECTED_TERMINATION, this.m_id);
            }
            catch (InterruptedException e) {
                LOGGER.error("Unexpected interruption of parser daemon " + this.m_id, (Throwable)e);
            }
        }
        catch (DaemonException e) {
            handler.uncaughtException(Thread.currentThread(), e);
        }
    }

    private ParsingResult processRequest(ParsingRequest request, boolean preprocessOnly) throws IOException {
        int exitCode;
        String reply;
        assert (request != null) : "Parameter 'request' of method 'processRequest' must not be null";
        ArrayList<String> command = new ArrayList<String>();
        command.add(preprocessOnly ? PREPROCESS : PARSE);
        command.add(request.getSourceFile().getAbsolutePath());
        command.addAll(request.getOptions());
        command.add("");
        this.sendCommand(command);
        try {
            reply = this.readLineFromProcess().trim();
        }
        catch (IOException e) {
            reply = "-3";
            this.m_daemonIsRunning = false;
        }
        if (reply.startsWith("Exception: ")) {
            this.m_daemonIsRunning = false;
            return new ParsingResult(request.getModule(), request.getSourceFile(), -2, "Daemon " + this.m_id + " exited with exception: " + reply.substring(11), null);
        }
        CppCompilationUnit model = null;
        try {
            exitCode = Integer.valueOf(reply);
        }
        catch (NumberFormatException e) {
            this.m_daemonIsRunning = false;
            return new ParsingResult(request.getModule(), request.getSourceFile(), -3, "Parser daemon " + this.m_id + " crashed !", null);
        }
        if (preprocessOnly) {
            return null;
        }
        if (exitCode >= 0 && exitCode != 4) {
            String modelFileName = this.readLineFromProcess().trim();
            ObjectReader reader = new ObjectReader(this.getClass().getClassLoader());
            try {
                TFile modelFile = new TFile(modelFileName);
                model = (CppCompilationUnit)reader.retrieve(modelFile, CppCompilationUnit.class);
                modelFile.rm_r();
            }
            catch (RestoreException | IOException e) {
                if (model == null) {
                    LOGGER.error("Could not extract model from parser daemon process " + this.m_id + ".", e);
                    exitCode = -4;
                }
                LOGGER.error("Failed to delete " + modelFileName);
            }
        }
        return new ParsingResult(request.getModule(), request.getSourceFile(), exitCode, request.getErrorFileName(), model);
    }

    private boolean startParserProcess(int id, int stackSize) {
        assert (stackSize >= 1 && stackSize <= 128);
        String logbackDirectory = "-Dlogback.directory=" + this.m_diagnosticDir.getNormalizedAbsolutePath();
        String logbackConfigurationFile = "-Dlogback.configurationFile=" + LOGBACK_PARSER_CONFIGURATION_FILE;
        String javaLibraryPath = "-Djava.library.path=" + JAVA_LIBRARY_PATH;
        String dpId = "-Dpd.id=" + id;
        String parameterId = Integer.toString(id);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (stackSize == 1) {
            pb.command(JAVA_EXECUTABLE, logbackDirectory, logbackConfigurationFile, dpId, javaLibraryPath, CLASSPATH_OPTION, PARSER_CLASSPATH, PARSER_MAIN_CLASS, parameterId, "-r");
        } else {
            pb.command(JAVA_EXECUTABLE, String.format("-Xss%dM", stackSize), logbackDirectory, logbackConfigurationFile, dpId, javaLibraryPath, CLASSPATH_OPTION, PARSER_CLASSPATH, PARSER_MAIN_CLASS, parameterId, "-r");
        }
        pb.redirectError((File)new TFile((File)this.m_diagnosticDir, "pd" + id + "_error.txt"));
        try {
            this.m_process = pb.start();
        }
        catch (IOException e) {
            return false;
        }
        if (!this.m_process.isAlive()) {
            LOGGER.error("failed to start parser daemon with the following command line: " + pb.command().toString());
            return false;
        }
        this.m_commandStream = new PrintStream(this.m_process.getOutputStream());
        this.m_processOutput = this.m_process.getInputStream();
        this.m_daemonIsRunning = true;
        return true;
    }

    private String readLineFromProcess() throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = this.m_processOutput.read()) > 0 && c != 10) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    private void sendCommand(List<String> command) throws IOException {
        assert (command != null && !command.isEmpty()) : "Parameter 'command' of method 'sendCommand' must not be empty";
        command.forEach(c -> this.m_commandStream.println((String)c));
        this.m_commandStream.flush();
        if (this.m_commandStream.checkError()) {
            throw new IOException(String.format("Daemon %d: failed to send command: %s", this.m_id, command.get(0)));
        }
    }

    private boolean initParserProcess(InstCompilerDefinition cdef, boolean restart) throws IOException, DaemonException {
        assert (cdef != null) : "Parameter 'cdef' of method 'initParserProcess' must not be null";
        ArrayList<String> command = new ArrayList<String>();
        command.add(INIT);
        command.add(this.m_diagnosticMode.name());
        command.add(this.m_projectDataDir.getNormalizedAbsolutePath());
        command.add(this.m_diagnosticDir.getNormalizedAbsolutePath());
        command.add(Integer.toString(cdef.getLongSize()));
        command.add(Integer.toString(cdef.getPointerSize()));
        command.add(Integer.toString(cdef.getWideCharSize()));
        command.add(restart ? "1" : "0");
        try {
            this.sendCommand(command);
        }
        catch (IOException e) {
            return false;
        }
        String result = this.readLineFromProcess().trim();
        if (!result.equals(OK)) {
            throw new DaemonException(String.format("Daemon %d: unexpected termination", this.m_id), DaemonException.ErrorCode.UNEXPECTED_TERMINATION, this.m_id);
        }
        return true;
    }

    private int endParserProcess() throws IOException, InterruptedException, DaemonException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(QUIT);
        this.sendCommand(command);
        String result = this.readLineFromProcess().trim();
        if (!result.equals(OK)) {
            throw new DaemonException(String.format("Daemon %d: unexpected termination", this.m_id), DaemonException.ErrorCode.UNEXPECTED_TERMINATION, this.m_id);
        }
        return this.m_process.waitFor();
    }
}

