/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;

public final class CppHeaderPathRetriever
extends AssignableAttributeRetriever<CppComponent> {
    public Language getLanguage() {
        return CPlusPlusLanguage.INSTANCE;
    }

    public String getName() {
        return "CppHeaderPath";
    }

    public String getShortName() {
        return "HeaderPath";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the identifying path of the main header of a component.\n\nOnly works for physical models.\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    public boolean availableFor(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return architectureModel == IArchitecturalModelProvider.ArchitectureModel.PHYSICAL;
    }

    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForComponent' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForComponent' must not be null";
        if (assignable.isExternal()) {
            return null;
        }
        assert (assignable instanceof CppComponent) : "Unexpected class in method 'computeAttributeForComponent': " + String.valueOf(assignable);
        CppComponent component = (CppComponent)assignable;
        String datum = this.getDatum((NamedElement)component);
        if (datum == null) {
            String name = component.getShortName();
            CppHeaderFile mainHeader = null;
            for (CppHeaderFile header : component.getChildren(CppHeaderFile.class)) {
                if (workerContext.hasBeenCanceled()) {
                    return null;
                }
                String headerName = FileUtility.removeExtension((String)header.getShortName());
                if (!headerName.equals(name)) continue;
                mainHeader = header;
                break;
            }
            datum = mainHeader == null ? "" : mainHeader.getIdentifyingPath();
            this.setDatum((NamedElement)component, datum);
        }
        return this.createAttribute(datum);
    }
}

