/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.architecture.CppTypeBasedAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class CppExtendsClassRetriever
extends CppTypeBasedAttributeRetriever {
    public String getName() {
        return "CppExtendsClass";
    }

    public String getShortName() {
        return "ExtendsClass";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified C++ name (namespace plus class name with \u2018.\u2019 as separator) of any direct or indirect base class of a class.\n\nIn a physical model a C++ component will only be considered if it contains a type that has the same name as the component.\n\nPlease note that \u201c*\u201d will match anything except dots (\u2018.\u2019).\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence";
    }

    public String getMultipleAttributeInfo() {
        return "Extends class";
    }

    private void collectBaseClasses(CppClassStructUnion type, Set<String> collector) {
        assert (type != null) : "Parameter 'type' of method 'collectBaseClasses' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collectBaseClasses' must not be null";
        List dependencies = type.getOutgoingDependencies(new IParserDependencyType[]{CppDependencyType.INHERITS_FROM, CppDependencyType.VIRTUALLY_INHERITS_FROM});
        for (ParserDependency next : dependencies) {
            CppClassStructUnionDefinition cls;
            if (!(next.getTo() instanceof CppClassStructUnionDefinition) || !collector.add((cls = (CppClassStructUnionDefinition)next.getTo()).getFullyQualifiedTypeName())) continue;
            this.collectBaseClasses(cls, collector);
        }
    }

    @Override
    protected Set<String> computeAttributeForType(CppClassStructUnionDefinition type, String[] params) {
        assert (type != null) : "Parameter 'type' of method 'computeAttributeForType' must not be null";
        THashSet baseClasses = new THashSet();
        this.collectBaseClasses(type, (Set<String>)baseClasses);
        return baseClasses.isEmpty() ? Collections.emptySet() : baseClasses;
    }
}

