/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IKeywordProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.ICloneable;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.IRefactorable;
import com.hello2morrow.sonargraph.core.model.element.IRefactoringTarget;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.DeletionVisitor;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.StatusInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusVsProjectImportSourceDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClass;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionNamespace;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppComponent;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppEnumeration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunction;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppMemberFunctionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppNamespaceFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStruct;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppStructDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppTypedef;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppUnionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CppDeletionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Predicate;

final class CPlusPlusRefactoringAdapter
extends LanguageProviderRefactoringAdapter {
    private static final Map<Class<? extends ICppProgrammingElement>, Class<? extends ICppProgrammingElement>> DEF_TO_DECL = new HashMap<Class<? extends ICppProgrammingElement>, Class<? extends ICppProgrammingElement>>(5);
    private final IKeywordProvider m_keywordProvider;
    private final IRefactoringDescriptorProvider m_descriptorProvider;

    static {
        DEF_TO_DECL.put(CppClass.class, CppClassDeclaration.class);
        DEF_TO_DECL.put(CppStruct.class, CppStructDeclaration.class);
        DEF_TO_DECL.put(CppUnion.class, CppUnionDeclaration.class);
        DEF_TO_DECL.put(CppFunction.class, CppFunctionDeclaration.class);
        DEF_TO_DECL.put(CppMemberFunction.class, CppMemberFunctionDeclaration.class);
        DEF_TO_DECL.put(CppVariable.class, CppVariable.class);
    }

    CPlusPlusRefactoringAdapter(IKeywordProvider keywordProvider, IRefactoringDescriptorProvider descriptorProvider) {
        assert (keywordProvider != null) : "Parameter 'keywordProvider' of method 'CPlusPlusRefactoringAdapter' must not be null";
        assert (descriptorProvider != null) : "Parameter 'descriptorProvider' of method 'CPlusPlusRefactoringAdapter' must not be null";
        this.m_keywordProvider = keywordProvider;
        this.m_descriptorProvider = descriptorProvider;
    }

    protected Language getLanguage() {
        return CPlusPlusLanguage.INSTANCE;
    }

    protected Class<? extends Module> getModuleClass() {
        return CPlusPlusModule.class;
    }

    protected Map<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> getRefactorables() {
        LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>> refactorables = new LinkedHashMap<Class<? extends IRefactorable>, Set<Class<? extends IRefactoringTarget>>>(9);
        refactorables.put(CppDirectoryFragment.class, new LinkedHashSet<Class>(Arrays.asList(CppDirectoryFragment.class, CppRootDirectoryPath.class, CPlusPlusVsProjectImportSourceDirectoryPath.class)));
        refactorables.put(CppComponent.class, new LinkedHashSet<Class>(Arrays.asList(CppDirectoryFragment.class, CppRootDirectoryPath.class, CPlusPlusVsProjectImportSourceDirectoryPath.class)));
        refactorables.put(CppClass.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppStruct.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppUnion.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppFunction.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppMemberFunction.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppVariable.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppEnumeration.class, Collections.singleton(CppNamespaceFragment.class));
        refactorables.put(CppTypedef.class, Collections.singleton(CppNamespaceFragment.class));
        return refactorables;
    }

    protected Predicate<IRefactorable> getRefactorableInclusionPredicate() {
        return r -> !(r instanceof CppVariable) || ((CppVariable)r).isDefinition();
    }

    protected NamespaceFragment createNamespaceFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createNamespaceFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createNamespaceFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createNamespaceFragment' must not be empty";
        return new CppNamespaceFragment(msp, parent, shortName);
    }

    protected DirectoryFragment createDirectoryFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        assert (msp != null) : "Parameter 'msp' of method 'createDirectoryFragment' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'createDirectoryFragment' must not be null";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'createDirectoryFragment' must not be empty";
        return new CppDirectoryFragment(msp, parent, shortName);
    }

    public DeletionVisitor createDeletionVisitor(RefactoringStateHandler refactoringStateHandler, boolean includeRecursiveElementChildren) {
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'createDeletionVisitor' must not be null";
        return new CppDeletionVisitor(refactoringStateHandler, includeRecursiveElementChildren);
    }

    private boolean isValidInIdentifier(char ch, boolean firstChar) {
        if (firstChar) {
            return Character.isLetter(ch) || ch == '_';
        }
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == '_';
    }

    private boolean isValidIdentifier(String identifier, Set<String> keywords) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidIdentifier' must not be empty";
        assert (keywords != null) : "Parameter 'keywords' of method 'isValidIdentifier' must not be null";
        if (keywords.contains(identifier)) {
            return false;
        }
        int i = 0;
        while (i < identifier.length()) {
            if (!this.isValidInIdentifier(identifier.charAt(i), i == 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getKind(ICppProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getKind' must not be null";
        if (element instanceof CppClassStructUnion) {
            return "Type";
        }
        if (element instanceof CppEnumeration) {
            return "Enumeration";
        }
        if (element instanceof CppRoutine) {
            return "Routine";
        }
        if (element instanceof CppTypedef) {
            return "Typedef";
        }
        if (element instanceof CppVariable) {
            return "Variable";
        }
        assert (false) : "Unhandled: " + element.getClass().getSimpleName();
        return "";
    }

    protected ITextValidator getRenameRefactoringValidator(final NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getRenameRefactoringValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null || newInputString.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (result.inputModified()) {
                    if (namedElement instanceof ICppProgrammingElement) {
                        if (!CPlusPlusRefactoringAdapter.this.isValidIdentifier(newInputString, CPlusPlusRefactoringAdapter.this.m_keywordProvider.getKeywords((IFileType)CPlusPlusFileType.CPP_SOURCE))) {
                            result.addError(CPlusPlusRefactoringAdapter.this.getKind((ICppProgrammingElement)namedElement) + " '" + newInputString + "' not valid");
                            return result;
                        }
                    } else if (namedElement instanceof CppComponent) {
                        if (!FileUtility.isValidName((String)newInputString)) {
                            result.addError("Compilation unit name '" + newInputString + "' not valid");
                            return result;
                        }
                        if (newInputString.indexOf(46) != -1) {
                            result.addError("Compilation unit name '" + newInputString + "' not valid - must not contain '.'");
                            return result;
                        }
                    } else if (namedElement instanceof CppDirectoryFragment && !FileUtility.isValidName((String)newInputString)) {
                        result.addError("Directory fragment name '" + newInputString + "' not valid");
                        return result;
                    }
                }
                return result;
            }
        };
    }

    private boolean isValidNamespaceName(String identifier, Set<String> keywords) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidNamespaceName' must not be empty";
        if (identifier.startsWith(":") || identifier.endsWith(":")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(identifier.replace("::", "."), ".");
        while (tokenizer.hasMoreTokens()) {
            String nextPartName = tokenizer.nextToken();
            if (this.isValidIdentifier(nextPartName, keywords)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDirectoryName(String identifier) {
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'isValidDirectoryName' must not be empty";
        StringTokenizer tokenizer = new StringTokenizer(identifier, "/");
        while (tokenizer.hasMoreTokens()) {
            if (FileUtility.isValidName((String)tokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    protected ITextValidator getMoveToParentNameRefactoringValidator(List<NamedElement> namedElements, final MoveRenameRefactoringElementType elementType) {
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'getMoveToParentNameRefactoringValidator' must not be empty";
        assert (elementType != null) : "Parameter 'elementType' of method 'getMoveToParentNameRefactoringValidator' must not be null";
        return new ITextValidator(){

            public ValidationResult isValid(String currentInput, String newInput) {
                String newInputString;
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                String string = newInputString = newInput != null ? newInput.trim() : null;
                if (newInputString == null) {
                    result.addError("Must not be 'null'");
                } else if (!newInputString.isEmpty()) {
                    switch (elementType) {
                        case COMPONENT: 
                        case DIRECTORY: {
                            if (CPlusPlusRefactoringAdapter.this.isValidDirectoryName(newInputString)) break;
                            result.addError("Directory name '" + newInputString + "' not valid");
                            break;
                        }
                        case ELEMENT: 
                        case NAMESPACE: {
                            if (CPlusPlusRefactoringAdapter.this.isValidNamespaceName(newInputString, CPlusPlusRefactoringAdapter.this.m_keywordProvider.getKeywords((IFileType)CPlusPlusFileType.CPP_SOURCE))) break;
                            result.addError("Namespace name '" + newInputString + "' not valid");
                            break;
                        }
                        default: {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)("Unhandled: " + String.valueOf(elementType)));
                            }
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    private List<CppSource> refactorSourceFiles(IModelServiceProvider msp, CppComponent component, RefactoringType refactoringType, RefactoringStateHandler refactoringStateHandler) {
        assert (msp != null) : "Parameter 'msp' of method 'refactorSourceFiles' must not be null";
        assert (component != null) : "Parameter 'component' of method 'refactorSourceFiles' must not be null";
        assert (refactoringType != null) : "Parameter 'refactoringType' of method 'refactorSourceFiles' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'refactorSourceFiles' must not be null";
        AssignableToArtifactRefactoringDescriptor descriptor = this.m_descriptorProvider.getPhysicalAssignableToArtifactRefactoringDescriptor(msp);
        assert (descriptor != null) : "'descriptor' of method 'refactorSourceFiles' must not be null";
        List filePathToPhysicalElementPairs = descriptor.getFilePathToPhysicalElementPairs((IAssignableToArtifact)component, refactoringType);
        ArrayList<CppSource> sources = new ArrayList<CppSource>(filePathToPhysicalElementPairs.size());
        for (StrictPair nextPair : filePathToPhysicalElementPairs) {
            FilePath nextFilePath = (FilePath)nextPair.getFirst();
            assert (nextFilePath instanceof CppSource) : "Unexpected class in method 'refactorSourceFiles': " + String.valueOf(nextFilePath);
            CppSource nextSource = (CppSource)nextFilePath;
            sources.add((CppSource)refactoringStateHandler.getModifiableVersionOf((ICloneable)nextSource));
        }
        return sources;
    }

    private CppComponent renameComponent(IModelServiceProvider msp, CppComponent component, String newName, RefactoringStateHandler refactoringStateHandler, Set<NamedElement> additional) {
        assert (msp != null) : "Parameter 'msp' of method 'renameComponent' must not be null";
        assert (component != null) : "Parameter 'component' of method 'renameComponent' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameComponent' must not be empty";
        assert (additional != null) : "Parameter 'additional' of method 'renameComponent' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameComponent' must not be null";
        CppComponent modifiableVersionOfComponentToBeRenamed = (CppComponent)refactoringStateHandler.getModifiableVersionOf((ICloneable)component);
        modifiableVersionOfComponentToBeRenamed.setShortName(newName);
        for (CppSource nextSource : this.refactorSourceFiles(msp, component, RefactoringType.RENAME, refactoringStateHandler)) {
            String nextPath = nextSource.getPath();
            int pathSepPos = nextPath.lastIndexOf(47);
            assert (pathSepPos != -1) : "Path separator not found: " + nextPath;
            int extensionPos = nextPath.lastIndexOf(46);
            assert (extensionPos > pathSepPos) : "Invalid path: " + nextPath;
            nextSource.setPath(nextPath.substring(0, pathSepPos + 1) + newName + nextPath.substring(extensionPos));
            additional.add((NamedElement)nextSource);
        }
        return modifiableVersionOfComponentToBeRenamed;
    }

    private void moveComponent(IModelServiceProvider msp, CppComponent component, NamedElement target, RefactoringStateHandler refactoringStateHandler, Set<NamedElement> additional) {
        assert (msp != null) : "Parameter 'msp' of method 'moveComponent' must not be null";
        assert (component != null) : "Parameter 'component' of method 'moveComponent' must not be null";
        assert (target != null) : "Parameter 'target' of method 'moveComponent' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveComponent' must not be null";
        assert (additional != null) : "Parameter 'additional' of method 'moveComponent' must not be null";
        ICloneable nextCloneable = (ICloneable)component.getParent(ICloneable.class, new Class[0]);
        assert (nextCloneable != null) : "'nextCloneable' of method 'moveComponent' must not be null";
        refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)component, (ICloneable)target);
        additional.addAll(this.refactorSourceFiles(msp, component, RefactoringType.MOVE, refactoringStateHandler));
    }

    private CppDirectoryFragment renameDirectory(CppDirectoryFragment directoryFragment, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (directoryFragment != null) : "Parameter 'directoryFragment' of method 'renameDirectory' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameDirectory' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameDirectory' must not be null";
        CppDirectoryFragment modifiableVersionOfDirectoryFragmentToBeRenamed = (CppDirectoryFragment)refactoringStateHandler.getModifiableVersionOf((ICloneable)directoryFragment);
        modifiableVersionOfDirectoryFragmentToBeRenamed.setShortName(newName);
        return modifiableVersionOfDirectoryFragmentToBeRenamed;
    }

    private IRefactorable renameElement(IRefactorable element, String newName, RefactoringStateHandler refactoringStateHandler) {
        assert (element != null) : "Parameter 'element' of method 'renameElement' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'renameElement' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'renameElement' must not be null";
        IRefactorable toBeRenamed = (IRefactorable)refactoringStateHandler.getModifiableVersionOf((ICloneable)element);
        assert (toBeRenamed != null && toBeRenamed instanceof ProgrammingElement) : "Unexpected class in method 'renameElement': " + String.valueOf(toBeRenamed);
        ((ProgrammingElement)toBeRenamed).setShortName(newName);
        return toBeRenamed;
    }

    private void moveElement(IRefactorable element, ICloneable target, RefactoringStateHandler refactoringStateHandler) {
        assert (element != null) : "Parameter 'type' of method 'moveElement' must not be null";
        assert (target != null) : "Parameter 'target' of method 'moveElement' must not be null";
        assert (element != target) : "Same instances";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveElement' must not be null";
        ICloneable nextCloneable = (ICloneable)element.getNamedElement().getParent(ICloneable.class, ParentMode.ONLY_DIRECT_PARENT);
        assert (nextCloneable != null) : "'nextCloneable' of method 'moveElement' must not be null";
        refactoringStateHandler.moveToNewParent(nextCloneable, element, target);
    }

    protected Set<NamedElement> rename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'rename' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'rename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'rename' must not be empty";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'rename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'rename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'rename' must not be null";
        HashSet<NamedElement> additional = new HashSet<NamedElement>();
        this.checkCollisions(namedElements, statusInfo, null, newName, elementType, null);
        if (statusInfo.getStatus() == StatusInfo.Status.NONE || statusInfo.getStatus().isApplicable()) {
            switch (elementType) {
                case ELEMENT: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof ICppProgrammingElement) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        IRefactorable renamedDefinition = this.renameElement((ICppProgrammingElement)next, newName, refactoringStateHandler);
                        for (ICppProgrammingElement nextDecl : this.getCorrespondingDeclarations((ICppProgrammingElement)next)) {
                            this.renameElement(nextDecl, newName, refactoringStateHandler);
                        }
                        Set<CppClassStructUnionNamespace> correspondingCppClassStructUnionNamespaces = this.getCorrespondingCppClassStructUnionNamespaces((ICppProgrammingElement)next);
                        if (correspondingCppClassStructUnionNamespaces.isEmpty()) continue;
                        assert (renamedDefinition instanceof CppClassStructUnion) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        for (CppClassStructUnionNamespace nextNamespace : correspondingCppClassStructUnionNamespaces) {
                            IRefactorable nextRenamed = this.renameElement(nextNamespace, newName, refactoringStateHandler);
                            assert (nextRenamed != null && nextRenamed instanceof CppClassStructUnionNamespace) : "Unexpected class in method 'rename': " + String.valueOf(nextRenamed);
                            ((CppClassStructUnionNamespace)nextRenamed).setType((CppClassStructUnion)renamedDefinition);
                        }
                    }
                    break;
                }
                case COMPONENT: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof CppComponent) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        this.renameComponent(msp, (CppComponent)next, newName, refactoringStateHandler, additional);
                    }
                    break;
                }
                case DIRECTORY: {
                    for (NamedElement next : namedElements) {
                        assert (next instanceof CppDirectoryFragment) : "Unexpected class in method 'rename': " + String.valueOf(next);
                        CppDirectoryFragment nextDirectory = (CppDirectoryFragment)next;
                        NamedElement parentOfNextDirectory = nextDirectory.getParent();
                        CppDirectoryFragment existing = (CppDirectoryFragment)this.findByRelevantRenameName(newName, parentOfNextDirectory, CppDirectoryFragment.class);
                        if (existing != null) {
                            this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CppDirectoryFragment.class);
                            continue;
                        }
                        this.renameDirectory((CppDirectoryFragment)next, newName, refactoringStateHandler);
                    }
                    break;
                }
                default: {
                    assert (false) : "Unhandled 'elementType' in 'rename':" + String.valueOf(elementType);
                    break;
                }
            }
        }
        return Collections.unmodifiableSet(additional);
    }

    protected Set<NamedElement> moveRename(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, String newName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'moveRename' must not be null";
        assert (elementType != null) : "Parameter 'elementType' of method 'moveRename' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'moveRename' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'moveRename' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'moveRename' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'moveRename' must not be empty";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'moveRename' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'moveRename' must not be null";
        HashSet<NamedElement> additional = new HashSet<NamedElement>();
        switch (elementType) {
            case ELEMENT: {
                for (NamedElement next : namedElements) {
                    assert (next instanceof ICppProgrammingElement) : "Unexpected class in method 'move': " + String.valueOf(next);
                    ICppProgrammingElement nextElement = (ICppProgrammingElement)next;
                    CppSource nextSource = (CppSource)((Object)nextElement.getProgrammingElement().getParent(CppSource.class, new Class[0]));
                    assert (nextSource != null) : "'nextSource' of method 'moveRename' must not be null";
                    NamedElement nextTarget = this.getOrCreateTypeParent(msp, (ICloneable)nextSource, moveToParentName, refactoringStateHandler, null);
                    if (!this.checkCollisions(Collections.singletonList(nextElement.getProgrammingElement()), statusInfo, (NamedElement)nextSource, newName, elementType, nextTarget)) continue;
                    IRefactorable nextRenamed = this.renameElement(nextElement, newName, refactoringStateHandler);
                    this.moveElement(nextRenamed, (ICloneable)nextTarget, refactoringStateHandler);
                }
                break;
            }
            case COMPONENT: {
                NamedElement targetDirectory = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetDirectory, newName, elementType, targetDirectory);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CppComponent) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CppComponent nextComponent = (CppComponent)next;
                    nextComponent = this.renameComponent(msp, nextComponent, newName, refactoringStateHandler, additional);
                    this.moveComponent(msp, nextComponent, targetDirectory, refactoringStateHandler, additional);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, newName, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CppDirectoryFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CppDirectoryFragment nextDirectory = (CppDirectoryFragment)next;
                    CppDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (CppDirectoryFragment)this.findByRelevantRenameName(newName, target.getNamedElement(), CppDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CppDirectoryFragment.class);
                        continue;
                    }
                    boolean nextCreateNewDirectory = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName);
                    nextDirectory = this.renameDirectory(nextDirectory, newName, refactoringStateHandler);
                    NamedElement nextNewParent = nextCreateNewDirectory ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCloneable = (ICloneable)nextDirectory.getParent(ICloneable.class, new Class[0]);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'moveRename':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.unmodifiableSet(additional);
    }

    private Set<ICppProgrammingElement> getCorrespondingDeclarations(ICppProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getCorrespondingDeclarations' must not be null";
        Class<? extends ICppProgrammingElement> nextDeclClass = DEF_TO_DECL.get(element.getClass());
        if (nextDeclClass == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<ICppProgrammingElement> relevant = new LinkedHashSet<ICppProgrammingElement>();
        ProgrammingElement programmingElement = element.getProgrammingElement();
        Iterator dependencyIterator = programmingElement.getDependencyIterator();
        while (dependencyIterator.hasNext()) {
            ProgrammingElement nextFrom;
            ParserDependency nextDependency = (ParserDependency)dependencyIterator.next();
            if (nextDependency.getDependencyType() != CppDependencyType.DECLARES && nextDependency.getDependencyType() != CppDependencyType.BY_NAME || !(nextFrom = nextDependency.getFrom()).getClass().equals(nextDeclClass)) continue;
            assert (!(nextFrom instanceof CppVariable) || !((CppVariable)nextFrom).isDefinition()) : "No variable definition expected";
            relevant.add((ICppProgrammingElement)nextFrom);
        }
        return relevant;
    }

    private Set<CppClassStructUnionNamespace> getCorrespondingCppClassStructUnionNamespaces(ICppProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'getRelevant' must not be null";
        Class<? extends ICppProgrammingElement> nextDeclClass = DEF_TO_DECL.get(element.getClass());
        if (nextDeclClass == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<CppClassStructUnionNamespace> relevant = new LinkedHashSet<CppClassStructUnionNamespace>();
        for (CppMemberFunctionDeclaration next : element.getProgrammingElement().getChildrenRecursively(CppMemberFunctionDeclaration.class, new Class[0])) {
            Iterator nextDependencyIterator = next.getDependencyIterator();
            while (nextDependencyIterator.hasNext()) {
                NamedElement nextParent;
                ProgrammingElement nextTo;
                ParserDependency nextParserDependency = (ParserDependency)nextDependencyIterator.next();
                if (nextParserDependency.getDependencyType() != CppDependencyType.DECLARES || !((nextTo = nextParserDependency.getTo()) instanceof CppMemberFunction) || !((nextParent = nextTo.getParent()) instanceof CppClassStructUnionNamespace)) continue;
                relevant.add((CppClassStructUnionNamespace)nextParent);
            }
        }
        return relevant;
    }

    protected Set<NamedElement> move(IModelServiceProvider msp, MoveRenameRefactoringElementType elementType, List<NamedElement> namedElements, RootDirectoryPath targetRootDirectory, String moveToParentName, RefactoringStateHandler refactoringStateHandler, StatusInfo statusInfo) {
        assert (msp != null) : "Parameter 'msp' of method 'move' must not be null";
        assert (elementType != null) : "Parameter 'refactoringElementType' of method 'move' must not be null";
        assert (namedElements != null && !namedElements.isEmpty()) : "Parameter 'namedElements' of method 'move' must not be empty";
        assert (targetRootDirectory != null) : "Parameter 'targetRootDirectory' of method 'move' must not be null";
        assert (moveToParentName != null) : "Parameter 'moveToParentName' of method 'move' must not be null";
        assert (refactoringStateHandler != null) : "Parameter 'refactoringStateHandler' of method 'move' must not be null";
        assert (statusInfo != null) : "Parameter 'statusInfo' of method 'move' must not be null";
        HashSet<NamedElement> additional = new HashSet<NamedElement>();
        switch (elementType) {
            case ELEMENT: {
                for (NamedElement next : namedElements) {
                    assert (next instanceof ICppProgrammingElement) : "Unexpected class in method 'move': " + String.valueOf(next);
                    ICppProgrammingElement nextElement = (ICppProgrammingElement)next;
                    CppSource nextSource = (CppSource)((Object)nextElement.getProgrammingElement().getParent(CppSource.class, new Class[0]));
                    assert (nextSource != null) : "'nextSource' of method 'move' must not be null";
                    NamedElement nextTarget = this.getOrCreateTypeParent(msp, (ICloneable)nextSource, moveToParentName, refactoringStateHandler, null);
                    if (!this.checkCollisions(Collections.singletonList(nextElement.getProgrammingElement()), statusInfo, (NamedElement)nextSource, null, elementType, nextTarget)) continue;
                    this.moveElement(nextElement, (ICloneable)nextTarget, refactoringStateHandler);
                }
                break;
            }
            case COMPONENT: {
                NamedElement targetDirectory = this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                this.checkCollisions(namedElements, statusInfo, targetDirectory, null, elementType, targetDirectory);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                assert (targetDirectory != null);
                for (NamedElement next : namedElements) {
                    assert (next instanceof CppComponent) : "Unexpected class in method 'move': " + String.valueOf(next);
                    this.moveComponent(msp, (CppComponent)next, targetDirectory, refactoringStateHandler, additional);
                }
                break;
            }
            case DIRECTORY: {
                IRefactoringTarget target = this.getMoveToParent(targetRootDirectory, moveToParentName);
                this.checkCollisions(namedElements, statusInfo, target != null ? target.getNamedElement() : null, null, elementType, target != null ? target.getNamedElement() : null);
                if (statusInfo.getStatus() != StatusInfo.Status.NONE && !statusInfo.getStatus().isApplicable()) break;
                for (NamedElement next : namedElements) {
                    assert (next instanceof CppDirectoryFragment) : "Unexpected class in method 'move': " + String.valueOf(next);
                    CppDirectoryFragment nextDirectory = (CppDirectoryFragment)next;
                    CppDirectoryFragment existing = null;
                    if (target != null) {
                        existing = (CppDirectoryFragment)this.findByRelevantRenameName(this.getRelevantRenameName((NamedElement)nextDirectory), target.getNamedElement(), CppDirectoryFragment.class);
                    }
                    if (existing != null) {
                        this.moveChildrenTo((PhysicalRecursiveElement)nextDirectory, (ICloneable)existing, refactoringStateHandler, CppDirectoryFragment.class);
                        continue;
                    }
                    NamedElement nextNewParent = this.createNewPhysicalRecursiveTarget((PhysicalRecursiveElement)nextDirectory, moveToParentName) ? this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, (PhysicalRecursiveElement)nextDirectory) : this.getOrCreateComponentParent(msp, targetRootDirectory, moveToParentName, refactoringStateHandler, null);
                    ICloneable nextCloneable = (ICloneable)nextDirectory.getParent(ICloneable.class, new Class[0]);
                    assert (nextCloneable != null) : "'nextCloneable' of method 'move' must not be null";
                    refactoringStateHandler.moveToNewParent(nextCloneable, (IRefactorable)nextDirectory, (ICloneable)nextNewParent);
                }
                break;
            }
            default: {
                assert (false) : "Unhandled 'elementType' in 'move':" + String.valueOf(elementType);
                break;
            }
        }
        return Collections.unmodifiableSet(additional);
    }

    static interface IRefactoringDescriptorProvider {
        public AssignableToArtifactRefactoringDescriptor getPhysicalAssignableToArtifactRefactoringDescriptor(IModelServiceProvider var1);
    }
}

