/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ConfigurationLevel;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingRequest;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParsingService;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.MissingSysIncludeForModuleIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusSoftwareSystemSettingsProvider;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CPlusPlusFileConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusFileConsumer.class);
    private final ParsingService m_parsingService;
    private String m_currentModuleName;
    private ModuleCompilerOptions m_currentModuleOptions;
    private ICPlusPlusSoftwareSystemSettingsProvider m_settingsProvider;
    private Set<TFile> m_systemIncludes;
    private TFile m_preprocessorDir;
    private final boolean m_isPreprocessing;

    CPlusPlusFileConsumer(ParsingService ps, boolean isPreprocessingOnly) {
        assert (ps != null) : "Parameter 'ps' of method 'CPlusPlusFileConsumer' must not be null";
        this.m_isPreprocessing = isPreprocessingOnly;
        this.m_parsingService = ps;
    }

    void aboutToParse(SoftwareSystem system) {
        assert (system != null) : "'system' must not be null";
        this.m_settingsProvider = (ICPlusPlusSoftwareSystemSettingsProvider)system.getExtension(ICPlusPlusSoftwareSystemSettingsProvider.class);
        OperationResultWithOutcome<TFile> outputDirResult = this.m_settingsProvider.initPreprocessorOutputDirectory();
        this.m_preprocessorDir = (TFile)outputDirResult.getOutcome();
    }

    void addToQueue(CPlusPlusModule module, CppSourceFile sourceFile, OperationResult opResult) throws IOException {
        assert (module != null) : "Parameter 'module' of method 'parse' must not be null: " + sourceFile.getPath();
        assert (sourceFile != null) : "'file' must not be null";
        if (this.m_currentModuleName == null || !this.m_currentModuleName.equals(module.getName())) {
            this.m_currentModuleName = module.getName();
            this.determineCurrentOptions(module);
        }
        if (this.m_currentModuleOptions.hasIssues(new IIssueId[0])) {
            LOGGER.warn("Options for file '" + sourceFile.getName() + "' contain issues.");
        }
        List<String> options = null;
        if (sourceFile.getFileType() == CPlusPlusFileType.CPP_SOURCE) {
            options = this.m_settingsProvider.getCppCompilerOptionsForSource(this.m_currentModuleOptions, sourceFile);
        } else if (sourceFile.getFileType() == CPlusPlusFileType.C_SOURCE) {
            options = this.m_settingsProvider.getCCompilerOptionsForSource(this.m_currentModuleOptions, sourceFile);
        } else {
            String message = "Unsupported file type '" + String.valueOf(sourceFile.getFileType()) + "' of source file '" + sourceFile.getAbsolutePath() + "'";
            LOGGER.warn(message);
            assert (false) : message;
        }
        if (this.m_isPreprocessing) {
            if (this.m_preprocessorDir == null) {
                throw new IOException("Missing output directory for preprocessing files. Check sonargraph.log for details.");
            }
            assert (options != null);
            options.add("--preprocess");
            String outputFilePath = new TFile((File)this.m_preprocessorDir, "preprocessed.txt").getNormalizedAbsolutePath();
            options.add("--output=" + outputFilePath);
        }
        ParsingRequest request = new ParsingRequest(module, sourceFile, options);
        this.m_parsingService.addParsingRequest(request);
    }

    private void determineCurrentOptions(CPlusPlusModule module) {
        this.m_currentModuleOptions = this.m_settingsProvider.getActiveCompilerOptions(module);
        Result result = this.m_currentModuleOptions.validate(true, ConfigurationLevel.MODULE);
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        if (result.isFailure()) {
            LOGGER.error("Compiler options for module '" + String.valueOf((Object)module) + "' are invalid: " + result.getErrorMessage());
        }
        this.m_systemIncludes = this.m_settingsProvider.getSystemIncludes(this.m_currentModuleOptions);
        if (this.m_systemIncludes.isEmpty()) {
            moduleSettings.addIssue((Issue)new MissingSysIncludeForModuleIssue((NamedElement)moduleSettings, "No --sys_include option found for module '" + this.m_currentModuleName + "'. Check the configuration on the installation (preferences) and module level."));
            LOGGER.error("No system includes found to be used for parsing files of module '" + module.getName() + "'");
        } else {
            moduleSettings.removeIssues(new IIssueId[]{CPlusPlusIssueId.SYSINCLUDE_INVALID});
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            for (TFile sysInclude : this.m_systemIncludes) {
                builder.append("--sys_include=").append(sysInclude.getNormalizedAbsolutePath()).append(",");
            }
            LOGGER.debug("Setting sys_includes for parser context: " + builder.toString());
        }
    }

    void parsingFinished(SoftwareSystem system) {
        assert (system != null) : "Parameter 'system' of method 'parsingFinished' must not be null";
        if (this.m_preprocessorDir != null && this.m_preprocessorDir.exists()) {
            try {
                FileUtility.deleteRecursively((String)this.m_preprocessorDir.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete preprocessing output directory", (Throwable)e);
            }
        }
    }

    public boolean isPreprocessing() {
        return this.m_isPreprocessing;
    }
}

