/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system;

import com.hello2morrow.sonargraph.core.model.filter.IWorkspaceFilter;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.CPlusPlusDeltaDetector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CPlusPlusFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SourceFileBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusSoftwareSystemSettingsProvider;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class CPlusPlusCCSpyDeltaDetector
extends CPlusPlusDeltaDetector {
    private final DirectoryBean m_ccspyRootBean;
    private final ICPlusPlusSoftwareSystemSettingsProvider m_settingsProvider;
    private final Map<List<String>, List<String>> m_optionsCache = new THashMap();

    CPlusPlusCCSpyDeltaDetector(IWorkerContext workerContext, ILanguageProvider languageProvider, IWorkspaceFilter filter, Module module, DirectoryBean ccspyRootBean, ICPlusPlusSoftwareSystemSettingsProvider settingsProvider, boolean firstModificationOnly) {
        super(workerContext, languageProvider, filter, module, Collections.emptyList(), firstModificationOnly);
        assert (ccspyRootBean != null);
        this.m_ccspyRootBean = ccspyRootBean;
        this.m_settingsProvider = settingsProvider;
    }

    protected void prepareScan(OperationResult result) {
    }

    @Override
    protected void scanRootDirectory(RootDirectoryPath root) {
        if (this.scanningIsDone()) {
            return;
        }
        DirectoryBean rootBean = this.m_ccspyRootBean.findDirectory(dir -> dir.equals((Object)root.getFile()));
        if (rootBean != null) {
            TFile rootDir = root.getFile();
            for (SourceFileBean srcBean : rootBean.getAllSourceFiles()) {
                String fileName = srcBean.getFileName();
                CPlusPlusFileType fileType = fileName.endsWith(".c") ? CPlusPlusFileType.C_SOURCE : CPlusPlusFileType.CPP_SOURCE;
                TFile file = new TFile(fileName);
                List<String> options = srcBean.getOptions();
                List<String> cachedOptions = this.m_optionsCache.put(options, options);
                this.m_settingsProvider.registerOptions(fileName, cachedOptions == null ? options : cachedOptions);
                this.consume(rootDir, file.getNormalizedFile(), fileType);
            }
        }
    }
}

