/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Set;
import java.util.stream.Collectors;

public class InstCompilerDefinitionNameValidator
implements ITextValidator {
    private final Set<String> m_presentDefinitionNames;

    public InstCompilerDefinitionNameValidator(Set<String> presentDefinitionNames) {
        assert (presentDefinitionNames != null) : "Parameter 'presentDefinitionNames' of method 'InstCompilerDefinitionNameValidator' must not be null";
        this.m_presentDefinitionNames = presentDefinitionNames.stream().map(name -> name.toLowerCase()).collect(Collectors.toSet());
    }

    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        String string = newInput = newInput != null ? newInput.trim() : null;
        if (newInput == null || newInput.isEmpty()) {
            result.addError("Must not be empty");
        } else if (result.inputModified() && this.m_presentDefinitionNames.contains(newInput.toLowerCase())) {
            result.addError("Compiler definition with name '" + newInput + "' already exists");
        }
        return result;
    }
}

