/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controllerinterface.system.ICPlusPlusParserConfigurationExtension;
import de.schlichtherle.truezip.file.TFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CPlusPlusParserConfigurationExtension
extends Extension
implements ICPlusPlusParserConfigurationExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusParserConfigurationExtension.class);
    private final TFile m_configFile;
    private int m_numberOfDaemons = 8;
    private int m_daemonStackSize = 1;

    public CPlusPlusParserConfigurationExtension(TFile configDir) {
        assert (configDir != null && configDir.isDirectory()) : "Parameter 'configDir' of method 'CPlusPlusParserConfigurationExtension' must not be null: " + String.valueOf(configDir);
        this.m_configFile = new TFile((File)configDir, "Parser.properties");
        if (this.m_configFile.canRead()) {
            Properties props = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader((File)this.m_configFile));){
                    props.load(reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to read C,C++ parser configuration from " + this.m_configFile.getPath(), (Throwable)e);
            }
            this.m_numberOfDaemons = Integer.valueOf(props.getProperty(ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS.name()));
            this.m_daemonStackSize = Integer.valueOf(props.getProperty(ConfigurationEntryDescriptor.DAEMON_STACK_SIZE.name()));
        }
    }

    @Override
    public void configureParser(OperationResult result, int numberOfDaemons, int stackSize, boolean persistState) {
        if (numberOfDaemons <= 0) {
            numberOfDaemons = ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS.getDefaultValue();
        }
        if (stackSize <= 0) {
            stackSize = ConfigurationEntryDescriptor.DAEMON_STACK_SIZE.getDefaultValue();
        }
        numberOfDaemons = Math.min(numberOfDaemons, ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS.getMaxValue());
        numberOfDaemons = Math.max(numberOfDaemons, ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS.getMinValue());
        stackSize = Math.min(stackSize, ConfigurationEntryDescriptor.DAEMON_STACK_SIZE.getMaxValue());
        stackSize = Math.max(stackSize, ConfigurationEntryDescriptor.DAEMON_STACK_SIZE.getMinValue());
        this.m_numberOfDaemons = numberOfDaemons;
        this.m_daemonStackSize = stackSize;
        if (persistState) {
            assert (result != null) : "Parameter 'result' of method 'configureParser' must not be null";
            Properties props = new Properties();
            props.setProperty(ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS.name(), String.valueOf(this.m_numberOfDaemons));
            props.setProperty(ConfigurationEntryDescriptor.DAEMON_STACK_SIZE.name(), String.valueOf(this.m_daemonStackSize));
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter((File)this.m_configFile));){
                    props.store(writer, "C,C++ Parser Daemon Configuration");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_WRITE_FILE, (Throwable)e);
                LOGGER.error("Failed to write C,C++ parser configuration to " + this.m_configFile.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public int getNumberOfDaemons() {
        return this.m_numberOfDaemons;
    }

    @Override
    public int getDaemonStackSize() {
        return this.m_daemonStackSize;
    }

    @Override
    public AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor getNumberOfDaemonsDescriptor() {
        return ConfigurationEntryDescriptor.NUMBER_OF_DAEMONS;
    }

    @Override
    public AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor getDaemonStackSizeDescriptor() {
        return ConfigurationEntryDescriptor.DAEMON_STACK_SIZE;
    }

    private static final class ConfigurationEntryDescriptor
    extends Enum<ConfigurationEntryDescriptor>
    implements AnalyzerConfiguration.IIntegerConfigurationEntryDescriptor {
        public static final /* enum */ ConfigurationEntryDescriptor NUMBER_OF_DAEMONS = new ConfigurationEntryDescriptor(8, 1, 32, "Number of Daemons:Number of parser daemons used to parse a software system");
        public static final /* enum */ ConfigurationEntryDescriptor DAEMON_STACK_SIZE = new ConfigurationEntryDescriptor(1, 1, 128, "Daemon Stack Size:Size of parser daemon stack in MB");
        private final int m_defaultVal;
        private final int m_minimalVal;
        private final int m_maximalVal;
        private final String m_description;
        private static final /* synthetic */ ConfigurationEntryDescriptor[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ConfigurationEntryDescriptor[]{NUMBER_OF_DAEMONS, DAEMON_STACK_SIZE};
        }

        private ConfigurationEntryDescriptor(int defaultValue, int minimalValue, int maximalValue, String description) {
            assert (description != null && description.length() > 0) : "Parameter 'description' of method 'ConfigurationEntryDescriptor' must not be empty";
            this.m_defaultVal = defaultValue;
            this.m_description = description;
            this.m_minimalVal = minimalValue;
            this.m_maximalVal = maximalValue;
        }

        public Integer getDefaultValue() {
            return this.m_defaultVal;
        }

        public int getMaxValue() {
            return this.m_maximalVal;
        }

        public int getMinValue() {
            return this.m_minimalVal;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return this.m_description;
        }

        public static ConfigurationEntryDescriptor[] values() {
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray = ENUM$VALUES;
            int n = configurationEntryDescriptorArray.length;
            ConfigurationEntryDescriptor[] configurationEntryDescriptorArray2 = new ConfigurationEntryDescriptor[n];
            System.arraycopy(ENUM$VALUES, 0, configurationEntryDescriptorArray2, 0, n);
            return configurationEntryDescriptorArray2;
        }

        public static ConfigurationEntryDescriptor valueOf(String string) {
            return Enum.valueOf(ConfigurationEntryDescriptor.class, string);
        }
    }
}

