/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser;

import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.ICompilationUnitContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.IElementProcessor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.parser.TemplateArgumentCollector;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.parser.EDG;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppElementType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFlags;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionSpec;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppFunctionWithBody;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppProgrammingElementProxy;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.parser.CppStructuredType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.dependency.CppDependencyType;
import java.util.Collection;

final class ClassStructUnionProcessor
extends ElementProcessor {
    private final EDG.TypeClassStructUnion m_edgClassStructUnion;
    private CppStructuredType m_element;
    private CppStructuredType m_definition;
    private boolean m_wasCreated = false;
    private EDG.Position m_position;

    ClassStructUnionProcessor(ICompilationUnitContext context, IElementProcessor parentProcessor, EDG.TypeClassStructUnion csu) {
        super(context, parentProcessor);
        this.m_edgClassStructUnion = csu;
    }

    @Override
    public CppElement getElement() {
        return this.m_element;
    }

    @Override
    public EDG.CObject getEDGObject() {
        return this.m_edgClassStructUnion;
    }

    @Override
    public CppFunctionSpec createRoutineImp(CppElement parent, String name, int lineNumber, boolean isDefined, short noTemplateArgs) {
        CppFunctionSpec result;
        if (isDefined) {
            result = new CppFunctionWithBody(parent, CppElementType.MEMBER_FUNCTION, name, lineNumber);
            result.addFlag(CppFlags.DEFINITION);
        } else {
            result = new CppFunctionSpec(parent, CppElementType.MEMBER_FUNCTION, name, lineNumber);
            result.addFlag(CppFlags.DECLARATION);
        }
        return result;
    }

    private void processField(EDG.Field field) {
        IElementProcessor processor = this.getContext().createFieldProcessor(this, field);
        if (processor.initElement()) {
            this.getContext().addProcessor(processor);
        }
    }

    private CppStructuredType createElement(CppElement parent, String name, int lineNumber, short noTemplateArguments, boolean isDefinition) {
        CppStructuredType result = null;
        switch (this.m_edgClassStructUnion.kind()) {
            case TK_STRUCT: {
                result = new CppStructuredType(parent, CppElementType.STRUCT, name, lineNumber, noTemplateArguments);
                if (isDefinition) {
                    result.addFlag(CppFlags.DEFINITION);
                    break;
                }
                result.addFlag(CppFlags.DECLARATION);
                break;
            }
            case TK_CLASS: {
                result = new CppStructuredType(parent, CppElementType.CLASS, name, lineNumber, noTemplateArguments);
                if (isDefinition) {
                    result.addFlag(CppFlags.DEFINITION);
                } else {
                    result.addFlag(CppFlags.DECLARATION);
                }
                this.markHeaderAsCPlusPlus(result);
                break;
            }
            case TK_UNION: {
                result = new CppStructuredType(parent, CppElementType.UNION, name, lineNumber, noTemplateArguments);
                if (isDefinition) {
                    result.addFlag(CppFlags.DEFINITION);
                    break;
                }
                result.addFlag(CppFlags.DECLARATION);
                break;
            }
            default: {
                assert (false) : "Illegal kind of EDG.TypeClassStructUnion object: " + this.m_edgClassStructUnion.kind().name();
                break;
            }
        }
        assert (result != null);
        parent.addChild(result);
        result.setNamespace(this.getParentProcessor().getNamespace(), this.getParentProcessor().isAnonymousNamespace());
        if (isDefinition) {
            this.m_wasCreated = true;
            this.m_definition = result;
        }
        return result;
    }

    @Override
    public boolean initElement() {
        EDG.SourceCorrespondence sc = this.m_edgClassStructUnion.sourceCorresp();
        EDG.SourcePosition origSp = sc.declPosition();
        this.m_position = origSp.getPosition();
        CppElement myParent = this.getParentProcessor().getParentFor(this.m_position);
        if (myParent != null) {
            EDG.Template template = this.m_edgClassStructUnion.extraInfo().assocTemplate();
            Object name = this.getElementName(sc);
            EDG.Scope scope = this.m_edgClassStructUnion.extraInfo().assocScope();
            short noTemplateArguments = 0;
            if (template != null) {
                if (this.m_edgClassStructUnion.isSpecialized()) {
                    return false;
                }
                TemplateArgumentCollector collector = new TemplateArgumentCollector();
                assert (this.m_edgClassStructUnion.isNonrealClass() || this.m_edgClassStructUnion.isPrototypeInstantiation() || this.m_edgClassStructUnion.isSpecialized() || this.m_edgClassStructUnion.isEmptyClass());
                EDG.TemplateArg arg = this.m_edgClassStructUnion.extraInfo().templateArgList();
                while (arg != null) {
                    arg.accept(collector);
                    noTemplateArguments = (short)(noTemplateArguments + 1);
                    arg = arg.next();
                }
                if (noTemplateArguments > 0) {
                    name = (String)name + collector.getResult();
                }
            }
            if (name == null || ((String)name).length() == 0) {
                name = "[anonymous]" + HashSupport.MD5.getHexString(this.m_position.getFile().fullName() + this.m_position.getLineNumber() + ":" + this.m_position.getColumn() + ":" + myParent.getName());
            }
            if (this.getContext().findStructuredTypeDeclaration(this.m_position) != null) {
                return false;
            }
            this.m_element = this.createElement(myParent, (String)name, this.m_position.getLineNumber(), noTemplateArguments, scope != null);
            if (scope == null) {
                this.getContext().registerStructuredTypeDeclaration(this.m_position, this.m_element);
            }
            if (this.m_element.isDefinition()) {
                this.m_definition = this.m_element;
            }
            this.getContext().mapElementPosition(this.m_element, origSp);
            if (!this.m_edgClassStructUnion.isSpecialized()) {
                this.handleExtraDeclarations(origSp, (String)name, (short)this.m_element.getNumberOfTemplateArguments());
            }
            if (template != null) {
                this.getContext().mapElement(template, this.m_element);
            }
            this.getContext().mapElement(this.m_edgClassStructUnion, this.m_element);
            if (scope != null) {
                EDG.Field field = this.m_edgClassStructUnion.fieldList();
                while (field != null) {
                    this.processField(field);
                    field = field.next();
                }
                this.processScope(scope);
            }
        }
        return true;
    }

    private void handleExtraDeclarations(EDG.SourcePosition origSp, String name, short noTemplateArguments) {
        Collection<EDG.SourcePosition> secondaryPositions = this.getContext().getSecondaryPositions(this.m_edgClassStructUnion, origSp);
        for (EDG.SourcePosition sp : secondaryPositions) {
            CppElement myParent;
            EDG.Position pos = sp.getPosition();
            if (pos.getFile().equals(this.m_position.getFile()) || (myParent = this.getParentProcessor().getParentFor(pos)) == null || this.getContext().findStructuredTypeDeclaration(pos) != null) continue;
            CppStructuredType decl = this.createElement(myParent, name, pos.getLineNumber(), noTemplateArguments, false);
            this.getContext().registerStructuredTypeDeclaration(pos, decl);
            if (this.m_definition != null && !this.m_definition.isExternal()) {
                decl.addDependency(this.m_definition, CppDependencyType.BY_NAME, decl.getLineNo());
            }
            this.getContext().mapElementPosition(decl, sp);
            this.getContext().addSecondaryDeclaration(this.m_element, decl);
        }
    }

    private void handleBaseClasses() {
        EDG.BaseClass baseClass = this.m_edgClassStructUnion.extraInfo().baseClasses();
        while (baseClass != null) {
            if (baseClass.direct() && !this.m_definition.isExternal()) {
                EDG.SourcePosition pos = this.m_edgClassStructUnion.sourceCorresp().declPosition();
                CppStructuredType baseType = (CppStructuredType)this.getContext().mapRawType(this, baseClass.type(), pos, false);
                if (baseType != null) {
                    EDG.Position spos = pos.getPosition();
                    if (baseType.isDefinition()) {
                        if (baseClass.isVirtual()) {
                            this.m_definition.addDependency(baseType, CppDependencyType.VIRTUALLY_INHERITS_FROM, spos.getLineNumber());
                        } else {
                            this.m_definition.addDependency(baseType, CppDependencyType.INHERITS_FROM, spos.getLineNumber());
                        }
                    }
                }
            }
            baseClass = baseClass.next();
        }
    }

    @Override
    public void processElement() {
        if (this.m_wasCreated) {
            this.handleBaseClasses();
        }
    }

    @Override
    public CppElement getParentFor(EDG.Position pos) {
        CppElement myParent = this.getParentProcessor().getParentFor(pos);
        if (myParent == null || this.m_element == null) {
            return null;
        }
        if (this.m_element.getParent() == myParent) {
            return this.m_element;
        }
        CppProgrammingElementProxy result = myParent.getFirstChild(e -> e.getName().equals(this.m_element.getName()), CppProgrammingElementProxy.class);
        if (result == null) {
            result = new CppProgrammingElementProxy(myParent, this.m_element);
            myParent.addChild(result);
        }
        return result;
    }
}

