/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.AbstractImportModulesCommand;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CPlusPlusCommandId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ImportCapturingOrCommandFileModulesCommand
extends AbstractImportModulesCommand<IInteraction> {
    public ImportCapturingOrCommandFileModulesCommand(IInteraction interaction, ISoftwareSystemProvider provider) {
        super((ICommandInteraction)interaction, provider);
    }

    public ICommandId getId() {
        return CPlusPlusCommandId.CREATE_NEW_MODULES;
    }

    protected void internalRun(IWorkerContext workerContext) {
        ImportData importData = new ImportData();
        if (!((IInteraction)this.getInteraction()).collect(importData)) {
            return;
        }
        SoftwareSystem system = this.getController().getSoftwareSystem();
        ICppImportExtension ext = (ICppImportExtension)this.getController().getInstallation().getExtension(ICppImportExtension.class);
        OperationResult result = ext.createModules(workerContext, system, importData.getModuleNames(), importData.getCommandFile(), importData.getCcspyDir(), importData.getRootsMap());
        if (result.isFailure()) {
            ((IInteraction)this.getInteraction()).processModuleCreationResult(result);
        } else {
            OperationResult saveResult = this.getController().saveSoftwareSystem(workerContext);
            ((IInteraction)this.getInteraction()).processSaveResult(saveResult);
        }
    }

    public static interface IInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        public boolean collect(ImportData var1);

        public void processModuleCreationResult(OperationResult var1);
    }

    public static final class ImportData
    implements ICommandInteractionData {
        private final Map<String, List<DirectoryBean>> m_modules = new LinkedHashMap<String, List<DirectoryBean>>();
        private TFile m_commandFile;
        private TFile m_ccspyDir;

        public void addModule(String name, List<DirectoryBean> roots) {
            this.m_modules.put(name, roots);
        }

        Collection<String> getModuleNames() {
            return this.m_modules.keySet();
        }

        Map<String, List<DirectoryBean>> getRootsMap() {
            return this.m_modules;
        }

        TFile getCommandFile() {
            return this.m_commandFile;
        }

        public void setCommandFile(TFile commandFile) {
            this.m_commandFile = commandFile;
        }

        TFile getCcspyDir() {
            return this.m_ccspyDir;
        }

        public void setCcspyDir(TFile ccspyDir) {
            this.m_ccspyDir = ccspyDir;
        }
    }
}

