/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.settings.AbstractSearchPathCommand;
import com.hello2morrow.sonargraph.core.command.system.settings.ISearchPathProviderManager;
import com.hello2morrow.sonargraph.core.command.system.settings.InstSpecDirSearchPathValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathDelta;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathValidator;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings.CPlusPlusInstallationExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;

public final class CppSearchPathSaveCommand
extends AbstractSearchPathCommand<ICppSearchPathSaveInteraction> {
    private final TFile m_currentInstSpecDir;
    private final TFile m_newInstSpecDir;
    private final ICPlusPlusInstallationProvider m_settingsProvider;
    private boolean m_cancelled = true;

    public CppSearchPathSaveCommand(ISoftwareSystemProvider provider, ICppSearchPathSaveInteraction interaction, ISearchPathProviderManager searchPathProvider, ICPlusPlusInstallationProvider settingsProvider, SearchPathDelta delta, TFile currentInstSpecDir, TFile newInstSpecDir) {
        super(provider, (ICommandInteraction)interaction, searchPathProvider, delta, new OperationResult("Saving search path"));
        assert (settingsProvider != null && settingsProvider instanceof CPlusPlusInstallationExtension) : "Parameter 'settingsProvider' of method 'CppSearchPathSaveCommand' must not be null and of type '" + CPlusPlusInstallationExtension.class.getName() + "'";
        assert (currentInstSpecDir != null) : "Parameter 'currentInstSpecDir' of method 'CppSearchPathSaveCommand' must not be null";
        assert (newInstSpecDir != null) : "Parameter 'newInstSpecDir' of method 'CppSearchPathSaveCommand' must not be null";
        this.m_settingsProvider = settingsProvider;
        this.m_currentInstSpecDir = currentInstSpecDir;
        this.m_newInstSpecDir = newInstSpecDir;
    }

    public final ICommandId getId() {
        return CoreCommandId.SEARCH_PATH_SAVE;
    }

    protected void internalRun(IWorkerContext workerContext) {
        OperationResult result = this.getResult();
        InstSpecDirSearchPathValidator instSpecValidator = (InstSpecDirSearchPathValidator)this.getValidator();
        instSpecValidator.setInstSpecDir(this.m_currentInstSpecDir, FileUtility.areEqual((TFile)this.m_currentInstSpecDir, (TFile)this.m_newInstSpecDir));
        instSpecValidator.validate(this.getDelta().getModified(), this.m_newInstSpecDir, result);
        if (!result.isFailure()) {
            SearchPathValidator searchPathValidator = this.m_settingsProvider.getSearchPathValidator();
            OperationResult validateSearchPathResult = new OperationResult("Check if search path modifies current active compiler definition");
            searchPathValidator.validate(this.getDelta().getModified(), this.m_newInstSpecDir, validateSearchPathResult);
            result.addMessagesFrom(validateSearchPathResult);
            if (validateSearchPathResult.containsError()) {
                ((ICppSearchPathSaveInteraction)this.getInteraction()).unableToSaveInformation("Changes cannot be applied", "Changes to search path cannot be applied: \n" + StringUtility.concat((Collection)validateSearchPathResult.getErrorMessages(), (String)"\n"));
                return;
            }
            if (validateSearchPathResult.containsWarning()) {
                StringBuilder question = new StringBuilder("Saving the search path will have the following effect: ").append("\n").append("\n");
                question.append(StringUtility.concat((Collection)validateSearchPathResult.getWarningMessages(), (String)"\n"));
                question.append("\n").append("\n").append("Do you want to continue?");
                if (((ICppSearchPathSaveInteraction)this.getInteraction()).saveWithWarnings(question.toString())) {
                    return;
                }
            }
            this.m_cancelled = false;
            this.getProvider().persistSearchPath(this.getDelta().getModified(), this.m_newInstSpecDir, result);
        }
    }

    public boolean hasBeenCancelled() {
        return this.m_cancelled;
    }

    public static interface ICppSearchPathSaveInteraction
    extends ICommandInteraction {
        public void unableToSaveInformation(String var1, String var2);

        public boolean saveWithWarnings(String var1);
    }
}

