/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.InstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class PythonInstallationSettings
extends InstallationSettings {
    private static final String FILE_NAME = "python.properties";
    private final File m_directory;
    private final Properties m_settings = new Properties();
    private boolean m_needSave = false;

    public PythonInstallationSettings(Installation parent, File directory) {
        super(parent, (Language)PythonLanguage.INSTANCE);
        assert (directory != null) : "Parameter 'directory' of method 'PythonInstallationSettings' must not be null";
        assert (directory.isDirectory());
        this.m_directory = directory;
    }

    public void setProperty(PythonProperty prop, String value) {
        assert (prop != null) : "Parameter 'prop' of method 'setProperty' must not be null";
        if (value != null) {
            this.m_settings.put(prop.name(), value);
        } else {
            this.m_settings.remove(prop.name());
        }
        this.m_needSave = true;
    }

    public String getProperty(PythonProperty prop) {
        return this.m_settings.getProperty(prop.name());
    }

    public void save() throws IOException {
        if (this.m_needSave) {
            Throwable throwable = null;
            Object var2_3 = null;
            try (FileOutputStream out = new FileOutputStream(new File(this.m_directory, FILE_NAME));){
                this.m_settings.store(out, "Global settings for Python language provider");
                this.m_needSave = false;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void load() throws IOException {
        File propertiesFile = new File(this.m_directory, FILE_NAME);
        if (propertiesFile.canRead()) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream in = new FileInputStream(propertiesFile);){
                this.m_settings.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static enum PythonProperty {
        PYTHON_INTERPRETER;

    }
}

