/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.AbstractPythonVisitor;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.PythonParser;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.Scope;
import com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser.ScopeItem;
import com.hello2morrow.sonargraph.languageprovider.python.model.programming.PythonSourceFile;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.RuleNode;

final class NameResolver
extends AbstractPythonVisitor<ScopeItem> {
    private final List<ScopeItem> m_resolvedItems = new ArrayList<ScopeItem>();
    private final List<String> m_unresolvedNames = new ArrayList<String>();
    private boolean m_isCall = false;
    private boolean m_isSlice = false;

    NameResolver(Scope currentScope, PythonSourceFile source, boolean createIssues) {
        super(currentScope, source, createIssues);
    }

    @Override
    public ScopeItem visitPrimary(PythonParser.PrimaryContext ctx) {
        if (ctx.atom() != null) {
            return ctx.atom().accept(this);
        }
        ScopeItem baseItem = ctx.primary().accept(this);
        if (baseItem == null) {
            return null;
        }
        if (ctx.NAME() != null) {
            ScopeItem result;
            String name = ctx.NAME().getText();
            int line = ctx.NAME().getSymbol().getLine();
            Scope scope = null;
            if (baseItem instanceof Scope) {
                scope = (Scope)baseItem;
            } else if (baseItem.getTypeHint() != null && baseItem.getTypeHint().getScope() instanceof Scope) {
                scope = (Scope)baseItem.getTypeHint().getScope();
            }
            ScopeItem scopeItem = result = scope == null ? null : scope.lookupMember(name, this.m_source, line, this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                if (scope != null) {
                    this.unresolvedName(name, line);
                }
            } else {
                this.m_resolvedItems.add(result);
            }
            return result;
        }
        if (ctx.genexp() != null) {
            return null;
        }
        if (ctx.slices() != null) {
            this.m_isSlice = true;
        } else {
            this.m_isCall = true;
        }
        return null;
    }

    @Override
    public ScopeItem visitAtom(PythonParser.AtomContext ctx) {
        ScopeItem result = null;
        if (ctx.NAME() != null) {
            int line;
            String name = ctx.NAME().getText();
            result = this.m_currentScope.lookup(name, this.m_source, line = ctx.NAME().getSymbol().getLine(), this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                this.unresolvedName(name, line);
            } else {
                this.m_resolvedItems.add(result);
            }
        }
        return result;
    }

    @Override
    public ScopeItem visitStar_atom(PythonParser.Star_atomContext ctx) {
        ScopeItem result = null;
        if (ctx.NAME() != null) {
            int line;
            String name = ctx.NAME().getText();
            result = this.m_currentScope.lookup(name, this.m_source, line = ctx.NAME().getSymbol().getLine(), this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                this.unresolvedName(name, line);
            } else {
                this.m_resolvedItems.add(result);
            }
        }
        return result;
    }

    @Override
    public ScopeItem visitSingle_target(PythonParser.Single_targetContext ctx) {
        ScopeItem result = null;
        if (ctx.NAME() != null) {
            int line;
            String name = ctx.NAME().getText();
            result = this.m_currentScope.lookup(name, this.m_source, line = ctx.NAME().getSymbol().getLine(), this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                this.unresolvedName(name, line);
            } else {
                this.m_resolvedItems.add(result);
            }
        } else {
            result = (ScopeItem)this.visitChildren((RuleNode)ctx);
        }
        return result;
    }

    @Override
    public ScopeItem visitSingle_subscript_attribute_target(PythonParser.Single_subscript_attribute_targetContext ctx) {
        ScopeItem baseItem = ctx.t_primary().accept(this);
        if (baseItem == null) {
            return null;
        }
        if (ctx.NAME() != null) {
            ScopeItem result;
            String name = ctx.NAME().getText();
            int line = ctx.NAME().getSymbol().getLine();
            Scope scope = null;
            if (baseItem instanceof Scope) {
                scope = (Scope)baseItem;
            } else if (baseItem.getTypeHint() != null && baseItem.getTypeHint().getScope() instanceof Scope) {
                scope = (Scope)baseItem.getTypeHint().getScope();
            }
            ScopeItem scopeItem = result = scope == null ? null : scope.lookupMember(name, this.m_source, line, this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                if (scope != null) {
                    this.unresolvedName(name, line);
                }
            } else {
                this.m_resolvedItems.add(result);
            }
            return result;
        }
        if (ctx.slices() != null) {
            this.m_isSlice = true;
        }
        return null;
    }

    @Override
    public ScopeItem visitT_primary(PythonParser.T_primaryContext ctx) {
        if (ctx.atom() != null) {
            return ctx.atom().accept(this);
        }
        ScopeItem baseItem = ctx.t_primary().accept(this);
        if (baseItem == null) {
            return null;
        }
        if (ctx.NAME() != null) {
            ScopeItem result;
            String name = ctx.NAME().getText();
            int line = ctx.NAME().getSymbol().getLine();
            Scope scope = null;
            if (baseItem instanceof Scope) {
                scope = (Scope)baseItem;
            } else if (baseItem.getTypeHint() != null && baseItem.getTypeHint().getScope() instanceof Scope) {
                scope = (Scope)baseItem.getTypeHint().getScope();
            }
            ScopeItem scopeItem = result = scope == null ? null : scope.lookupMember(name, this.m_source, line, this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                if (scope != null) {
                    this.unresolvedName(name, line);
                }
            } else {
                this.m_resolvedItems.add(result);
            }
            return result;
        }
        if (ctx.genexp() != null) {
            return null;
        }
        if (ctx.slices() != null) {
            this.m_isSlice = true;
        } else {
            this.m_isCall = true;
        }
        return null;
    }

    @Override
    public ScopeItem visitTarget_with_star_atom(PythonParser.Target_with_star_atomContext ctx) {
        if (ctx.star_atom() != null) {
            return ctx.star_atom().accept(this);
        }
        ScopeItem baseItem = ctx.t_primary().accept(this);
        ScopeItem result = null;
        if (baseItem == null) {
            return null;
        }
        if (ctx.NAME() != null) {
            String name = ctx.NAME().getText();
            int line = ctx.NAME().getSymbol().getLine();
            Scope scope = null;
            if (baseItem instanceof Scope) {
                scope = (Scope)baseItem;
            } else if (baseItem.getTypeHint() != null && baseItem.getTypeHint().getScope() instanceof Scope) {
                scope = (Scope)baseItem.getTypeHint().getScope();
            }
            ScopeItem scopeItem = result = scope == null ? null : scope.lookupMember(name, this.m_source, line, this.m_currentScope.isFunctionScope());
            if (result == null) {
                this.m_unresolvedNames.add(name);
                if (scope != null) {
                    this.unresolvedName(name, line);
                }
            } else {
                this.m_resolvedItems.add(result);
            }
        } else if (ctx.slices() != null) {
            this.m_isSlice = true;
        }
        return result;
    }

    List<ScopeItem> getResolvedItems() {
        return this.m_resolvedItems;
    }

    List<String> getUnresolvedNames() {
        return this.m_unresolvedNames;
    }

    boolean isCall() {
        return this.m_isCall;
    }

    boolean isSlice() {
        return this.m_isSlice;
    }
}

