/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.client.eclipse.application;

import com.hello2morrow.sonargraph.client.eclipse.application.IExceptionHandler;
import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseLogListener
implements ILogListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EclipseLogListener.class);
    private final IExceptionHandler m_exceptionHandler;

    public EclipseLogListener(IExceptionHandler exceptionHandler) {
        assert (exceptionHandler != null) : "Parameter 'exceptionHandler' of method 'EclipseLogListener' must not be null";
        this.m_exceptionHandler = exceptionHandler;
    }

    protected boolean isRelevant(IStatus status, String plugin) {
        assert (status != null) : "Parameter 'status' of method 'isRelevant' must not be null";
        assert (plugin != null) : "Parameter 'plugin' of method 'isRelevant' must not be null";
        return true;
    }

    public final void logging(IStatus status, String plugin) {
        if (status == null || plugin == null) {
            return;
        }
        if (!this.isRelevant(status, plugin)) {
            return;
        }
        if (status.isOK()) {
            LOGGER.info(status.toString());
            return;
        }
        Throwable t = status.getException();
        switch (status.getSeverity()) {
            case 1: {
                if (t == null) {
                    LOGGER.info(status.toString());
                    break;
                }
                LOGGER.info(status.toString(), t);
                break;
            }
            case 2: {
                if (t == null) {
                    LOGGER.warn(status.toString());
                    break;
                }
                LOGGER.warn(status.toString(), t);
                break;
            }
            case 4: {
                if (CommandRegistry.hasInstance()) {
                    String msg = status.toString() + StringUtility.LINE_SEPARATOR + CommandRegistry.getInstance().getExecutionContextInfo();
                    if (t == null) {
                        LOGGER.error(msg);
                        break;
                    }
                    LOGGER.error(msg, t);
                    break;
                }
                if (t == null) {
                    LOGGER.error(status.toString());
                    break;
                }
                LOGGER.error(status.toString(), t);
            }
        }
        if (t != null) {
            this.m_exceptionHandler.processException(status, plugin, t);
        }
    }
}

