/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.client.eclipse.application;

import com.hello2morrow.sonargraph.client.eclipse.application.LanguageProviderExtension;
import com.hello2morrow.sonargraph.core.application.SonargraphApplication;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ILanguageProvider;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BundleController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleController.class);
    private static final String EXTENSION_CLASS_ATTRIBUTE = "class";
    private static final String LANGUAGE_PROVIDER_EXTENSION_ID = "com.hello2morrow.sonargraph.languageprovider.extension";
    private final List<LanguageProviderExtension> m_extensions;
    private final SonargraphApplication m_application;
    private final Set<Language> m_availableLanguages;

    BundleController(SonargraphApplication application) {
        assert (application != null) : "Parameter 'application' of method 'BundleController' must not be null";
        this.m_application = application;
        this.m_extensions = new ArrayList<LanguageProviderExtension>();
        this.m_availableLanguages = new THashSet();
        try {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(LANGUAGE_PROVIDER_EXTENSION_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement nextConfigurationElement = iConfigurationElementArray[n2];
                Object nextExtension = nextConfigurationElement.createExecutableExtension(EXTENSION_CLASS_ATTRIBUTE);
                if (nextExtension instanceof LanguageProviderExtension) {
                    LanguageProviderExtension nextLanguageProviderExtension = (LanguageProviderExtension)nextExtension;
                    this.m_extensions.add(nextLanguageProviderExtension);
                    this.m_availableLanguages.add(nextLanguageProviderExtension.getLanguageProvider().getLanguage());
                } else if (nextExtension != null) {
                    LOGGER.warn("Unexpected class: " + nextExtension.getClass().getSimpleName());
                } else {
                    LOGGER.warn("No extension class for extension class attribute");
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            LOGGER.warn("Caught unexpected exception: " + ExceptionUtility.collectFirstAndLast((Throwable)ex));
        }
    }

    void uninstallPluginBundles(BundleContext bundleContext) {
        assert (bundleContext != null) : "Parameter 'bundleContext' of method 'uninstallPluginBundles' must not be null";
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle nextBundle = bundleArray[n2];
            String nextBundleName = nextBundle.getSymbolicName();
            if (nextBundleName.startsWith("com.hello2morrow.sonargraph.plugin.") && !nextBundleName.startsWith("com.hello2morrow.sonargraph.plugin.api")) {
                try {
                    nextBundle.uninstall();
                    assert (nextBundle.getState() == 1) : "Bundle not uninstalled";
                    LOGGER.info("Uninstalled bundle: " + nextBundleName);
                }
                catch (BundleException ex) {
                    LOGGER.warn("Could not uninstall plugin bundle '" + nextBundleName + "'", (Throwable)ex);
                }
            }
            ++n2;
        }
    }

    List<LanguageProviderExtension> uninstallBundlesOfUnlicensedLanguages(List<LanguageProviderExtension> availableLpExtensions, SonargraphLicenseHandler licenseHandler, BundleContext bundleContext, Set<String> languages) {
        assert (availableLpExtensions != null) : "Parameter 'availableLpExtensions' of method 'determineLicensedLanguageProviderExtensions' must not be null";
        assert (licenseHandler != null) : "Parameter 'licenseHandler' of method 'determineLicensedLanguageProviderExtensions' must not be null";
        assert (bundleContext != null) : "Parameter 'bundleContext' of method 'determineLicensedLanguageProviderExtensions' must not be null";
        assert (languages != null) : "Parameter 'languages' of method 'determineLicensedLanguageProviderExtensions' must not be null";
        ArrayList<LanguageProviderExtension> lpExtensions = new ArrayList<LanguageProviderExtension>();
        for (LanguageProviderExtension next : availableLpExtensions) {
            ILanguageProvider nextAvailableLp = next.getLanguageProvider();
            Language language = nextAvailableLp.getLanguage();
            boolean isLanguageExcluded = this.m_application.isLanguageExcluded(languages, language);
            if (!isLanguageExcluded && licenseHandler.getLicense().isAvailable(language)) {
                lpExtensions.add(next);
                continue;
            }
            Bundle[] bundleArray = bundleContext.getBundles();
            int n = bundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value;
                Bundle bundle = bundleArray[n2];
                Object entry = bundle.getHeaders().get("com-hello2morrow-language");
                if (entry != null && entry instanceof String && (value = (String)entry).equals(nextAvailableLp.getLanguage().getStandardName())) {
                    try {
                        bundle.uninstall();
                        assert (bundle.getState() == 1) : "Bundle not uninstalled";
                        LOGGER.info("Uninstalled bundle: " + bundle.getSymbolicName());
                    }
                    catch (BundleException ex) {
                        LOGGER.info("Could not uninstall bundle: " + bundle.getSymbolicName());
                    }
                }
                ++n2;
            }
        }
        return lpExtensions;
    }

    List<LanguageProviderExtension> getAvailableExtensions() {
        return Collections.unmodifiableList(this.m_extensions);
    }

    Set<Language> getAvailableLanguages() {
        return Collections.unmodifiableSet(this.m_availableLanguages);
    }
}

