/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.swagger;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.api.AnyFactory;
import com.hello2morrow.sonargraph.api.IAggregatedDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyAccess;
import com.hello2morrow.sonargraph.api.IDependencyKind;
import com.hello2morrow.sonargraph.api.IElementAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.IPluginIssueId;
import com.hello2morrow.sonargraph.api.PluginProgrammingElementMetaData;
import com.hello2morrow.sonargraph.api.WebMethodType;
import com.hello2morrow.sonargraph.api.WebProperty;
import com.hello2morrow.sonargraph.api.WebUtilities;
import com.hello2morrow.sonargraph.api.java.IAnnotationAccess;
import com.hello2morrow.sonargraph.api.java.IJavaMethodAccess;
import com.hello2morrow.sonargraph.api.java.IJavaTypeAccess;
import com.hello2morrow.sonargraph.api.java.JavaDependencyKind;
import com.hello2morrow.sonargraph.plugin.IModelPluginContext;
import com.hello2morrow.sonargraph.plugin.java.IPluginJavaAccess;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class JavaEEWebResourceDetector {
    private static final String WS_RS_PATH = "Workspace:External [Java]:[Unknown]:javax:ws:rs:Path:Path";
    private static final String APPLICATION_PATH = "Workspace:External [Java]:[Unknown]:javax:ws:rs:ApplicationPath:ApplicationPath";
    private final String m_pluginId;
    private final PluginProgrammingElementMetaData m_webResourceMetaData;
    private final IPluginIssueId m_applicationPathIsNotUniqueIssueId;

    JavaEEWebResourceDetector(String pluginId, PluginProgrammingElementMetaData webResourceMetaData, IPluginIssueId applicationPathIsNotUniqueIssueId) {
        assert (pluginId != null && pluginId.length() > 0) : "Parameter 'pluginId' of method 'JavaEEWebResourceDetector' must not be empty";
        assert (webResourceMetaData != null) : "Parameter 'webResourceMetaData' of method 'JavaEEWebResourceDetector' must not be null";
        assert (applicationPathIsNotUniqueIssueId != null) : "Parameter 'applicationPathIsNotUniqueIssueId' of method 'JavaEEWebResourceDetector' must not be null";
        this.m_pluginId = pluginId;
        this.m_webResourceMetaData = webResourceMetaData;
        this.m_applicationPathIsNotUniqueIssueId = applicationPathIsNotUniqueIssueId;
    }

    private IAnnotationAccess findAnnotation(List<IAnnotationAccess> annotations, IJavaTypeAccess annotationType) {
        assert (annotations != null) : "Parameter 'annotations' of method 'findAnnotation' must not be null";
        assert (annotationType != null) : "Parameter 'annotationType' of method 'findAnnotation' must not be null";
        return annotations.stream().filter(a -> a.getAnnotationClass().equals(annotationType)).findFirst().orElse(null);
    }

    private String extractValueFromAnnotation(IDependencyAccess dep, String propertyName) {
        assert (dep != null) : "Parameter 'dep' of method 'extractValueFromAnnotation' must not be null";
        assert (propertyName != null && propertyName.length() > 0) : "Parameter 'propertyName' of method 'extractValueFromAnnotation' must not be empty";
        IJavaTypeAccess from = (IJavaTypeAccess)dep.getFrom();
        IJavaTypeAccess annotationType = (IJavaTypeAccess)dep.getTo();
        IAnnotationAccess annotation = this.findAnnotation(from.getAnnotations(), annotationType);
        if (annotation != null) {
            return annotation.getValue(propertyName).getStringValue();
        }
        return null;
    }

    void detect(IModelPluginContext context, IPluginJavaAccess javaAccess) {
        assert (context != null) : "Parameter 'context' of method 'detect' must not be null";
        assert (javaAccess != null) : "Parameter 'javaAccess' of method 'handleJavaEEAnnotations' must not be null";
        String applicationPath = this.determineApplicationPath(context, javaAccess);
        if (applicationPath == null) {
            return;
        }
        IJavaTypeAccess pathAnnotation = (IJavaTypeAccess)javaAccess.findElementByFqn(WS_RS_PATH);
        if (pathAnnotation == null) {
            return;
        }
        List pathAnnotatedElementDependencies = pathAnnotation.getIncomingDependencies(Aggregator.ELEMENT, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
        HashMap<IJavaTypeAccess, String> typeToPaths = new HashMap<IJavaTypeAccess, String>();
        HashMap<IJavaMethodAccess, IAnnotationAccess> methodToPathAnnotations = new HashMap<IJavaMethodAccess, IAnnotationAccess>();
        this.collectPathAnnotatedTypesAndMethods(context, pathAnnotation, pathAnnotatedElementDependencies, typeToPaths, methodToPathAnnotations);
        if (context.hasBeenCanceled()) {
            return;
        }
        for (IJavaTypeAccess iJavaTypeAccess : typeToPaths.keySet()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            for (IJavaMethodAccess method : iJavaTypeAccess.getMethods()) {
                if (context.hasBeenCanceled()) {
                    return;
                }
                this.processEEMethod(javaAccess, method, (IAnnotationAccess)methodToPathAnnotations.get(method), applicationPath, (String)typeToPaths.get(iJavaTypeAccess));
                methodToPathAnnotations.remove(method);
            }
        }
        for (Map.Entry entry : methodToPathAnnotations.entrySet()) {
            if (context.hasBeenCanceled()) {
                return;
            }
            this.processEEMethod(javaAccess, (IJavaMethodAccess)entry.getKey(), (IAnnotationAccess)entry.getValue(), applicationPath, "");
        }
    }

    private void collectPathAnnotatedTypesAndMethods(IModelPluginContext context, IJavaTypeAccess pathAnnotation, List<IAggregatedDependencyAccess> pathAnnotatedElementDependencies, Map<IJavaTypeAccess, String> typeToPaths, Map<IJavaMethodAccess, IAnnotationAccess> methodToPathAnnotations) {
        for (IAggregatedDependencyAccess nextDep : pathAnnotatedElementDependencies) {
            if (context.hasBeenCanceled()) {
                return;
            }
            INamedElementAccess from = nextDep.getFrom();
            if (from instanceof IJavaTypeAccess) {
                IJavaTypeAccess fromType = (IJavaTypeAccess)from;
                String path = this.extractValueFromAnnotation((IDependencyAccess)nextDep.getDependencies().get(0), "value");
                if (path == null) continue;
                typeToPaths.put(fromType, path);
                continue;
            }
            if (!(from instanceof IJavaMethodAccess)) continue;
            IJavaMethodAccess method = (IJavaMethodAccess)from;
            IAnnotationAccess methodPathAnnotation = this.findAnnotation(((IJavaMethodAccess)from).getAnnotations(), pathAnnotation);
            if (methodPathAnnotation == null) continue;
            methodToPathAnnotations.put(method, methodPathAnnotation);
        }
    }

    private String determineApplicationPath(IModelPluginContext context, IPluginJavaAccess javaAccess) {
        IJavaTypeAccess applicationPathAnnotation = (IJavaTypeAccess)javaAccess.findElementByFqn(APPLICATION_PATH);
        String applicationPath = "";
        if (applicationPathAnnotation != null) {
            List annotatedTypeDependencies = applicationPathAnnotation.getIncomingDependencies(Aggregator.TYPE, true, new IDependencyKind[]{JavaDependencyKind.HAS_ANNOTATION});
            if (annotatedTypeDependencies.size() == 1) {
                IAggregatedDependencyAccess annotatedTypeDependency = (IAggregatedDependencyAccess)annotatedTypeDependencies.get(0);
                IDependencyAccess dependency = (IDependencyAccess)annotatedTypeDependency.getDependencies().get(0);
                applicationPath = this.extractValueFromAnnotation(dependency, "value");
                if (applicationPath == null) {
                    applicationPath = "";
                }
            } else {
                for (IAggregatedDependencyAccess next : annotatedTypeDependencies) {
                    if (context.hasBeenCanceled()) {
                        return null;
                    }
                    javaAccess.addIssue((IElementAccess)next.getDependencies().get(0), this.m_applicationPathIsNotUniqueIssueId, null, -1);
                }
            }
        }
        return applicationPath;
    }

    private void processEEMethod(IPluginJavaAccess javaAccess, IJavaMethodAccess method, IAnnotationAccess pathAnnotation, String applicationPath, String typePath) {
        String path;
        ArrayList<String> methods = new ArrayList<String>();
        int lineNumber = -1;
        if (pathAnnotation == null) {
            path = "";
        } else {
            path = pathAnnotation.getValue("value").getStringValue();
            lineNumber = pathAnnotation.getLineNumber();
        }
        HashSet availableMethods = new HashSet(WebMethodType.asList());
        for (IAnnotationAccess annotation : method.getAnnotations()) {
            String annoName = annotation.getAnnotationClass().getShortName();
            if (!availableMethods.contains(annoName)) continue;
            methods.add(annoName);
            lineNumber = annotation.getLineNumber();
        }
        if (!methods.isEmpty()) {
            Object resultingPath = String.format("%s/%s/%s", applicationPath, typePath, path).replace("///", "/").replaceAll("//", "/");
            if (!((String)resultingPath).startsWith("/")) {
                resultingPath = "/" + (String)resultingPath;
            }
            if (((String)resultingPath).endsWith("/")) {
                resultingPath = ((String)resultingPath).substring(0, ((String)resultingPath).length() - 1);
            }
            THashMap properties = new THashMap();
            properties.put(WebProperty.HTTP_METHOD.getStandardName(), AnyFactory.createFrom(methods));
            properties.put(WebProperty.FRAMEWORK.getStandardName(), AnyFactory.createFrom((Object)"JAX-RS"));
            properties.put(WebProperty.PATH_TO_MATCH.getStandardName(), AnyFactory.createFrom((Object)WebUtilities.removeVariablesFromPath((String)resultingPath)));
            javaAccess.createProgrammingElement(this.m_pluginId, this.m_webResourceMetaData, (INamedElementAccess)method, (String)resultingPath, lineNumber, (Map)properties);
        }
    }
}

