/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin;

import com.hello2morrow.sonargraph.plugin.ISonargraphPluginAttribute;
import com.hello2morrow.sonargraph.plugin.ISonargraphPluginConfiguration;
import com.hello2morrow.sonargraph.plugin.SonargraphBooleanPluginAttribute;
import com.hello2morrow.sonargraph.plugin.SonargraphPluginAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SonargraphPluginConfiguration
implements ISonargraphPluginConfiguration {
    public static final String HEADER_GROUP = "Header";
    public static final String BASIC_GROUP = "Basic";
    private final Map<String, SonargraphPluginAttribute> m_attributes = new LinkedHashMap<String, SonargraphPluginAttribute>();
    private final Map<SonargraphPluginAttribute, Object> m_values = new HashMap<SonargraphPluginAttribute, Object>();
    private final SonargraphBooleanPluginAttribute m_enabledAttribute = new SonargraphBooleanPluginAttribute("enabled", "Enabled", "Plugin status", "Header", false);

    public static boolean isEnabled(SonargraphPluginConfiguration configuration, Map<SonargraphPluginAttribute, Object> values) {
        assert (values != null) : "Parameter 'values' of method 'isEnabled' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'isEnabled' must not be null";
        Object value = values.get(configuration.getEnabledAttribute());
        assert (value != null && value instanceof Boolean) : "Unexpected class in method 'isEnabled': " + String.valueOf(value);
        return (Boolean)value;
    }

    public SonargraphPluginConfiguration() {
        this.m_attributes.put(this.m_enabledAttribute.getName(), this.m_enabledAttribute);
        this.m_values.put(this.m_enabledAttribute, false);
        this.m_enabledAttribute.setConfiguration(this);
    }

    public SonargraphBooleanPluginAttribute getEnabledAttribute() {
        return this.m_enabledAttribute;
    }

    public boolean isEnabled() {
        return SonargraphPluginConfiguration.isEnabled(this, this.m_values);
    }

    void addAttribute(SonargraphPluginAttribute attribute) {
        assert (attribute != null) : "Parameter 'definition' of method 'addAttribute' must not be null";
        SonargraphPluginAttribute previous = this.m_attributes.put(attribute.getName(), attribute);
        assert (previous == null) : "Definition already present: " + String.valueOf(attribute);
        this.m_values.put(attribute, attribute.getDefaultValue());
        attribute.setConfiguration(this);
    }

    public Map<String, SonargraphPluginAttribute> getAttributes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    public SonargraphPluginAttribute getAttribute(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getAttribute' must not be empty";
        return this.m_attributes.get(name);
    }

    public Map<SonargraphPluginAttribute, Object> getValues() {
        return new HashMap<SonargraphPluginAttribute, Object>(this.m_values);
    }

    public Map<SonargraphPluginAttribute, Object> getDefaultValues() {
        HashMap<SonargraphPluginAttribute, Object> values = new HashMap<SonargraphPluginAttribute, Object>(this.m_attributes.size());
        for (SonargraphPluginAttribute next : this.m_attributes.values()) {
            values.put(next, next.getDefaultValue());
        }
        return values;
    }

    @Override
    public Object getValue(ISonargraphPluginAttribute attribute) {
        assert (attribute != null) : "Parameter 'attribute' of method 'getValue' must not be null";
        Object value = this.m_values.get(attribute);
        assert (value != null) : "Parameter 'value' of method 'getValue' must not be null";
        return value;
    }

    public void updateValues(Map<SonargraphPluginAttribute, Object> values) {
        assert (values != null) : "Parameter 'values' of method 'updateValues' must not be null";
        for (Map.Entry<SonargraphPluginAttribute, Object> nextEntry : values.entrySet()) {
            Object nextReplacedValue = this.m_values.put(nextEntry.getKey(), nextEntry.getValue());
            assert (nextReplacedValue != null) : "'nextReplacedValue' of method 'updateValues' must not be null";
        }
    }
}

