/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Decommenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Decommenter.class);

    Decommenter() {
    }

    static String decomment(Path path, String source) {
        assert (path != null) : "Parameter 'path' of method 'decomment' must not be null";
        assert (source != null) : "Parameter 'source' of method 'decomment' must not be null";
        Stack<State> stateStack = new Stack<State>();
        StringBuilder result = new StringBuilder();
        char[] sourceCharArray = source.toCharArray();
        State currentState = State.NORMAL;
        int pos = 0;
        while (pos < sourceCharArray.length) {
            Transition transition = currentState.getTransition(sourceCharArray, pos);
            if (transition == null) {
                int c = sourceCharArray[pos];
                if (!currentState.isComment() || c == 13 || c == 10) {
                    if (currentState.isString() && c == 64) {
                        c = 42;
                    }
                    result.append((char)c);
                }
                ++pos;
                continue;
            }
            if (currentState == State.LINE_COMMENT) {
                result.append(transition.m_startSequence);
                currentState = (State)((Object)stateStack.pop());
            } else if (currentState == State.BLOCK_COMMENT) {
                currentState = (State)((Object)stateStack.pop());
            } else {
                if (!transition.m_nextState.isComment()) {
                    result.append(transition.m_startSequence);
                }
                if (transition.m_nextState == State.POP_STACK) {
                    currentState = (State)((Object)stateStack.pop());
                } else {
                    stateStack.push(currentState);
                    currentState = transition.m_nextState;
                }
            }
            pos += transition.m_startSequence.length();
        }
        if (!stateStack.isEmpty()) {
            LOGGER.error("Non-empty State stack during de-commenting of '" + path.toFile().getAbsolutePath() + "': " + String.valueOf(stateStack));
        } else if (currentState != State.NORMAL) {
            LOGGER.error("Un-normal terminal State during de-commenting of '" + path.toFile().getAbsolutePath() + "': " + String.valueOf((Object)currentState));
        }
        return result.toString();
    }

    private static enum State {
        NORMAL,
        SINGLE_QUOTE_STRING,
        DOUBLE_QUOTE_STRING,
        BACKTICK_STRING,
        REGEX_STRING,
        REGEX_SELECT,
        ESCAPE_SEQUENCE,
        TEMPLATE,
        LINE_COMMENT,
        BLOCK_COMMENT,
        POP_STACK;

        private final List<Transition> transitions = new ArrayList<Transition>();

        static {
            State.NORMAL.transitions.add(new Transition("'", SINGLE_QUOTE_STRING));
            State.NORMAL.transitions.add(new Transition("\"", DOUBLE_QUOTE_STRING));
            State.NORMAL.transitions.add(new Transition("`", BACKTICK_STRING));
            State.NORMAL.transitions.add(new Transition("//", LINE_COMMENT));
            State.NORMAL.transitions.add(new Transition("/*", BLOCK_COMMENT));
            State.NORMAL.transitions.add(new Transition("/", REGEX_STRING));
            State.SINGLE_QUOTE_STRING.transitions.add(new Transition("'", POP_STACK));
            State.SINGLE_QUOTE_STRING.transitions.add(new Transition("\\", ESCAPE_SEQUENCE));
            State.DOUBLE_QUOTE_STRING.transitions.add(new Transition("\"", POP_STACK));
            State.DOUBLE_QUOTE_STRING.transitions.add(new Transition("\\", ESCAPE_SEQUENCE));
            State.BACKTICK_STRING.transitions.add(new Transition("`", POP_STACK));
            State.BACKTICK_STRING.transitions.add(new Transition("\\", ESCAPE_SEQUENCE));
            State.BACKTICK_STRING.transitions.add(new Transition("${", TEMPLATE));
            State.REGEX_STRING.transitions.add(new Transition("/", POP_STACK));
            State.REGEX_STRING.transitions.add(new Transition("\\", ESCAPE_SEQUENCE));
            State.REGEX_STRING.transitions.add(new Transition("\r\n", POP_STACK));
            State.REGEX_STRING.transitions.add(new Transition("\n", POP_STACK));
            State.REGEX_STRING.transitions.add(new Transition("\r", POP_STACK));
            State.REGEX_STRING.transitions.add(new Transition("[", REGEX_SELECT));
            State.REGEX_SELECT.transitions.add(new Transition("\\", ESCAPE_SEQUENCE));
            State.REGEX_SELECT.transitions.add(new Transition("]", POP_STACK));
            State.TEMPLATE.transitions.add(new Transition("'", SINGLE_QUOTE_STRING));
            State.TEMPLATE.transitions.add(new Transition("\"", DOUBLE_QUOTE_STRING));
            State.TEMPLATE.transitions.add(new Transition("`", BACKTICK_STRING));
            State.TEMPLATE.transitions.add(new Transition("/*", BLOCK_COMMENT));
            State.TEMPLATE.transitions.add(new Transition("/", REGEX_STRING));
            State.TEMPLATE.transitions.add(new Transition("}", POP_STACK));
            State.LINE_COMMENT.transitions.add(new Transition("\r\n", POP_STACK));
            State.LINE_COMMENT.transitions.add(new Transition("\n", POP_STACK));
            State.LINE_COMMENT.transitions.add(new Transition("\r", POP_STACK));
            State.BLOCK_COMMENT.transitions.add(new Transition("*/", POP_STACK));
        }

        boolean isComment() {
            return this == LINE_COMMENT || this == BLOCK_COMMENT;
        }

        boolean isString() {
            return this == SINGLE_QUOTE_STRING || this == DOUBLE_QUOTE_STRING || this == BACKTICK_STRING || this == ESCAPE_SEQUENCE;
        }

        Transition getTransition(char[] charArray, int pos) {
            if (this == ESCAPE_SEQUENCE) {
                return new Transition(String.valueOf(charArray[pos]), POP_STACK);
            }
            block0: for (Transition transition : this.transitions) {
                int i = 0;
                while (i < transition.m_startSequence.length()) {
                    if (transition.m_startSequence.charAt(i) != charArray[pos + i]) continue block0;
                    ++i;
                }
                return transition;
            }
            return null;
        }
    }

    private static final class Transition {
        private final String m_startSequence;
        private final State m_nextState;

        private Transition(String startSequence, State nextState) {
            assert (startSequence != null) : "Parameter 'startSequence' of method 'Transition' must not be null";
            assert (nextState != null) : "Parameter 'nextState' of method 'Transition' must not be null";
            this.m_startSequence = startSequence;
            this.m_nextState = nextState;
        }
    }
}

