/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.ISonargraphBuild;
import com.hello2morrow.sonargraph.build.api.ResendFailedUploadsRequest;
import com.hello2morrow.sonargraph.build.api.ServiceResponse;
import com.hello2morrow.sonargraph.build.api.SonargraphBuildException;
import com.hello2morrow.sonargraph.build.api.StatusCode;
import com.hello2morrow.sonargraph.build.client.BuildInteraction;
import com.hello2morrow.sonargraph.build.client.ILogger;
import com.hello2morrow.sonargraph.build.client.ISonargraphBuildClient;

public final class ResendFailedUploadsInteraction
extends BuildInteraction {
    private final ResendFailedUploadsRequest m_request;

    public ResendFailedUploadsInteraction(ISonargraphBuildClient client, ResendFailedUploadsRequest request) {
        super(client);
        assert (request != null) : "Parameter 'request' of method 'ResendFailedUploadsInteraction' must not be null";
        this.m_request = request;
    }

    @Override
    public boolean needsLicense() {
        return false;
    }

    @Override
    public ServiceResponse validateInput(ILogger logger) {
        if (!this.m_request.getUploadHostUrl().startsWith("http://")) {
            return new ServiceResponse(StatusCode.FAILED, "'uploadHostUrl' must start with 'http://'");
        }
        if (this.m_request.getClientKey().length() == 0) {
            return new ServiceResponse(StatusCode.FAILED, "'clientKey' must not be empty");
        }
        return new ServiceResponse(StatusCode.OK, "All parameters valid");
    }

    @Override
    public String getDescription() {
        return "Resend reports that failed to upload before.";
    }

    @Override
    public ServiceResponse execute(ISonargraphBuild sonargraphBuild, ILogger logger) throws SonargraphBuildException {
        ServiceResponse response = sonargraphBuild.resendFaildUploads(this.m_request);
        logger.info(response.getStatusMessage());
        return response;
    }
}

