/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.client;

import com.hello2morrow.sonargraph.build.api.AbstractIssueFilter;
import com.hello2morrow.sonargraph.build.api.FailSet;
import com.hello2morrow.sonargraph.build.api.IssueFilter;
import com.hello2morrow.sonargraph.build.client.Params;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ConfigurationFileParser
extends DefaultHandler {
    private static final String ROOT_ELEMENT_NAME = "sonargraphBuild";
    private static final String FAILSET_ELEMENT_NAME = Params.FAILSET.getParameterName();
    private static final String INCLUDE_ELEMENT_NAME = Params.INCLUDE_ISSUE_TYPE.getParameterName();
    private static final String EXCLUDE_ELEMENT_NAME = Params.EXCLUDE_ISSUE_TYPE.getParameterName();
    private static final String ISSUE_TYPE_ATTR = Params.ISSUE_TYPE.getParameterName();
    private static final String FAIL_ON_EMPTY_WORKSPACE_ATTR = Params.FAIL_ON_EMPTY_WORKSPACE.getParameterName();
    private static final String FAIL_ON_ISSUES_ATTR = Params.FAIL_ON_ISSUES.getParameterName();
    private boolean m_startElementDetected;
    private Map<Params, String> m_rootParams;
    private FailSet m_failSet;
    private Object m_currentFailSetParent;
    private final Deque<String> m_parentElementNameStack = new ArrayDeque<String>();

    ConfigurationFileParser() {
    }

    public void process(File configurationFile) throws Exception {
        assert (configurationFile != null) : "Parameter 'configurationFile' of method 'process' must not be null";
        this.m_startElementDetected = false;
        this.m_rootParams = new HashMap<Params, String>();
        this.m_failSet = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(configurationFile);){
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)is, (DefaultHandler)this);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Map<Params, String> getRootParams() {
        return this.m_rootParams;
    }

    public FailSet getFailSet() {
        return this.m_failSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String currentParent = this.m_parentElementNameStack.peek();
        if (qName.equals(ROOT_ELEMENT_NAME)) {
            this.m_startElementDetected = true;
        } else if (!this.m_startElementDetected) {
            throw new SAXException(String.format("Start element '%s' does not match expected element '%s'", qName, ROOT_ELEMENT_NAME));
        }
        if (ROOT_ELEMENT_NAME.equals(qName)) {
            this.extractAttributeValues(attributes);
        } else if (FAILSET_ELEMENT_NAME.equals(qName)) {
            String trimmed;
            String trimmed2;
            if (this.m_failSet != null) {
                throw new SAXException(String.format("Only a single element '%s' is allowed.", FAILSET_ELEMENT_NAME));
            }
            this.m_failSet = new FailSet();
            this.m_currentFailSetParent = this.m_failSet;
            this.m_failSet.setFailOnEmptyWorkspace(true);
            String failOnEmpty = attributes.getValue(FAIL_ON_EMPTY_WORKSPACE_ATTR);
            if (failOnEmpty != null && (trimmed2 = failOnEmpty.trim()).equalsIgnoreCase(Boolean.toString(false))) {
                this.m_failSet.setFailOnEmptyWorkspace(false);
            }
            this.m_failSet.setFailOnIssues(true);
            String failOnIssues = attributes.getValue(FAIL_ON_ISSUES_ATTR);
            if (failOnIssues != null && (trimmed = failOnIssues.trim()).equalsIgnoreCase(Boolean.toString(false))) {
                this.m_failSet.setFailOnIssues(false);
            }
        } else if (INCLUDE_ELEMENT_NAME.equals(qName)) {
            if (this.m_failSet == null && !currentParent.equals(FAILSET_ELEMENT_NAME)) {
                throw new SAXException(String.format("Element '%s' must be a child element of '%s'", INCLUDE_ELEMENT_NAME, FAILSET_ELEMENT_NAME));
            }
            if (this.m_currentFailSetParent != this.m_failSet) throw new SAXException(String.format("Element '%s' must be a direct child element of '%s'", INCLUDE_ELEMENT_NAME, FAILSET_ELEMENT_NAME));
            this.m_failSet.addIncludeIssueFilter(this.createFilter(attributes));
        } else {
            if (!EXCLUDE_ELEMENT_NAME.equals(qName)) throw new SAXException(String.format("Unsupported element '%s'", qName));
            if (this.m_failSet == null) {
                throw new SAXException(String.format("Element '%s' must be a child element of '%s'", EXCLUDE_ELEMENT_NAME, FAILSET_ELEMENT_NAME));
            }
            if (this.m_currentFailSetParent != this.m_failSet) throw new SAXException(String.format("Element '%s' must be a direct child element of '%s'", EXCLUDE_ELEMENT_NAME, FAILSET_ELEMENT_NAME));
            this.m_failSet.addExcludeIssueFilter(this.createFilter(attributes));
        }
        this.m_parentElementNameStack.push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String lastElement = this.m_parentElementNameStack.pop();
        assert (lastElement.equals(qName)) : "Unexpected end element '" + qName + "'. Expected '" + lastElement + "'";
    }

    private IssueFilter createFilter(Attributes attributes) throws SAXException {
        assert (attributes != null) : "Parameter 'attributes' of method 'handleFilter' must not be null";
        IssueFilter.Builder builder = new IssueFilter.Builder();
        this.setStandardFilterAttributes(attributes, builder);
        return builder.create();
    }

    private void setStandardFilterAttributes(Attributes attributes, AbstractIssueFilter.AbstractBuilder<?> builder) throws SAXException {
        String resolution;
        String issueType = attributes.getValue(ISSUE_TYPE_ATTR);
        if (issueType == null || issueType.trim().length() == 0) {
            throw new SAXException(String.format("Missing attribute '%s'", ISSUE_TYPE_ATTR));
        }
        builder.issueType(issueType.trim());
        String severity = attributes.getValue("severity");
        if (severity != null && severity.trim().length() > 0) {
            builder.severity(severity.trim());
        }
        if ((resolution = attributes.getValue("resolution")) != null && resolution.trim().length() > 0) {
            builder.resolution(resolution.trim());
        }
    }

    private void extractAttributeValues(Attributes attributes) throws SAXException {
        assert (attributes != null) : "Parameter 'attributes' of method 'extractAttributeValues' must not be null";
        int i = 0;
        while (i < attributes.getLength()) {
            String attributeName = attributes.getQName(i);
            Params matchedParam = null;
            Params[] paramsArray = Params.values();
            int n = paramsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Params param = paramsArray[n2];
                if (param.getParameterName().equals(attributeName)) {
                    matchedParam = param;
                    break;
                }
                ++n2;
            }
            if (matchedParam == null) {
                throw new SAXException(String.format("Unsupported attribute '%s'", attributeName));
            }
            String value = attributes.getValue(i);
            if (value != null && value.trim().length() != 0 || (value = matchedParam.getDefaultValue().trim()) != null && value.length() != 0) {
                this.m_rootParams.put(matchedParam, value.trim());
            }
            ++i;
        }
        Params[] paramsArray = Params.values();
        int n = paramsArray.length;
        int n3 = 0;
        while (n3 < n) {
            String defaultValue;
            Params param = paramsArray[n3];
            if (this.m_rootParams.get((Object)param) == null && (defaultValue = param.getDefaultValue().trim()) != null && defaultValue.length() > 0) {
                this.m_rootParams.put(param, defaultValue);
            }
            ++n3;
        }
    }
}

