/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.system;

import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum CoreDLL implements IStandardEnumeration
{
    MSCORLIB("mscorlib"),
    SYSTEM("System"),
    SYSTEM_CORE("System.Core");

    private final String m_presentationName;
    private static final Set<String> coreAssembliesToLocate;

    static {
        coreAssembliesToLocate = new HashSet<String>(CoreDLL.values().length);
        CoreDLL[] coreDLLArray = CoreDLL.values();
        int n = coreDLLArray.length;
        int n2 = 0;
        while (n2 < n) {
            CoreDLL next = coreDLLArray[n2];
            coreAssembliesToLocate.add(next.getPresentationName());
            ++n2;
        }
    }

    private CoreDLL(String presentationName) {
        this.m_presentationName = presentationName;
    }

    public String getStandardName() {
        return StringUtility.convertConstantNameToStandardName((String)this.name());
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    public String toString() {
        return super.toString() + CSharpFileType.ASSEMBLY.getDefaultExtension();
    }

    public static Set<String> getCoreAssemblyNames() {
        return Collections.unmodifiableSet(coreAssembliesToLocate);
    }

    public static boolean matchesCoreAssemblyName(String name) {
        return coreAssembliesToLocate.stream().anyMatch(core -> core.equalsIgnoreCase(name));
    }
}

