/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture.CSharpAttributeRetriever;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CSharpDependencyType;
import java.util.List;
import java.util.Set;

public final class CSharpImplementsInterfaceRetriever
extends CSharpAttributeRetriever {
    public String getName() {
        return "CSharpImplementsInterface";
    }

    public String getShortName() {
        return "ImplementsInterface";
    }

    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        return "Matches the pattern against the fully qualified C# name (namespace plus class name separated by \u2018.\u2019) of any interface implemented by the class.\n\nIn a physical model a C# component will only be considered if it contains a type that has the same name as the component.\n\nPlease note that \u201c*\u201d will match anything except dots (\u2018.\u2019).\n\nWildcards: ?=any character, *=any sequence between dots, **=any sequence";
    }

    public String getMultipleAttributeInfo() {
        return "Implements interface";
    }

    @Override
    protected final void collect(IWorkerContext workerContext, CSharpType type, Set<String> collector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectInterfaces' must not be null";
        assert (type != null) : "Parameter 'type' of method 'collectInterfaces' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'collect' must not be null";
        for (CSharpType typePart : type.getPartialSegments()) {
            List dependencies;
            List list = dependencies = typePart.isInterface() ? typePart.getOutgoingDependencies(new IParserDependencyType[]{CSharpDependencyType.IMPLEMENTS}) : typePart.getOutgoingDependencies(new IParserDependencyType[]{CSharpDependencyType.EXTENDS, CSharpDependencyType.IMPLEMENTS});
            if (dependencies.isEmpty()) continue;
            for (ParserDependency next : dependencies) {
                Set<String> nextData;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                CSharpType to = (CSharpType)next.getTo();
                if (to.isInterface()) {
                    collector.add(to.getFullyQualifiedTypeName());
                }
                if ((nextData = this.getData(workerContext, to)).isEmpty()) continue;
                collector.addAll(nextData);
            }
        }
    }
}

