/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.csharp.foundation.common.CSharpLanguage;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.CSharpType;
import gnu.trove.set.hash.THashSet;
import java.util.Collections;
import java.util.Set;

abstract class CSharpAttributeRetriever
extends AssignableAttributeRetriever<CSharpType> {
    public static final String CSHARP_WILDCARD_INFO = "?=any character, *=any sequence between dots, **=any sequence";

    CSharpAttributeRetriever() {
    }

    public final Language getLanguage() {
        return CSharpLanguage.INSTANCE;
    }

    private String getReducedName(String name) {
        assert (name != null) : "Parameter 'name' of method 'getReducedName' must not be null";
        int pos = name.indexOf(96);
        if (pos > 0) {
            return name.substring(0, pos);
        }
        return name;
    }

    protected final Set<String> getData(IWorkerContext workerContext, CSharpType type) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'getData' must not be null";
        assert (type != null) : "Parameter 'type' of method 'getData' must not be null";
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        Set<Object> data = this.getData((NamedElement)type);
        if (data == null) {
            THashSet collector = new THashSet();
            this.collect(workerContext, type, (Set<String>)collector);
            data = !collector.isEmpty() ? collector : Collections.emptySet();
            this.setData((NamedElement)type, data);
        }
        return data;
    }

    protected void collect(IWorkerContext workerContext, CSharpType type, Set<String> collector) {
        collector.add(type.getName());
    }

    protected boolean collectFor(CSharpType type) {
        assert (type != null) : "Parameter 'type' of method 'collectFor' must not be null";
        return true;
    }

    protected final String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForComponent' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForComponent' must not be null";
        NamedElement sourceFile = assignable.getNamedElement();
        String name = FileUtility.removeExtension((String)sourceFile.getShortName());
        CSharpType type = sourceFile.getChildrenRecursively(CSharpType.class, new Class[]{ProgrammingElement.class}).stream().filter(t -> this.getReducedName(t.getShortName()).equalsIgnoreCase(name)).findFirst().orElse(null);
        if (type != null && this.collectFor(type)) {
            return this.createAttribute(this.getData(workerContext, type));
        }
        return null;
    }

    protected final String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        ProgrammingElement pe = assignable.getPrimaryProgrammingElement();
        if (pe instanceof CSharpType && this.collectFor((CSharpType)pe)) {
            return this.createAttribute(this.getData(workerContext, (CSharpType)pe));
        }
        return null;
    }

    public String getBreakCharacters() {
        return ".";
    }
}

