/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.WorkspaceExtension;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.ICSharpWorkspaceExtension;
import com.hello2morrow.sonargraph.languageprovider.csharp.controller.system.IProjectInfoProvider;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSolutionFile;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.settings.CSharpSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpExternal;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModule;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpModuleType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpRoslynModule;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.List;

final class CSharpWorkspaceExtension
extends Extension
implements ICSharpWorkspaceExtension,
ISoftwareSystemLifecycleListener {
    private final SoftwareSystem m_softwareSystem;
    private final IProjectInfoProvider m_projectInfoProvider;

    CSharpWorkspaceExtension(SoftwareSystem softwareSystem, IProjectInfoProvider pip) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'CSharpWorkspaceExtension' must not be null";
        assert (pip != null) : "Parameter 'pip' of method 'CSharpWorkspaceExtension' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_projectInfoProvider = pip;
    }

    public static void initializeSystem(Installation installation, SoftwareSystem softwareSystem) {
        assert (installation != null) : "Parameter 'installation' of method 'initializeSystem' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initializeSystem' must not be null";
        Workspace workspace = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        CSharpSystemSettings settings = (CSharpSystemSettings)((Object)workspace.getUniqueChild(CSharpSystemSettings.class));
        if (settings == null) {
            settings = new CSharpSystemSettings((NamedElement)workspace);
            workspace.addChild((NamedElement)settings);
        }
    }

    public static void moveElements(Module sourceModule, Module targetModule) {
        assert (sourceModule != null) : "Parameter 'sourceModule' of method 'moveElements' must not be null";
        assert (targetModule != null) : "Parameter 'targetModule' of method 'moveElements' must not be null";
    }

    @Override
    public OperationResult createModulesFromSolutionFileImportOnSystemCreation(IWorkerContext workerContext, TFile solutionFile, List<ProjectInfo> projectsToImport) {
        CSharpSolutionFile solutionFileElement;
        Workspace ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        CSharpSystemSettings settings = (CSharpSystemSettings)((Object)ws.getUniqueChild(CSharpSystemSettings.class));
        if (settings == null) {
            settings = new CSharpSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)settings);
        }
        if ((solutionFileElement = (CSharpSolutionFile)((Object)settings.getUniqueChild(CSharpSolutionFile.class))) != null) {
            solutionFileElement.remove();
        }
        solutionFileElement = new CSharpSolutionFile((NamedElement)settings, solutionFile);
        settings.addChild((NamedElement)solutionFileElement);
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        OperationResult result = new OperationResult("Adding modules");
        for (ProjectInfo pi : projectsToImport) {
            String name = pi.getAssemblyName();
            if (ws.getChildren(CSharpModule.class).stream().anyMatch(m -> m.getShortName().equals(name))) continue;
            OperationResultWithOutcome localResult = workspaceExtension.createModule(workerContext, (Module.IModuleType)CSharpModuleType.ROSLYN, name, "");
            if (localResult.isFailure()) {
                result.addMessagesFrom((OperationResult)localResult);
                break;
            }
            CSharpRoslynModule module = (CSharpRoslynModule)((Object)localResult.getOutcome());
            module.setProjectName(pi.getName());
            String relPath = FileUtility.calculateRelativePath((TFile)new TFile(pi.getRootPath()), (TFile)this.m_softwareSystem.getDirectoryFile());
            module.setRootPath(relPath);
        }
        return result;
    }

    @Override
    public OperationResult updateModuleSelection(IWorkerContext workerContext, List<ProjectInfo> projectsToImport, TFile solutionFile) {
        CSharpSolutionFile solutionFileElement;
        OperationResult result = new OperationResult("Updating module selection");
        WorkspaceExtension workspaceExtension = (WorkspaceExtension)this.m_softwareSystem.getExtension(WorkspaceExtension.class);
        Workspace ws = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        List modules = ws.getChildren(CSharpRoslynModule.class);
        ArrayList<CSharpRoslynModule> survivingModules = new ArrayList<CSharpRoslynModule>();
        boolean systemChanged = false;
        CSharpSystemSettings settings = (CSharpSystemSettings)((Object)ws.getUniqueChild(CSharpSystemSettings.class));
        if (settings == null) {
            settings = new CSharpSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)settings);
        }
        if ((solutionFileElement = (CSharpSolutionFile)((Object)settings.getUniqueChild(CSharpSolutionFile.class))) == null) {
            solutionFileElement = new CSharpSolutionFile((NamedElement)settings, solutionFile);
            settings.addChild((NamedElement)solutionFileElement);
            systemChanged = true;
        } else if (!FileUtility.areEqual((TFile)solutionFile.getNormalizedAbsoluteFile(), (TFile)solutionFileElement.getFile().getNormalizedAbsoluteFile())) {
            solutionFileElement.setPath(solutionFile);
            systemChanged = true;
        }
        ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).cancelAndResetAllAnalyzers(ResetMode.ALL);
        for (ProjectInfo pi : projectsToImport) {
            String name = pi.getAssemblyName();
            CSharpRoslynModule existingModule = modules.stream().filter(m -> m.getShortName().equals(name)).findFirst().orElse(null);
            String relPath = FileUtility.calculateRelativePath((TFile)new TFile(pi.getRootPath()), (TFile)this.m_softwareSystem.getDirectoryFile());
            if (existingModule != null) {
                survivingModules.add(existingModule);
                if (!existingModule.getProjectName().equals(pi.getName())) {
                    existingModule.setProjectName(pi.getName());
                    systemChanged = true;
                }
                if (existingModule.getRootPath().equals(relPath)) continue;
                existingModule.setRootPath(relPath);
                systemChanged = true;
                continue;
            }
            OperationResultWithOutcome localResult = workspaceExtension.createModule(workerContext, (Module.IModuleType)CSharpModuleType.ROSLYN, name, "");
            if (localResult.isFailure()) {
                result.addMessagesFrom((OperationResult)localResult);
                break;
            }
            CSharpRoslynModule module = (CSharpRoslynModule)((Object)localResult.getOutcome());
            module.setProjectName(pi.getName());
            module.setRootPath(relPath);
            systemChanged = true;
        }
        modules.removeAll(survivingModules);
        for (CSharpRoslynModule module : modules) {
            module.remove();
            systemChanged = true;
        }
        if (systemChanged) {
            this.m_softwareSystem.setNeedsSave(true);
            for (CSharpRoslynModule module : survivingModules) {
                module.clearOutgoingWorkspaceDependencies();
                module.forgetChildren(true);
            }
            ((CSharpExternal)((Object)ws.getUniqueExistingChild(CSharpExternal.class))).forgetChildren(true);
            this.m_softwareSystem.setIsClearable(false);
        } else {
            ((IAnalyzerExecutionController)this.m_softwareSystem.getExtension(IAnalyzerExecutionController.class)).runAutomatedAnalyzers(workerContext);
        }
        return result;
    }

    @Override
    public List<ProjectInfo> getProjectsFromSolution() {
        return this.m_projectInfoProvider.getProjectsFromSolution();
    }
}

