/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.treemap;

import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectory;
import com.hello2morrow.sonargraph.core.model.path.TreeMapsDirectory;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.core.persistence.treemap.TreeMapPersistenceMessageCause;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class TreeMapMigration {
    private static final String TREEMAPS = "./Treemaps";

    private TreeMapMigration() {
    }

    public static void migrate(SoftwareSystemDirectory systemDirectory, TreeMapsDirectory targetDirectory, OperationResult result) {
        assert (systemDirectory != null) : "Parameter 'systemDirectory' of method 'migrate' must not be null";
        assert (targetDirectory != null) : "Parameter 'targetDirectory' of method 'migrate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrate' must not be null";
        TFile treeMapsDirectory = new TFile((File)systemDirectory.getDirectoryFile(), TREEMAPS);
        if (!treeMapsDirectory.exists()) {
            return;
        }
        TFile[] files = treeMapsDirectory.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        THashMap successfullyMigrated = new THashMap();
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String nextFileName;
            TFile nextFile = tFileArray[n2];
            if (!nextFile.isDirectory() && (nextFileName = nextFile.getName()).endsWith(".xml")) {
                TreeMapMigration.migrateContent(nextFile, nextFileName, (Map<TFile, String>)successfullyMigrated, result);
            }
            ++n2;
        }
        if (successfullyMigrated.isEmpty()) {
            return;
        }
        int numberOfMigratedFiles = 0;
        for (Map.Entry nextEntry : successfullyMigrated.entrySet()) {
            TFile nextFile = (TFile)nextEntry.getKey();
            try {
                FileUtility.writeFileContent((String)((String)nextEntry.getValue()), (TFile)nextFile);
                result.addInfo((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_FILE_MIGRATED, "Treemap file '" + nextFile.getAbsolutePath() + "' successfully migrated.");
                TrueZipFacade.clear((TFile)nextFile);
                ++numberOfMigratedFiles;
            }
            catch (IOException e) {
                result.addWarning((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_UNABLE_TO_MIGRATE_FILE, (Throwable)e, "Exception caught trying to write migrated content '" + nextFile.getAbsolutePath() + "'.", new Object[0]);
            }
        }
        if (numberOfMigratedFiles != successfullyMigrated.size()) {
            result.addInfo((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_NOT_ALL_FILES_HAVE_BEEN_MIGRATED, successfullyMigrated.size() - numberOfMigratedFiles + "file(s) from your directory './Treemaps' could not be migrated.\nConsider checking them.");
        }
        TrueZipFacade.sync((TFile)treeMapsDirectory);
        TrueZipFacade.sync((TFile)targetDirectory.getDirectoryFile());
    }

    private static void migrateContent(TFile file, String fileName, Map<TFile, String> successfullyMigrated, OperationResult result) {
        assert (file != null) : "Parameter 'file' of method 'migrateContent' must not be null";
        assert (fileName != null) : "Parameter 'fileName' of method 'migrateContent' must not be null";
        assert (successfullyMigrated != null) : "Parameter 'successfullyMigrated' of method 'migrateContent' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrateContent' must not be null";
        ReadTreeMapFileHandler handler = new ReadTreeMapFileHandler();
        try {
            Throwable throwable = null;
            Object var6_10 = null;
            try (TFileInputStream is = new TFileInputStream((File)file);){
                SAXParserFactory.newInstance().newSAXParser().parse((InputStream)is, (DefaultHandler)handler);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, ExceptionUtility.collectAll((Throwable)ioe), new Object[0]);
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)PersistenceCause.UNABLE_TO_PARSE, ExceptionUtility.collectAll((Throwable)ex), new Object[0]);
        }
        if (result.isSuccess() && handler.needsMigration()) {
            try {
                String nextContent = FileUtility.getFileContent((TFile)file);
                if (nextContent.indexOf("</colorSource>") != -1) {
                    String nextMigratedContent = nextContent.replaceAll("</colorSource>", "\t<severity>error</severity>\n\t\t<severity>warning</severity>\n\t\t<severity>info</severity>\n\t</colorSource>");
                    successfullyMigrated.put(file, nextMigratedContent);
                } else {
                    result.addWarning((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_UNABLE_TO_MIGRATE_FILE, "Ignoring '" + fileName + "' - '</colorSource>' not found", new Object[0]);
                }
            }
            catch (IOException e) {
                result.addWarning((OperationResult.IMessageCause)TreeMapPersistenceMessageCause.TREEMAP_UNABLE_TO_MIGRATE_FILE, (Throwable)e, "Exception caught during migration of '" + fileName + "'", new Object[0]);
            }
        }
    }

    private static final class ReadTreeMapFileHandler
    extends DefaultHandler {
        private static final String TREEMAP = "treeMap";
        private static final String VERSION = "version";
        private static final String COLOR_SOURCE = "colorSource";
        private static final String XSD_ISSUE_COLLECTOR = "xsdIssueCollector";
        private static final String SEVERITY = "severity";
        private boolean m_versionIsBefore11;
        private boolean m_containsIssueCollector;
        private boolean m_severityFound;

        ReadTreeMapFileHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            assert (qName != null) : "Parameter 'qName' of method 'startElement' must not be null";
            assert (attributes != null) : "Parameter 'attributes' of method 'startElement' must not be null";
            if (TREEMAP.equals(qName)) {
                String versionAsString = attributes.getValue(VERSION);
                Version version = Version.create((String)versionAsString);
                if (version != null && version.isBefore(Version.create((String)"11.0.0.0"))) {
                    this.m_versionIsBefore11 = true;
                }
            } else if (this.m_versionIsBefore11 && COLOR_SOURCE.equals(qName)) {
                String type = attributes.getValue("xsi:type");
                if (XSD_ISSUE_COLLECTOR.equals(type)) {
                    this.m_containsIssueCollector = true;
                }
            } else if (this.m_containsIssueCollector && !this.m_severityFound && SEVERITY.equals(qName)) {
                this.m_severityFound = true;
            }
        }

        boolean needsMigration() {
            return this.m_versionIsBefore11 && this.m_containsIssueCollector && !this.m_severityFound;
        }
    }
}

