/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.system.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectReferenceInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.IVisualStudioProjectType;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.core.model.system.settings.VisualStudioProjectType;
import com.hello2morrow.sonargraph.core.persistence.system.ModuleImportMessageCause;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.SystemEnvSupport;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolutionFileReader {
    public static final String CONFIGURATION_PlATFORM_SEPARATOR = "\\|";
    private static final Logger LOGGER = LoggerFactory.getLogger(SolutionFileReader.class);
    private static final String ACTIVE_CFG = "ActiveCfg";
    private static final String EQUAL_SIGN_SEPARATOR = "=";
    private static final String CONFIGURATION_PLATFORMS_POST_SOLUTION = "GlobalSection(ProjectConfigurationPlatforms) = postSolution";
    private static final String CONFIGURATION_SOLUTION_PRE_SOLUTION = "GlobalSection(SolutionConfigurationPlatforms) = preSolution";
    private static final String PROJECT_PREFIX = "Project(\"{";
    private final SolutionFileInfo m_solutionFileInfo;

    public static SolutionFileInfo.ConfigurationAndPlatform createConfigurationAndPlatform(String projectConfigurationAndPlatform) {
        assert (projectConfigurationAndPlatform != null) : "Parameter 'projectConfigurationAndPlatform' of method 'createConfigurationAndPlatform' must not be null";
        String[] projectParts = projectConfigurationAndPlatform.trim().split(CONFIGURATION_PlATFORM_SEPARATOR);
        if (projectParts.length != 2) {
            LOGGER.warn("Skipping project configuration '{}', because it does not match the expected format of configuration|platform", (Object)projectConfigurationAndPlatform);
            return null;
        }
        String projectConfiguration = projectParts[0].trim();
        String projectPlatform = projectParts[1].trim();
        if (projectConfiguration.length() == 0 || projectPlatform.length() == 0) {
            LOGGER.warn("Skipping project configuration '{}' with configuration|platform of {}|{}", new Object[]{projectConfigurationAndPlatform, projectConfiguration, projectPlatform});
            return null;
        }
        SolutionFileInfo.ConfigurationAndPlatform configurationAndPlatform = new SolutionFileInfo.ConfigurationAndPlatform(projectConfiguration, projectPlatform);
        return configurationAndPlatform;
    }

    public OperationResultWithOutcome<SolutionFileInfo> read() {
        OperationResultWithOutcome result = new OperationResultWithOutcome("Processing Visual Studio Solution file '" + this.m_solutionFileInfo.getFile().getName() + "'");
        result.setOutcome((Object)this.m_solutionFileInfo);
        boolean isHeader = true;
        boolean isProjectConfigurationElementStarted = false;
        boolean isSolutionConfigurationElementStarted = false;
        StringBuilder header = new StringBuilder();
        try {
            for (String line : FileUtility.getFileLinesWithoutLineBreaks((TFile)this.m_solutionFileInfo.getFile())) {
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("EndGlobalSection")) {
                    if (isProjectConfigurationElementStarted) {
                        isProjectConfigurationElementStarted = false;
                        continue;
                    }
                    if (!isSolutionConfigurationElementStarted) continue;
                    isSolutionConfigurationElementStarted = false;
                    continue;
                }
                if (trimmedLine.startsWith(PROJECT_PREFIX)) {
                    isHeader = false;
                    this.m_solutionFileInfo.setHeaderInfo(header.toString());
                    this.processProject(trimmedLine, (OperationResult)result);
                }
                if (isHeader && trimmedLine.length() > 0) {
                    header.append(trimmedLine).append(StringUtility.LINE_SEPARATOR);
                }
                if (isProjectConfigurationElementStarted) {
                    this.processProjectConfiguration(trimmedLine);
                    continue;
                }
                if (isSolutionConfigurationElementStarted) {
                    String[] parts = trimmedLine.split(EQUAL_SIGN_SEPARATOR);
                    if (parts.length != 2) {
                        LOGGER.warn("line does not match expected format: " + trimmedLine);
                        continue;
                    }
                    if (!parts[0].trim().equals(parts[1].trim())) {
                        LOGGER.warn("Line does not match expected format, expect that the parts of the configuration match");
                        continue;
                    }
                    String configurationName = parts[0].trim();
                    String configurationName2 = parts[1].trim();
                    SolutionFileInfo.ConfigurationAndPlatform configurationAndPlatform = SolutionFileReader.createConfigurationAndPlatform(configurationName2);
                    if (configurationAndPlatform != null) {
                        this.m_solutionFileInfo.addConfigurationPlatformMapping(configurationName, configurationAndPlatform);
                        continue;
                    }
                    LOGGER.warn("Configuration|Platform info '" + configurationName2 + "' does not match expected format.");
                    continue;
                }
                if (trimmedLine.startsWith(CONFIGURATION_SOLUTION_PRE_SOLUTION)) {
                    isSolutionConfigurationElementStarted = true;
                }
                if (!trimmedLine.startsWith(CONFIGURATION_PLATFORMS_POST_SOLUTION)) continue;
                isProjectConfigurationElementStarted = true;
            }
            this.processHeader(header.toString());
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Solution file '" + this.m_solutionFileInfo.getFile().getNormalizedAbsolutePath() + "' could not be processed: " + ExceptionUtility.collectFirstAndLast((Throwable)ex), new Object[0]);
        }
        if (!this.m_solutionFileInfo.hasSharedProjectReferences()) {
            this.validate(this.m_solutionFileInfo, (OperationResult)result);
        }
        return result;
    }

    protected void processHeader(String header) {
        for (String nextLine : StringUtility.multiLineStringToList((String)header)) {
            if (!nextLine.startsWith("VisualStudioVersion")) continue;
            String[] parts = nextLine.split(EQUAL_SIGN_SEPARATOR);
            if (parts.length != 2) {
                LOGGER.warn("line does not match expected format: " + nextLine);
                continue;
            }
            this.m_solutionFileInfo.setVisualStudioVersion(parts[1].trim());
        }
    }

    protected void validate(SolutionFileInfo solutionFileInfo, OperationResult result) {
        assert (solutionFileInfo != null) : "Parameter 'solutionFileInfo' of method 'validate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'validate' must not be null";
        List<SolutionFileInfo.ConfigurationAndPlatform> configurationAndPlatforms = this.m_solutionFileInfo.getConfigurations();
        HashMap<SolutionFileInfo.ConfigurationAndPlatform, IVisualStudioProjectReferenceInfo> problematicConfigurationToProjectMap = new HashMap<SolutionFileInfo.ConfigurationAndPlatform, IVisualStudioProjectReferenceInfo>();
        List<IVisualStudioProjectReferenceInfo> projectReferences = this.m_solutionFileInfo.getProjectReferences();
        for (IVisualStudioProjectReferenceInfo iVisualStudioProjectReferenceInfo : projectReferences) {
            for (SolutionFileInfo.ConfigurationAndPlatform configurationAndPlatform : configurationAndPlatforms) {
                if (this.m_solutionFileInfo.getConfigurationForProject(iVisualStudioProjectReferenceInfo.getProjectKey(), configurationAndPlatform) != null) continue;
                problematicConfigurationToProjectMap.put(configurationAndPlatform, iVisualStudioProjectReferenceInfo);
            }
        }
        if (problematicConfigurationToProjectMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : problematicConfigurationToProjectMap.entrySet()) {
            result.addWarning((OperationResult.IMessageCause)ModuleImportMessageCause.CONFIGURATION_PLATFORM_NOT_FOUND, String.format("Solution configuration '%s' is not mapped to a project configuration for '%s'", ((SolutionFileInfo.ConfigurationAndPlatform)entry.getKey()).toString(), ((IVisualStudioProjectReferenceInfo)entry.getValue()).getName()), new Object[0]);
        }
    }

    private void processProjectConfiguration(String trimmedLine) {
        String[] parts = trimmedLine.split(EQUAL_SIGN_SEPARATOR);
        if (parts.length != 2) {
            LOGGER.error("Expect exactly one equal sign in line '" + trimmedLine + "'");
            return;
        }
        String firstPart = parts[0].trim();
        int endPosProjectKey = firstPart.indexOf(125);
        String projectKey = firstPart.substring(0, endPosProjectKey + 1);
        Optional<IVisualStudioProjectReferenceInfo> reference = this.m_solutionFileInfo.getOmittedReferences().stream().filter(ref -> ref.getProjectKey().equals(projectKey)).findAny();
        if (reference.isPresent()) {
            LOGGER.debug("Skipping processing of project configuration for omitted project: " + reference.get().getName());
            return;
        }
        int endPosConfiguration = firstPart.indexOf(124, endPosProjectKey);
        String configuration = firstPart.substring(endPosProjectKey + 2, endPosConfiguration);
        String platform = firstPart.substring(endPosConfiguration + 1);
        if (!platform.endsWith(ACTIVE_CFG)) {
            return;
        }
        platform = platform.substring(0, platform.length() - (ACTIVE_CFG.length() + 1));
        String projectConfigurationAndPlatform = parts[1].trim();
        SolutionFileInfo.ConfigurationAndPlatform configurationAndPlatform = SolutionFileReader.createConfigurationAndPlatform(projectConfigurationAndPlatform);
        if (configurationAndPlatform == null) {
            LOGGER.error("Failed to process Configuration|Platform");
            return;
        }
        this.m_solutionFileInfo.addConfigurationMapping(new SolutionFileInfo.ConfigurationAndPlatform(configuration, platform), projectKey, configurationAndPlatform);
    }

    public SolutionFileReader(TFile solutionFile) {
        assert (solutionFile != null) : "Parameter 'solutionFile' of method 'CSharpSolutionFileReader' must not be null";
        this.m_solutionFileInfo = new SolutionFileInfo(solutionFile);
    }

    private void processProject(String line, OperationResult result) {
        int[] positions = new int[8];
        int pos = 0;
        int i = 0;
        while (pos > -1 && i < 8) {
            positions[i] = pos = line.indexOf("\"", pos + 1);
            ++i;
        }
        IVisualStudioProjectType currentProjectType = this.getProjectType(line.substring(positions[0] + 1, positions[1]));
        if (currentProjectType == VisualStudioProjectType.SOLUTION_FOLDER) {
            LOGGER.debug("Skipping 'solution folder' project type.");
            return;
        }
        String currentProjectName = line.substring(positions[2] + 1, positions[3]);
        String projectFilePath = line.substring(positions[4] + 1, positions[5]).replace('\\', '/');
        Pair resolvedProjectFilePath = SystemEnvSupport.resolve((String)projectFilePath);
        String currentProjectFilePath = (String)resolvedProjectFilePath.getFirst();
        TFile file = null;
        file = FileUtility.isAbsolutePath((String)currentProjectFilePath) ? new TFile(currentProjectFilePath) : new TFile((File)this.m_solutionFileInfo.getFile().getParentFile().getNormalizedAbsoluteFile(), currentProjectFilePath);
        if (!file.exists()) {
            LOGGER.warn("Skipping not-existing project file: {}", (Object)file.getNormalizedAbsolutePath());
            result.addWarning((OperationResult.IMessageCause)ModuleImportMessageCause.PROJECT_FILE_NOT_FOUND, "Project file '" + file.getNormalizedAbsolutePath() + "' does not exist", new Object[0]);
            return;
        }
        if (file.isDirectory()) {
            LOGGER.info("Skipping directory reference {}", (Object)file.getNormalizedAbsolutePath());
            return;
        }
        if (!this.isAcceptedByFilter(file)) {
            LOGGER.info("Filter rejects reference {}", (Object)file.getNormalizedAbsolutePath());
            return;
        }
        String extension = FileUtility.getExtension((TFile)file);
        if (extension.isEmpty()) {
            LOGGER.info("Skipping project reference without extension: {}", (Object)file.getNormalizedAbsolutePath());
            return;
        }
        if (!extension.endsWith("proj")) {
            LOGGER.info("Skipping project reference of unsupported type: {}", (Object)file.getNormalizedAbsolutePath());
            return;
        }
        String projectKey = line.substring(positions[6] + 1, positions[7]);
        String projectFilePathWithEnvVars = ((String)resolvedProjectFilePath.getFirst()).equals(resolvedProjectFilePath.getSecond()) ? null : (String)resolvedProjectFilePath.getSecond();
        IVisualStudioProjectReferenceInfo projectReference = this.createProjectReference(currentProjectType, currentProjectName, file.getNormalizedAbsoluteFile(), projectFilePathWithEnvVars);
        projectReference.setProjectKey(projectKey);
        if (projectReference.getProjectType() == VisualStudioProjectType.SOLUTION_FOLDER) {
            return;
        }
        if (this.isSharedProject(projectReference)) {
            this.m_solutionFileInfo.addSharedProjectReference(projectReference);
        } else if (!this.isValidProjectType(projectReference)) {
            result.addWarning((OperationResult.IMessageCause)ModuleImportMessageCause.UNSUPPORTED_PROJECT_TYPE, "Project type '" + projectReference.getProjectType().getPresentationName() + "' is not supported," + StringUtility.LINE_SEPARATOR + "project '" + projectReference.getFile().getPath() + "' will be excluded.", new Object[0]);
            this.m_solutionFileInfo.addOmittedReference(projectReference);
        } else if (!this.isValidProjectFileExtension(FileUtility.getExtension((TFile)projectReference.getFile()))) {
            result.addWarning((OperationResult.IMessageCause)ModuleImportMessageCause.UNSUPPORTED_FILE_EXTENSION, "File extension '" + FileUtility.getExtension((TFile)projectReference.getFile()) + "' is not supported," + StringUtility.LINE_SEPARATOR + "project '" + projectReference.getFile().getPath() + "' will be excluded.", new Object[0]);
            this.m_solutionFileInfo.addOmittedReference(projectReference);
        } else if (this.isDuplicateNameOrAssemblyNameOrProjectKey(this.m_solutionFileInfo, projectReference)) {
            result.addWarning((OperationResult.IMessageCause)ModuleImportMessageCause.DUPLICATE_PROJECT, "Project file excluded: '" + projectReference.getFile().getPath() + "' - duplicate name, assembly name, or project key.", new Object[0]);
            this.m_solutionFileInfo.addOmittedReference(projectReference);
        } else {
            this.m_solutionFileInfo.addProjectReference(projectReference);
        }
    }

    protected boolean isAcceptedByFilter(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isFiltered' must not be null";
        return true;
    }

    protected abstract boolean isDuplicateNameOrAssemblyNameOrProjectKey(SolutionFileInfo var1, IVisualStudioProjectReferenceInfo var2);

    protected abstract boolean isValidProjectFileExtension(String var1);

    protected boolean isSharedProject(IVisualStudioProjectReferenceInfo projectReference) {
        assert (projectReference != null) : "Parameter 'projectReference' of method 'isSharedProject' must not be null";
        return false;
    }

    protected abstract boolean isValidProjectType(IVisualStudioProjectReferenceInfo var1);

    protected abstract IVisualStudioProjectReferenceInfo createProjectReference(IVisualStudioProjectType var1, String var2, TFile var3, String var4);

    protected abstract IVisualStudioProjectType getProjectType(String var1);
}

